/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEDLCITable;
import COM.livingston.model.LEDialScript;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class LELocationFileParser {
    private static final String ANALOG_STRING = "set\\s+loc\\w*\\s+(\\w+)\\s+an\\w*\\s+(\\w+)";
    private static final String CHAP_STRING = "set loc\\w* (\\w+) ch\\w* (\\w+)";
    private static final String COMPRESSION_STRING = "set loc\\w* (\\w+) co\\w* (\\w+)";
    private static final String DESTINATION_STRING = "set loc\\w* (\\w+) de\\w* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String GROUP_STRING = "set loc\\w* (\\w+) gr\\w* (\\d+)";
    private static final String HIGHWATER_STRING = "set loc\\w* (\\w+) hi\\w* (\\d+)";
    private static final String IDLETIMEOUT_STRING = "set loc\\w* (\\w+) id\\w* (\\d+) (\\w*)";
    private static final String INPUTFILTER_STRING = "set loc\\w* (\\w+) if\\w* (\\S+)";
    private static final String IPXNETWORK_STRING = "set loc\\w* (\\w+) ipx\\w* (\\w+)";
    private static final String LOCALADDR_STRING = "set loc\\w* (\\w+) lo\\S* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String MAP_STRING = "set loc\\w* (\\w+) map\\w* (\\S+)";
    private static final String MAXPORTS_STRING = "set loc\\w* (\\w+) max\\w* (\\d+)";
    private static final String MTU_STRING = "set loc\\w* (\\w+) mt\\w* (\\d+)";
    private static final String MULTILINK_STRING = "set loc\\w* (\\w+) mu\\w* (\\w+)";
    private static final String NAT_INMAP_STRING = "set loc\\w* (\\w+) nat i\\w*map (\\w*)\\s*(\\w*)";
    private static final String NAT_PROXY_INMAP_STRING = "set loc\\w* (\\w+) nat i\\w*map (\\w*) pr\\w*";
    private static final String NAT_OUTMAP_STRING = "set loc\\w* (\\w+) nat o\\w*map (\\w*)\\s*(\\w*)";
    private static final String NAT_PROXY_OUTMAP_STRING = "set loc\\w* (\\w+) nat o\\w*map (\\w*) pr\\w*";
    private static final String NAT_LOG_CONSOLE_STRING = "set loc\\w* (\\w+) nat log cons\\w* (\\w*)";
    private static final String NAT_LOG_SYSLOG_STRING = "set loc\\w* (\\w+) nat log s\\w*l\\w* (\\w*)";
    private static final String NAT_LOG_SUCCESS_STRING = "set loc\\w* (\\w+) nat log ss\\w* (\\w*)";
    private static final String NAT_LOG_SUCCESS_STRING2 = "set loc\\w* (\\w+) nat log sessions\\w* (\\w*)";
    private static final String NAT_LOG_FAIL_STRING = "set loc\\w* (\\w+) nat log sf\\w* (\\w*)";
    private static final String NAT_LOG_FAIL_STRING2 = "set loc\\w* (\\w+) nat log sessionf\\w* (\\w*)";
    private static final String NAT_TIMEOUT_STRING = "set loc\\w* (\\w+) nat s\\w*t\\w*o\\w* (\\w+) (\\d{1,5}) (\\w*)";
    private static final String NAT_FAILURE_STRING = "set loc\\w* (\\w+) nat s\\w*d\\w*f\\w*a\\w* (\\w+)";
    private static final String NETMASK_STRING = "set loc\\w* (\\w+) ne\\w* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String OUTPUTFILTER_STRING = "set loc\\w* (\\w+) of\\w* (\\S+)";
    private static final String OSPF_STRING = "set loc\\w* (\\w+) os\\w*\\s*.";
    private static final String PASSWORD_STRING = "set loc\\w* (\\w+) pa\\w* (\\S+)";
    private static final String PHONE_STRING = "set loc\\w* (\\w+) ph\\w* (\\S+)";
    private static final String PROTOCOL_STRING = "set loc\\w* (\\w+) pr\\w* (\\S+)";
    private static final String RIP_STRING = "set loc\\w* (\\w+) ri\\w* (\\w+)";
    private static final String SCRIPT_STRING = "set loc\\w* (\\w+) sc\\w* (\\d+)\\s*(\\S*)\\s*(\\S*)";
    private static final String TELEPHONE_STRING = "set loc\\w* (\\w+) te\\w* (\\S+)";
    private static final String USERNAME_STRING = "set loc\\w* (\\w+) us\\w* (\\S+)";
    private static final String VOICE_STRING = "set loc\\w* (\\w+) vo\\w* (\\w+)";
    private static final String V25BIS_STRING = "set loc\\w* (\\w+) v25\\w* (\\d+)\\s*(\\S*)\\s*(\\S*)";
    LELocations m_locations = new LELocations(null);
    LELocation m_location;
    String m_locname = "";
    Perl5Matcher m_matcher = new Perl5Matcher();
    MatchResult m_result;
    Perl5Pattern m_analogPattern;
    Perl5Pattern m_chapPattern;
    Perl5Pattern m_compressionPattern;
    Perl5Pattern m_destinationPattern;
    Perl5Pattern m_groupPattern;
    Perl5Pattern m_highPattern;
    Perl5Pattern m_idlePattern;
    Perl5Pattern m_ifilterPattern;
    Perl5Pattern m_ipxnetPattern;
    Perl5Pattern m_localPattern;
    Perl5Pattern m_mapPattern;
    Perl5Pattern m_maxPattern;
    Perl5Pattern m_mtuPattern;
    Perl5Pattern m_multiPattern;
    Perl5Pattern m_natimapPattern;
    Perl5Pattern m_natimapproxyPattern;
    Perl5Pattern m_natomapPattern;
    Perl5Pattern m_natomapproxyPattern;
    Perl5Pattern m_natlogsysPattern;
    Perl5Pattern m_natlogconPattern;
    Perl5Pattern m_natlogssPattern;
    Perl5Pattern m_natlogssPattern2;
    Perl5Pattern m_natlogsfPattern;
    Perl5Pattern m_natlogsfPattern2;
    Perl5Pattern m_natfailPattern;
    Perl5Pattern m_nattimeoutPattern;
    Perl5Pattern m_netmaskPattern;
    Perl5Pattern m_ofilterPattern;
    Perl5Pattern m_ospfPattern;
    Perl5Pattern m_passwordPattern;
    Perl5Pattern m_phonePattern;
    Perl5Pattern m_protocolPattern;
    Perl5Pattern m_ripPattern;
    Perl5Pattern m_scriptPattern;
    Perl5Pattern m_telePattern;
    Perl5Pattern m_userPattern;
    Perl5Pattern m_voicePattern;
    Perl5Pattern m_v25bisPattern;

    public boolean createPatterns() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_analogPattern = (Perl5Pattern)compiler.compile(ANALOG_STRING, 1);
            this.m_chapPattern = (Perl5Pattern)compiler.compile(CHAP_STRING, 1);
            this.m_compressionPattern = (Perl5Pattern)compiler.compile(COMPRESSION_STRING, 1);
            this.m_destinationPattern = (Perl5Pattern)compiler.compile(DESTINATION_STRING, 1);
            this.m_groupPattern = (Perl5Pattern)compiler.compile(GROUP_STRING, 1);
            this.m_highPattern = (Perl5Pattern)compiler.compile(HIGHWATER_STRING, 1);
            this.m_idlePattern = (Perl5Pattern)compiler.compile(IDLETIMEOUT_STRING, 1);
            this.m_ifilterPattern = (Perl5Pattern)compiler.compile(INPUTFILTER_STRING, 1);
            this.m_ipxnetPattern = (Perl5Pattern)compiler.compile(IPXNETWORK_STRING, 1);
            this.m_localPattern = (Perl5Pattern)compiler.compile(LOCALADDR_STRING, 1);
            this.m_mapPattern = (Perl5Pattern)compiler.compile(MAP_STRING, 1);
            this.m_maxPattern = (Perl5Pattern)compiler.compile(MAXPORTS_STRING, 1);
            this.m_mtuPattern = (Perl5Pattern)compiler.compile(MTU_STRING, 1);
            this.m_multiPattern = (Perl5Pattern)compiler.compile(MULTILINK_STRING, 1);
            this.m_natimapPattern = (Perl5Pattern)compiler.compile(NAT_INMAP_STRING, 1);
            this.m_natimapproxyPattern = (Perl5Pattern)compiler.compile(NAT_PROXY_INMAP_STRING, 1);
            this.m_natomapPattern = (Perl5Pattern)compiler.compile(NAT_OUTMAP_STRING, 1);
            this.m_natomapproxyPattern = (Perl5Pattern)compiler.compile(NAT_PROXY_OUTMAP_STRING, 1);
            this.m_natlogsysPattern = (Perl5Pattern)compiler.compile(NAT_LOG_SYSLOG_STRING, 1);
            this.m_natlogconPattern = (Perl5Pattern)compiler.compile(NAT_LOG_CONSOLE_STRING, 1);
            this.m_natlogssPattern = (Perl5Pattern)compiler.compile(NAT_LOG_SUCCESS_STRING, 1);
            this.m_natlogssPattern2 = (Perl5Pattern)compiler.compile(NAT_LOG_SUCCESS_STRING2, 1);
            this.m_natlogsfPattern = (Perl5Pattern)compiler.compile(NAT_LOG_FAIL_STRING, 1);
            this.m_natlogsfPattern2 = (Perl5Pattern)compiler.compile(NAT_LOG_FAIL_STRING2, 1);
            this.m_natfailPattern = (Perl5Pattern)compiler.compile(NAT_FAILURE_STRING, 1);
            this.m_nattimeoutPattern = (Perl5Pattern)compiler.compile(NAT_TIMEOUT_STRING, 1);
            this.m_netmaskPattern = (Perl5Pattern)compiler.compile(NETMASK_STRING, 1);
            this.m_ofilterPattern = (Perl5Pattern)compiler.compile(OUTPUTFILTER_STRING, 1);
            this.m_ospfPattern = (Perl5Pattern)compiler.compile(OSPF_STRING, 1);
            this.m_passwordPattern = (Perl5Pattern)compiler.compile(PASSWORD_STRING, 1);
            this.m_phonePattern = (Perl5Pattern)compiler.compile(PHONE_STRING, 1);
            this.m_protocolPattern = (Perl5Pattern)compiler.compile(PROTOCOL_STRING, 1);
            this.m_ripPattern = (Perl5Pattern)compiler.compile(RIP_STRING, 1);
            this.m_scriptPattern = (Perl5Pattern)compiler.compile(SCRIPT_STRING, 1);
            this.m_telePattern = (Perl5Pattern)compiler.compile(TELEPHONE_STRING, 1);
            this.m_userPattern = (Perl5Pattern)compiler.compile(USERNAME_STRING, 1);
            this.m_voicePattern = (Perl5Pattern)compiler.compile(VOICE_STRING, 1);
            this.m_v25bisPattern = (Perl5Pattern)compiler.compile(V25BIS_STRING, 1);
        }
        catch (MalformedPatternException e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public void readLocations(LEVector cmds) {
        int len = cmds.size();
        try {
            int i = 0;
            while (i < len) {
                String line = (String)cmds.elementAt(i);
                if (!line.startsWith("#") && line.length() >= 3 && !line.equals("save all")) {
                    int strlen = line.length();
                    String begin = line.substring(3, strlen).toLowerCase();
                    if (line.regionMatches(true, 0, "add ", 0, 4)) {
                        if (line.indexOf("dlci") > -1) {
                            this.addDLCITable(line);
                        } else if (line.indexOf("location") > -1) {
                            this.addLocation(line);
                        }
                    } else if (line.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseLocation(line);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public LELocations getLocations() {
        return this.m_locations;
    }

    public void writeLocations(PrintStream stream) {
        LEVector cmds = new LEVector();
        this.m_locations.getCommands(cmds);
        int len = cmds.size() - 1;
        int i = 0;
        while (i < len) {
            String command = (String)cmds.elementAt(i);
            stream.println(command);
            ++i;
        }
    }

    protected void addLocation(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        tokenizer.nextToken();
        String locname = tokenizer.nextToken();
        LELocation location = new LELocation(null, locname);
        location.initialize();
        this.m_locations.setField(locname, location);
        this.m_locname = locname;
        this.m_location = location;
    }

    protected void addDLCITable(String line) {
        System.out.println("in add dlci");
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        String dlcitype = tokenizer.nextToken().toLowerCase();
        String locname = tokenizer.nextToken();
        LELocation location = (LELocation)this.m_locations.getConfig(locname);
        LEDLCITable dlcitable = null;
        if (dlcitype.startsWith("dlc") || dlcitype.startsWith("ipd")) {
            dlcitable = (LEDLCITable)location.getConfig("ipdlci");
        } else if (dlcitype.startsWith("ipxd")) {
            dlcitable = (LEDLCITable)location.getConfig("ipxdlci");
        }
        String num = tokenizer.nextToken();
        String address = tokenizer.nextToken();
        if (dlcitable != null) {
            System.out.println("set field " + dlcitype + " " + num + " " + address);
            dlcitable.setField(num, address);
        }
    }

    protected void parseLocation(String locparam) {
        try {
            if (this.m_matcher.contains(locparam, (Pattern)this.m_analogPattern)) {
                this.setParameter("292", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_chapPattern)) {
                this.setParameter("170", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_compressionPattern)) {
                this.setParameter("290", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_destinationPattern)) {
                String address = this.setAddressParameter("9", this.m_matcher.getMatch());
                if (address.equals("255.255.255.255")) {
                    this.m_location.setField("74", "negotiated");
                } else {
                    this.m_location.setField("74", "specified");
                }
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_groupPattern)) {
                this.setParameter("129", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_highPattern)) {
                this.setParameter("298", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_idlePattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String idletime = result.group(2);
                String scale = result.group(3);
                StringBuffer buffer = new StringBuffer(idletime);
                buffer.append(" ");
                if (scale != null) {
                    buffer.append(scale);
                } else {
                    buffer.append("minutes");
                }
                this.setLocation(result);
                this.m_location.setField("297", buffer.toString());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ifilterPattern)) {
                this.setParameter("193", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipxnetPattern)) {
                this.setParameter("189", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_localPattern)) {
                this.setAddressParameter("177", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_mapPattern)) {
                this.setParameter("299", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_maxPattern)) {
                this.setParameter("296", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_mtuPattern)) {
                this.setParameter("295", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_multiPattern)) {
                this.setParameter("291", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_netmaskPattern)) {
                this.setAddressParameter("15", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natimapPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String proxy = result.group(3);
                if (proxy != null && proxy.startsWith("pr")) {
                    this.setNATParameter("357", result);
                } else {
                    this.setNATParameter("356", result);
                }
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natimapproxyPattern)) {
                this.setNATParameter("357", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natomapPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String proxy = result.group(3);
                if (proxy != null && proxy.startsWith("pr")) {
                    this.setNATParameter("359", result);
                } else {
                    this.setNATParameter("358", result);
                }
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natomapproxyPattern)) {
                this.setNATParameter("359", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogsysPattern)) {
                this.setNATParameter("362", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogconPattern)) {
                this.setNATParameter("363", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogssPattern) || this.m_matcher.contains(locparam, (Pattern)this.m_natlogssPattern2)) {
                this.setNATParameter("361", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogsfPattern) || this.m_matcher.contains(locparam, (Pattern)this.m_natlogsfPattern2)) {
                this.setNATParameter("360", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natfailPattern)) {
                this.setNATParameter("355", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_nattimeoutPattern)) {
                this.setNATTimeoutParameter(this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ofilterPattern)) {
                this.setParameter("194", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ospfPattern)) {
                this.setOSPFParameters(locparam);
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_passwordPattern)) {
                this.setParameter("300", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ripPattern)) {
                this.setRIPParameter(this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_scriptPattern)) {
                this.setScriptParameter("script", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_phonePattern) || this.m_matcher.contains(locparam, (Pattern)this.m_telePattern)) {
                this.setParameter("301", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_protocolPattern)) {
                this.setParameter("289", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_userPattern)) {
                this.setParameter("2", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_voicePattern)) {
                this.setParameter("293", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_v25bisPattern)) {
                this.setScriptParameter("v25bis", this.m_matcher.getMatch());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected void setLocation(MatchResult result) {
        String locname = result.group(1);
        if (!locname.equals(this.m_locname)) {
            this.m_location = (LELocation)this.m_locations.get(locname);
            this.m_locname = locname;
        }
    }

    protected void setParameter(String attribute, MatchResult result) {
        this.setLocation(result);
        String group2 = result.group(2);
        if (group2 != null) {
            this.m_location.setField(attribute, result.group(2));
        }
    }

    protected String setAddressParameter(String attribute, MatchResult result) {
        this.setLocation(result);
        String oct1 = result.group(2);
        String oct2 = result.group(3);
        String oct3 = result.group(4);
        String oct4 = result.group(5);
        StringBuffer address = new StringBuffer();
        address.append(oct1);
        address.append(".");
        address.append(oct2);
        address.append(".");
        address.append(oct3);
        address.append(".");
        address.append(oct4);
        this.m_location.setField(attribute, address.toString());
        return address.toString();
    }

    protected void setNATParameter(String attribute, MatchResult result) {
        String group2;
        this.setLocation(result);
        String inmap = (String)this.m_location.get("356");
        if (inmap == null) {
            this.m_location.initializeNAT();
        }
        if ((group2 = result.group(2)) != null) {
            this.m_location.setField(attribute, group2);
        }
    }

    protected void setNATTimeoutParameter(MatchResult result) {
        this.setLocation(result);
        String inmap = (String)this.m_location.get("356");
        if (inmap == null) {
            this.m_location.initializeNAT();
        }
        String type = result.group(2);
        String time = result.group(3);
        String scale = result.group(4);
        String timescale = scale == null ? new String(" minutes") : new String(" " + scale);
        if (type != null) {
            if (type.equals("tcp")) {
                this.m_location.setField("353", String.valueOf(time) + timescale);
            } else if (type.equals("other")) {
                this.m_location.setField("354", String.valueOf(time) + timescale);
            }
        }
    }

    protected void setScriptParameter(String attribute, MatchResult result) {
        this.setLocation(result);
        String numstr = result.group(2);
        String expect = "expect";
        String send = "send";
        String sendstr = result.group(3);
        String recvstr = result.group(4);
        if (sendstr != null && recvstr != null) {
            LEDialScript dial = (LEDialScript)this.m_location.getConfig(attribute);
            dial.setField(String.valueOf(send) + numstr, sendstr);
            dial.setField(String.valueOf(expect) + numstr, recvstr);
        }
    }

    protected void setRIPParameter(MatchResult result) {
        this.setLocation(result);
        String rip = result.group(2).toLowerCase();
        if (rip.startsWith("br")) {
            this.m_location.setField("187", "on");
            this.m_location.setField("188", "off");
        } else if (rip.startsWith("li")) {
            this.m_location.setField("187", "off");
            this.m_location.setField("188", "on");
        } else if (rip.startsWith("of")) {
            this.m_location.setField("187", "off");
            this.m_location.setField("188", "off");
        } else if (rip.equals("on")) {
            this.m_location.setField("187", "on");
            this.m_location.setField("188", "on");
        }
    }

    protected void setOSPFParameters(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        tokenizer.nextToken();
        String locname = tokenizer.nextToken();
        tokenizer.nextToken();
        String status = tokenizer.nextToken();
        LELocation location = (LELocation)this.m_locations.get(locname);
        if (location != null) {
            if (location.get("246") == null) {
                location.initializeOSPF();
            }
            location.setField("246", status);
            while (tokenizer.hasMoreTokens()) {
                String attribute = tokenizer.nextToken().toLowerCase();
                if (attribute.startsWith("co")) {
                    location.setField("242", tokenizer.nextToken());
                    continue;
                }
                if (attribute.startsWith("he")) {
                    location.setField("243", tokenizer.nextToken());
                    continue;
                }
                if (attribute.startsWith("de")) {
                    location.setField("244", tokenizer.nextToken());
                    continue;
                }
                if (!attribute.startsWith("po") && !attribute.startsWith("nb") && !attribute.startsWith("wa")) continue;
                location.setField("245", attribute);
            }
        }
    }
}

