/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LENATMapRule;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;
import java.util.Enumeration;

public class LENATMap
extends LETable {
    public static final String DEFAULT_MAP = "defaultnapt";
    String m_name;

    public LENATMap(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
    }

    public Object clone() {
        LENATMap config = new LENATMap(this.m_facility, this.m_name);
        config.copy(this);
        return config;
    }

    public LEVector add(String type, String lhs, String rhs, boolean log) {
        LEPMCommand ret;
        LEVector errors = null;
        int num = this.size() + 1;
        StringBuffer buf = new StringBuffer("set ");
        buf.append(" map ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(num);
        buf.append(" ");
        buf.append(type);
        buf.append(" ");
        buf.append(lhs);
        buf.append(" ");
        buf.append(rhs);
        if (log) {
            buf.append(" log");
        }
        if ((ret = this.m_facility.execute(new String(buf))).getStatus()) {
            ret = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(int ruleNum) {
        int numRules = this.size();
        if (ruleNum > numRules) {
            return null;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("map ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(ruleNum);
        LEVector errors = null;
        LEPMCommand ret = this.m_facility.execute(new String(buf));
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        this.refresh();
        return errors;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
        Enumeration enumeration = this.m_fields.elements();
        while (enumeration.hasMoreElements()) {
            ((LENATMapRule)enumeration.nextElement()).setName(this.m_name);
        }
    }

    LEConfig createConfig(String key) {
        return new LENATMapRule(this.m_facility, this.m_name, key);
    }
}

