/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LENetUser
extends LEConfig {
    public static final String ADDRESS = "IPAddress";
    public static final String ASYNC_MAP = "299";
    public static final String COMPRESSION = "290";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String DESTINATION = "destination";
    public static final String HELLOINTERVAL = "243";
    public static final String IDLE_TIMEOUT = "129";
    public static final String INPUT_FILTER = "193";
    public static final String IPX_NETWORK = "189";
    public static final String LOCAL_IP = "177";
    public static final String MAX_PORTS = "296";
    public static final String MIGRATION = "241";
    public static final String MTU = "295";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String PASSWORD = "password";
    public static final String PROTOCOL = "289";
    public static final String RIP_BROAD = "187";
    public static final String RIP_LISTEN = "188";
    public static final String SESSION_LIMIT = "371";
    public static final String WANTYPE = "245";
    public static final int KEY_COUNT = 34;
    public static final String USER = "user";
    public static final String ASSIGNED = "assigned";
    public static final String NEGOTIATED = "negotiated";
    public static final String SPECIFIED = "specified";
    public static final String PPP = "ppp";
    public static final String SLIP = "slip";
    public static final String MINUTES = "minutes";
    public static final String SECONDS = "seconds";
    static String[] s_keys = null;
    String m_name;
    String m_tag;
    boolean m_passwordFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[34];
            int i = 0;
            LENetUser.s_keys[i++] = ADDRESS;
            LENetUser.s_keys[i++] = ASYNC_MAP;
            LENetUser.s_keys[i++] = COMPRESSION;
            LENetUser.s_keys[i++] = COST;
            LENetUser.s_keys[i++] = DEADTIME;
            LENetUser.s_keys[i++] = DESTINATION;
            LENetUser.s_keys[i++] = HELLOINTERVAL;
            LENetUser.s_keys[i++] = IDLE_TIMEOUT;
            LENetUser.s_keys[i++] = INPUT_FILTER;
            LENetUser.s_keys[i++] = IPX_NETWORK;
            LENetUser.s_keys[i++] = LOCAL_IP;
            LENetUser.s_keys[i++] = MAX_PORTS;
            LENetUser.s_keys[i++] = MIGRATION;
            LENetUser.s_keys[i++] = MTU;
            LENetUser.s_keys[i++] = NAT_TCP_TIMEOUT;
            LENetUser.s_keys[i++] = NAT_OTHER_TIMEOUT;
            LENetUser.s_keys[i++] = NAT_FAIL_ACTION;
            LENetUser.s_keys[i++] = NAT_IN_MAP;
            LENetUser.s_keys[i++] = NAT_PROXY_IN_MAP;
            LENetUser.s_keys[i++] = NAT_OUT_MAP;
            LENetUser.s_keys[i++] = NAT_PROXY_OUT_MAP;
            LENetUser.s_keys[i++] = NAT_LOG_FAILURE;
            LENetUser.s_keys[i++] = NAT_LOG_SUCCESS;
            LENetUser.s_keys[i++] = NAT_LOG_SYSLOG;
            LENetUser.s_keys[i++] = NAT_LOG_CONSOLE;
            LENetUser.s_keys[i++] = NETMASK;
            LENetUser.s_keys[i++] = OSPF_STATUS;
            LENetUser.s_keys[i++] = OUTPUT_FILTER;
            LENetUser.s_keys[i++] = PASSWORD;
            LENetUser.s_keys[i++] = PROTOCOL;
            LENetUser.s_keys[i++] = RIP_BROAD;
            LENetUser.s_keys[i++] = RIP_LISTEN;
            LENetUser.s_keys[i++] = SESSION_LIMIT;
            LENetUser.s_keys[i++] = WANTYPE;
        }
        return s_keys;
    }

    public LENetUser(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
        this.m_tag = "user " + this.m_name;
    }

    public Object clone() {
        LENetUser config = new LENetUser(this.m_facility, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    void setPassword(String password) {
        this.m_passwordFetched = true;
        this.setField(PASSWORD, password);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS) || keys.contains(DESTINATION)) {
            String dest = (String)this.get(DESTINATION);
            if (dest != null && dest.equals(SPECIFIED)) {
                this.makeSetCommand(cmds, this.m_tag, ADDRESS, DESTINATION);
            } else {
                this.makeSetCommand(cmds, this.m_tag, DESTINATION, DESTINATION);
            }
        }
        if (allCmds || keys.contains(ASYNC_MAP)) {
            this.makeSetCommand(cmds, this.m_tag, ASYNC_MAP, "map");
        }
        if (allCmds || keys.contains(COMPRESSION)) {
            this.makeSetCommand(cmds, this.m_tag, COMPRESSION, "compression");
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, "idle");
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, INPUT_FILTER, "ifilter");
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_tag, IPX_NETWORK, "ipxnet");
        }
        if (allCmds || keys.contains(LOCAL_IP)) {
            this.makeSetCommand(cmds, this.m_tag, LOCAL_IP, "local-ip-address");
        }
        if (allCmds || keys.contains(MAX_PORTS)) {
            this.makeSetCommand(cmds, this.m_tag, MAX_PORTS, "maxports");
        }
        if (allCmds || keys.contains(MTU)) {
            this.makeSetCommand(cmds, this.m_tag, MTU, "mtu");
        }
        if (allCmds || keys.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_tag, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_tag, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(cmds, this.m_tag, NAT_FAIL_ACTION);
        }
        if (allCmds || keys.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_IN_MAP, true, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_PROXY_IN_MAP, true, true);
        }
        if (allCmds || keys.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_OUT_MAP, false, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_PROXY_OUT_MAP, false, true);
        }
        if (allCmds || keys.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (allCmds || keys.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_tag, NETMASK, "netmask");
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, OUTPUT_FILTER, "ofilter");
        }
        if (allCmds && this.m_passwordFetched) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
        } else if (!allCmds && keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
        }
        if (allCmds || keys.contains(PROTOCOL)) {
            this.makeSetCommand(cmds, this.m_tag, PROTOCOL, "protocol");
        }
        if (allCmds || keys.contains(SESSION_LIMIT)) {
            this.makeSetCommand(cmds, this.m_tag, SESSION_LIMIT, "session-limit");
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_tag, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        if ((allCmds || keys.contains(OSPF_STATUS)) && this.get(OSPF_STATUS) != null) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("set ");
            buf.append(" ");
            buf.append(this.m_tag);
            buf.append(" ospf ");
            String status = (String)this.get(OSPF_STATUS);
            buf.append(status);
            if (status.equals("on")) {
                String wantype;
                String dead;
                String hello;
                String migration;
                String cost = (String)this.get(COST);
                if (cost != null && cost.length() > 0) {
                    buf.append(" cost ");
                    buf.append(cost);
                }
                if ((migration = (String)this.get(MIGRATION)) != null && migration.length() > 0) {
                    buf.append(" accept-rip ");
                    buf.append(migration);
                }
                if ((hello = (String)this.get(HELLOINTERVAL)) != null && hello.length() > 0) {
                    buf.append(" hello-interval ");
                    buf.append(hello);
                }
                if ((dead = (String)this.get(DEADTIME)) != null && dead.length() > 0) {
                    buf.append(" dead-time ");
                    buf.append(dead);
                }
                if ((wantype = (String)this.get(WANTYPE)) != null && wantype.length() > 0) {
                    buf.append(" ");
                    buf.append(wantype);
                }
            }
            buf.append(" ");
            cmds.add(new String(buf));
        }
        return cmds.size() > start;
    }
}

