/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEOSPFArea;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEOSPFAreas
extends LETable {
    public LEOSPFAreas(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEOSPFAreas config = new LEOSPFAreas(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String area) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("ospf area", area);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String area) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("ospf area", area);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            this.remove(area);
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEOSPFArea(this.m_facility, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("ospf area", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("ospf area", key));
        return true;
    }

    boolean getChangedCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getChangedCommands(cmds);
        if (gen) {
            this.checkCommands(cmds, start);
        }
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getAllCommands(cmds);
        if (gen) {
            this.checkCommands(cmds, start);
        }
        return gen;
    }

    void checkCommands(LEVector cmds, int start) {
        int end = cmds.size();
        int reset = -1;
        int save = -1;
        int i = start;
        while (i < end) {
            String cmd = (String)cmds.elementAt(i);
            if (cmd.equals("reset ospf")) {
                if (reset > 0) {
                    cmds.removeElementAt(reset);
                    --end;
                    --save;
                }
                reset = --i;
            } else if (cmd.equals("save all")) {
                save = i;
            }
            ++i;
        }
    }
}

