/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEPMEntityParser;
import COM.livingston.model.LEPMOldParser;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;

public class LEPMConfigFacility
implements LEConfigFacility,
Runnable {
    LEPortMaster m_pm;
    Thread m_thread;

    public LEPMConfigFacility(LEPortMaster pm) {
        this.m_pm = pm;
    }

    public String getDescription() {
        return this.m_pm.getHostname();
    }

    public boolean getConfig(String key) {
        return this.getConfig(key, null);
    }

    public boolean getConfig(String key, String board_id) {
        LEDSSPortMaster dss = this.m_pm.getDSS();
        if (dss == null) {
            return false;
        }
        boolean success = false;
        if (board_id == null) {
            if (dss.supportsEntities() && (!key.equals("2162688") || this.globalEntityOkay())) {
                success = LEPMEntityParser.Parse(key, dss, this.m_pm);
            }
            if (!success) {
                success = LEPMOldParser.Parse(key, dss, this.m_pm);
            }
        } else if (dss.supportsEntities()) {
            success = LEPMEntityParser.Parse(key, board_id, dss, this.m_pm);
        }
        return success;
    }

    public boolean getUserPasswords() {
        if (!this.m_pm.supports(0x310000)) {
            return false;
        }
        LEConfig config = (LEConfig)this.m_pm.get("1835008");
        if (config == null) {
            return true;
        }
        String send = Integer.toString(0x310000);
        return LEPMEntityParser.Parse(this.m_pm.getDSS(), config, send, send);
    }

    public boolean getSecrets() {
        if (!this.m_pm.supports(0x320000)) {
            return false;
        }
        this.m_pm.get("2228224");
        this.m_pm.get("1507328");
        String send = Integer.toString(0x320000);
        return LEPMEntityParser.Parse(this.m_pm.getDSS(), this.m_pm, send, send);
    }

    public LEPMCommand execute(String command) {
        String model;
        LEDSSPortMaster dss = this.m_pm.getDSS();
        if (dss == null) {
            return null;
        }
        LEStatusManager.SetStatus(command);
        LEPMCommand ret = dss.execute(command);
        if (LEPMCommand.IsReboot(command) && (model = this.m_pm.getHardwareType()) != null && model.equals("PM-4")) {
            this.checkForBoards();
        }
        if (LEPMCommand.IsPowerOn(command) && this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
        return ret;
    }

    public void run() {
        try {
            this.checkForBoards();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.m_thread = null;
    }

    void checkForBoards() {
        LEBoards boards = (LEBoards)this.m_pm.get("2555904");
        if (boards == null) {
            return;
        }
        LEVector keys = boards.getKeys();
        int len = keys.size();
        boolean wait = true;
        while (wait) {
            boards.refresh();
            wait = false;
            int i = 0;
            while (!wait && i < len) {
                LEBoard board = (LEBoard)boards.get((String)keys.elementAt(i));
                if (board != null && board.isPoweringUp()) {
                    wait = true;
                }
                ++i;
            }
            if (!wait) continue;
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
    }

    boolean globalEntityOkay() {
        boolean okay;
        block4: {
            okay = true;
            String ver = this.m_pm.getSoftwareVersion();
            if (!ver.startsWith("3.8b")) break block4;
            String sub = ver.substring(4);
            int index = sub.indexOf(47);
            if (index > -1) {
                sub = sub.substring(0, index);
            }
            try {
                int rel = Integer.parseInt(sub);
                if (rel < 18) {
                    okay = false;
                }
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return okay;
    }
}

