/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LESendResponse;
import COM.livingston.model.LEAsyncPort;
import COM.livingston.model.LEAsyncPorts;
import COM.livingston.model.LEBGPPeer;
import COM.livingston.model.LEBGPPolicy;
import COM.livingston.model.LEBGPPolicyRule;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEChoicenet;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDBNetUser;
import COM.livingston.model.LEDLCI;
import COM.livingston.model.LEDLCITable;
import COM.livingston.model.LEDialScript;
import COM.livingston.model.LEEthernet;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LEGroups;
import COM.livingston.model.LEHost;
import COM.livingston.model.LEHostOverrides;
import COM.livingston.model.LEHosts;
import COM.livingston.model.LEISDNPort;
import COM.livingston.model.LEISDNPorts;
import COM.livingston.model.LELine;
import COM.livingston.model.LELines;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LELoginUser;
import COM.livingston.model.LEModems;
import COM.livingston.model.LENATMap;
import COM.livingston.model.LENATMapRule;
import COM.livingston.model.LENATMaps;
import COM.livingston.model.LENetUser;
import COM.livingston.model.LENetworkRanges;
import COM.livingston.model.LEOSPFArea;
import COM.livingston.model.LEParallelPort;
import COM.livingston.model.LEParallelPorts;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LEPorts;
import COM.livingston.model.LERadius;
import COM.livingston.model.LERoute;
import COM.livingston.model.LESNMPHosts;
import COM.livingston.model.LESubInterface;
import COM.livingston.model.LESubInterfaces;
import COM.livingston.model.LESyncPort;
import COM.livingston.model.LESyncPorts;
import COM.livingston.model.LETable;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import COM.livingston.util.LETokenizer;
import java.util.StringTokenizer;

public class LEPMEntityParser {
    public static final String MCPU_EMPTY = "0";
    public static final String MCPU_PRESENT = "1";
    public static final String MCPU_MGR_PM4 = "3";
    public static final String MCPU_PM4_QT1 = "5";
    public static final String MCPU_PM4_TE1 = "6";
    public static final String MCPU_T3MX = "7";
    public static final String MCPU_ETHER = "8";
    public static final String MCPU_E3MX = "9";
    public static final String ETHERNET_DAUGHTER_CARD = "10";
    public static final String ASYNC_PORT = "async";
    public static final String ISDN_PORT = "isdn";
    public static final String PARA_PORT = "parallel";
    public static final String SYNC_PORT = "sync";

    public static boolean Parse(String key, LEDSSPortMaster dss, LEPortMaster pm) {
        String send = key;
        return LEPMEntityParser.Parse(dss, pm.getConfig(key), key, send);
    }

    public static boolean Parse(String key, String board_id, LEDSSPortMaster dss, LEPortMaster pm) {
        String send = String.valueOf(key) + " " + 275 + " " + board_id;
        return LEPMEntityParser.Parse(dss, pm.getConfig("2555904"), key, send);
    }

    public static boolean Parse(LEDSSPortMaster dss, LEConfig config, String key, String send) {
        boolean success = true;
        try {
            LESendResponse resp = dss.send((byte)31, (short)send.length(), send, true);
            success = resp.m_opCode != 9 && resp.m_opCode != 32 ? false : resp.successful();
            while (success && LEPMEntityParser.Parse(key, config, resp.getStreamTok())) {
                resp = dss.recv(true);
                success = resp.m_opCode != 9 && resp.m_opCode != 32 ? false : resp.successful();
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        dss.done();
        return success;
    }

    public static boolean Parse(String key, LEConfig config, LETokenizer tok) {
        int entity = 0;
        try {
            entity = Integer.parseInt(key);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        boolean more = false;
        switch (entity) {
            case 0x210000: {
                more = LEPMEntityParser.ParseGlobal(config, tok);
                break;
            }
            case 327680: {
                more = LEPMEntityParser.ParseSyslog(config, tok);
                break;
            }
            case 0x150000: {
                more = LEPMEntityParser.ParseSNMP(config, tok);
                break;
            }
            case 0x100000: {
                more = LEPMEntityParser.ParseOSPF(config, tok);
                break;
            }
            case 524288: {
                more = LEPMEntityParser.ParseOSPFAreas(config, tok);
                break;
            }
            case 0x140000: {
                more = LEPMEntityParser.ParseRoutes(config, tok);
                break;
            }
            case 0x130000: {
                more = LEPMEntityParser.ParseHosts(config, tok);
                break;
            }
            case 196608: {
                more = LEPMEntityParser.ParseModems(config, tok);
                break;
            }
            case 131072: {
                more = LEPMEntityParser.ParseLines(config, tok);
                break;
            }
            case 0x260000: {
                more = LEPMEntityParser.ParseSubInterface(config, tok);
                break;
            }
            case 0x270000: {
                more = LEPMEntityParser.ParseBoards(config, tok);
                break;
            }
            case 0x1A0000: {
                more = LEPMEntityParser.ParseLocations(config, tok);
                break;
            }
            case 262144: {
                more = LEPMEntityParser.ParsePorts(config, tok);
                break;
            }
            case 0x290000: {
                more = LEPMEntityParser.ParseNATMaps(config, tok);
                break;
            }
            case 720896: {
                more = LEPMEntityParser.ParseEthernets(config, tok);
                break;
            }
            case 0x1C0000: {
                more = LEPMEntityParser.ParseUsers(config, tok);
                break;
            }
            case 0x310000: {
                more = LEPMEntityParser.ParseUserPasswords(config, tok);
                break;
            }
            case 0x220000: {
                more = LEPMEntityParser.ParseRadius(config, tok);
                break;
            }
            case 0x170000: {
                more = LEPMEntityParser.ParseChoiceNet(config, tok);
                break;
            }
            case 0x320000: {
                more = LEPMEntityParser.ParseSecrets(config, tok);
                break;
            }
            case 589824: {
                more = LEPMEntityParser.ParseBGP(config, tok);
                break;
            }
            case 0x160000: {
                more = LEPMEntityParser.ParseBGPPeers(config, tok);
                break;
            }
            case 0x300000: {
                more = LEPMEntityParser.ParseBGPPolicies(config, tok);
                break;
            }
            case 0x250000: {
                more = LEPMEntityParser.ParseSAs(config, tok);
                break;
            }
            default: {
                LEDebug.getLog().logln(20, "No parser for entity: " + entity);
            }
        }
        return more;
    }

    public static boolean ParseRoutes(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig route = null;
            boolean done = false;
            String destination = null;
            String gateway = null;
            String source = null;
            String type = null;
            block12: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x140000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block12;
                        destination = tmp;
                        break;
                    }
                    case 74: {
                        destination = tok.getNextQuotedString();
                        break;
                    }
                    case 75: {
                        gateway = tok.getNextQuotedString();
                        break;
                    }
                    case 77: {
                        source = tok.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 78: {
                        type = tok.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 82: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        route = null;
                        if (source != null && source.equals("local") && tmp != null && tmp.equals("static") && destination != null) {
                            route = (LERoute)config.getConfig(destination);
                            if (gateway != null) {
                                route.setField(LERoute.GATEWAY, gateway);
                            }
                            if (type != null) {
                                route.setField(LERoute.TYPE, type);
                            }
                            route.setField(LERoute.SOURCE, source);
                            route.setField(LERoute.STATUS, tmp);
                        }
                        destination = null;
                        gateway = null;
                        source = null;
                        type = null;
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (route == null) continue block12;
                        route.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block12;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Routes", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseGlobal(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x210000: {
                        tok.getNextQuotedString();
                        if (config == null) continue block9;
                        config.setField("password", "");
                        break;
                    }
                    case 36: 
                    case 57: 
                    case 75: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 195: 
                    case 495: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 181: 
                    case 197: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            config.setField(Integer.toString(attribute), "enable");
                            break;
                        }
                        config.setField(Integer.toString(attribute), "disable");
                        break;
                    }
                    case 178: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Global", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseRadius(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x220000: {
                        tok.getNextQuotedString();
                        if (config == null) continue block9;
                        config.setField("secret", "");
                        break;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 212: 
                    case 213: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "1645";
                        }
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 214: 
                    case 215: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "1646";
                        }
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("RADIUS", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseChoiceNet(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x170000: {
                        tok.getNextQuotedString();
                        if (config == null) continue block8;
                        config.setField("choicenet-secret", "");
                        break;
                    }
                    case 208: 
                    case 209: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block8;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 212: 
                    case 213: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "1647";
                        }
                        if (config == null) continue block8;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("ChoiceNet", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSyslog(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            String log = null;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 327680: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        log = tmp;
                        break;
                    }
                    case 91: {
                        log = tok.getNextQuotedString();
                        break;
                    }
                    case 90: {
                        String facility = tok.getNextQuotedString();
                        if (log == null) continue block8;
                        config.setField(log, facility);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Syslog", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSNMP(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LESNMPHosts hosts = null;
            boolean done = false;
            String key = null;
            block16: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x150000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 17: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 87: {
                        config.setField("sysname", tok.getNextQuotedString());
                        break;
                    }
                    case 85: {
                        config.setField("read", tok.getNextQuotedString());
                        hosts = (LESNMPHosts)config.getConfig("readhost");
                        hosts.clearList();
                        key = "readtype";
                        break;
                    }
                    case 86: {
                        config.setField("write", tok.getNextQuotedString());
                        hosts = (LESNMPHosts)config.getConfig("writehost");
                        hosts.clearList();
                        key = "writetype";
                        break;
                    }
                    case 12: {
                        int count = tok.getNextInt();
                        switch (count) {
                            case -1: {
                                if (key != null) {
                                    config.setField(key, "any");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(0);
                                break;
                            }
                            case 0: {
                                if (key != null) {
                                    config.setField(key, "none");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(1);
                                break;
                            }
                            default: {
                                if (key != null) {
                                    config.setField(key, "specified");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(2);
                                break;
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        String name = tok.getNextQuotedString();
                        if (name.endsWith(".in-addr.arpa")) {
                            name = LEPMEntityParser.fixHostname(name);
                        }
                        if (hosts == null) continue block16;
                        hosts.addField(name);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block16;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("SNMP", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    static String fixHostname(String name) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tz = new StringTokenizer(name, ".");
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        return buf.toString();
    }

    public static boolean ParseOSPF(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block7: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 97: 
                    case 100: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block7;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block7;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad OSPF attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseOSPFAreas(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEOSPFArea area = null;
            LETable ranges = null;
            boolean done = false;
            String advertise = null;
            block14: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 524288: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || tmp.equals(MCPU_EMPTY)) continue block14;
                        area = (LEOSPFArea)config.getConfig(tmp);
                        ranges = (LENetworkRanges)area.getConfig("range");
                        break;
                    }
                    case 9: {
                        String tmp = tok.getNextQuotedString();
                        area = (LEOSPFArea)config.getConfig(tmp);
                        ranges = (LENetworkRanges)area.getConfig("range");
                        break;
                    }
                    case 12: {
                        String tmp = tok.getNextQuotedString();
                        int count = Integer.parseInt(tmp);
                        break;
                    }
                    case 101: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        if (tmp.equalsIgnoreCase("md5")) {
                            area.setField("AuthType", "md5");
                        } else if (tmp.equalsIgnoreCase("none")) {
                            area.setField("AuthType", "none");
                        } else {
                            area.setField("AuthType", "password");
                        }
                        if (!tmp.equalsIgnoreCase("md5")) {
                            area.setField("AuthID", "");
                            area.setField("AuthKey", "");
                        }
                        area.setField("password", "");
                        break;
                    }
                    case 99: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        area.setField("AuthID", tmp);
                        break;
                    }
                    case 102: {
                        String type;
                        String tmp = tok.getNextQuotedString();
                        int len = tmp.length();
                        StringBuffer buf = new StringBuffer(len);
                        int i = 0;
                        while (i < len) {
                            buf.append('*');
                            ++i;
                        }
                        if (area == null || (type = (String)area.get("AuthType")) == null) continue block14;
                        if (type.equals("md5")) {
                            area.setField("AuthKey", buf.toString());
                            break;
                        }
                        if (!type.equals("password")) continue block14;
                        area.setField("password", buf.toString());
                        break;
                    }
                    case 103: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        if (tmp.equalsIgnoreCase("external")) {
                            area.setField("AreaType", "external");
                            break;
                        }
                        if (tmp.equalsIgnoreCase("stub")) {
                            area.setField("AreaType", "stub");
                            break;
                        }
                        area.setField("AreaType", "nssa");
                        break;
                    }
                    case 117: {
                        String tmp;
                        advertise = tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 104: {
                        String tmp = tok.getNextQuotedString();
                        if (ranges == null || advertise == null) continue block14;
                        ranges.setField(tmp, advertise);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block14;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("OSPF Area", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseHosts(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEHosts hosts = (LEHosts)config;
            hosts.clearList();
            String ipaddress = null;
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x130000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        ipaddress = tmp;
                        break;
                    }
                    case 9: {
                        ipaddress = tok.getNextQuotedString();
                        break;
                    }
                    case 3: {
                        String hostname = tok.getNextQuotedString();
                        if (ipaddress == null) continue block8;
                        LEHost host = (LEHost)hosts.addConfig();
                        host.setField("address", ipaddress);
                        host.setField("hostname", hostname);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Hosts", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseModems(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEModems modems = null;
            if (config instanceof LEModems) {
                modems = (LEModems)config;
            }
            String name = null;
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block9;
                        modems = (LEModems)board.get(LEBoard.MODEMS);
                        break;
                    }
                    case 196608: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block9;
                        name = "M" + tmp;
                        break;
                    }
                    case 40: {
                        name = "M" + tok.getNextQuotedString();
                        break;
                    }
                    case 41: {
                        String state = tok.getNextQuotedString();
                        if (name == null) continue block9;
                        modems.setField(name, state);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Modems", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseLines(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LELines lines = null;
            if (config instanceof LELines) {
                lines = (LELines)config;
            }
            LEConfig line = null;
            LETable groups = null;
            LEGroup group = null;
            boolean done = false;
            block13: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block13;
                        lines = (LELines)board.get(LEBoard.LINES);
                        break;
                    }
                    case 131072: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block13;
                        line = (LELine)lines.getConfig("line" + tmp);
                        groups = (LEGroups)line.getConfig("groups");
                        break;
                    }
                    case 11: {
                        String tmp = "line" + tok.getNextQuotedString();
                        line = (LELine)lines.getConfig(tmp);
                        groups = (LEGroups)line.getConfig("groups");
                        break;
                    }
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 37: 
                    case 39: 
                    case 472: 
                    case 474: 
                    case 475: 
                    case 476: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (line == null) continue block13;
                        line.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 129: {
                        String tmp = tok.getNextQuotedString();
                        if (groups == null) continue block13;
                        group = (LEGroup)groups.getConfig(tmp);
                        break;
                    }
                    case 130: 
                    case 131: 
                    case 132: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (group == null) continue block13;
                        group.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 128: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 38: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("r2 custom") || tmp.equals("R2 custom")) {
                            tmp = "r2custom";
                        } else if (tmp.equals("r2mf generic") || tmp.equals("R2MF generic")) {
                            tmp = "r2generic";
                        }
                        if (line == null) continue block13;
                        line.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block13;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Lines", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseSubInterface(LEConfig config, LETokenizer tok) {
        more = false;
        sub_is = (LESubInterfaces)config;
        sub = null;
        done = false;
        try {
            block8: while (true) lbl-1000:
            // 9 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x260000: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        sub = (LESubInterface)sub_is.getConfig(tmp);
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        sub = (LESubInterface)sub_is.getConfig(tmp);
                        ** break;
                    }
                    case 9: 
                    case 15: 
                    case 186: 
                    case 260: {
                        tmp = tok.getNextQuotedString();
                        if (sub == null) continue block8;
                        sub.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("SubInterfaces", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBoards(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig board = null;
            String board_id = null;
            boolean done = false;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x270000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        board_id = tok.getNextQuotedString();
                        board = null;
                        break;
                    }
                    case 272: {
                        String tmp = tok.getNextQuotedString();
                        if (board_id != null && !tmp.equals(MCPU_EMPTY) && (board = (LEBoard)config.getConfig(board_id)) != null) {
                            if (tmp.equals(MCPU_PRESENT)) {
                                tmp = "Present";
                            } else if (tmp.equals(MCPU_MGR_PM4)) {
                                tmp = "System Manager";
                                board.getConfig(LEBoard.PORTS);
                                board.getConfig(LEBoard.ETHERNETS);
                            } else if (tmp.equals(MCPU_ETHER)) {
                                tmp = "Ethernet";
                                board.getConfig(LEBoard.ETHERNETS);
                            } else if (tmp.equals(MCPU_PM4_QT1)) {
                                tmp = "Quad T1";
                                board.getConfig(LEBoard.PORTS);
                                board.getConfig(LEBoard.LINES);
                                board.getConfig(LEBoard.MODEMS);
                            } else if (tmp.equals(MCPU_PM4_TE1)) {
                                tmp = "Tri E1";
                                board.getConfig(LEBoard.PORTS);
                                board.getConfig(LEBoard.LINES);
                                board.getConfig(LEBoard.MODEMS);
                            } else {
                                tmp = tmp.equals(MCPU_T3MX) ? "T3 Mux" : (tmp.equals(MCPU_E3MX) ? "E3 Mux" : "Unknown");
                            }
                        }
                        if (board == null) continue block10;
                        board.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 17: 
                    case 164: 
                    case 165: 
                    case 172: 
                    case 273: 
                    case 274: 
                    case 276: 
                    case 472: 
                    case 473: {
                        String tmp = tok.getNextQuotedString();
                        if (board == null) continue block10;
                        board.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 279: {
                        String tmp = tok.getNextQuotedString();
                        if (board == null) continue block10;
                        if (board_id.equals(ETHERNET_DAUGHTER_CARD)) {
                            tmp = "on";
                        }
                        board.setField(LEBoard.POWER, tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Boards", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseLocations(LEConfig config, LETokenizer tok) {
        more = false;
        locs = (LELocations)config;
        loc = null;
        done = false;
        ip_table = null;
        ipx_table = null;
        ipnum = null;
        ipxnum = null;
        script = null;
        try {
            block18: while (true) lbl-1000:
            // 27 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x1A0000: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block18;
                        loc = (LELocation)locs.getConfig(tmp);
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        loc = (LELocation)locs.getConfig(tmp);
                        ** break;
                    }
                    case 2: 
                    case 9: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 170: 
                    case 177: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        tmp = tok.getNextQuotedString();
                        if (loc == null) continue block18;
                        loc.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 288: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.equals("on_demand")) {
                            tmp = "on-demand";
                        }
                        if (loc == null) continue block18;
                        loc.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 189: {
                        tmp = tok.getNextQuotedString();
                        if (loc == null) continue block18;
                        octs = new LEOctets(tmp);
                        tmp = octs.toHexString();
                        loc.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 303: {
                        tmp = tok.getNextQuotedString();
                        if (loc == null) continue block18;
                        script = (LEDialScript)loc.getConfig("script");
                        LEDialScript.LoadScript(script, tmp);
                        loc.setField("script", script);
                        ** break;
                    }
                    case 304: {
                        tmp = tok.getNextQuotedString();
                        if (loc == null) continue block18;
                        script = (LEDialScript)loc.getConfig("v25bis");
                        LEDialScript.LoadScript(script, tmp);
                        loc.setField("v25bis", script);
                        ** break;
                    }
                    case 339: {
                        tmp = tok.getNextQuotedString();
                        if (loc == null) continue block18;
                        ip_table = (LEDLCITable)loc.getConfig("ipdlci");
                        ** break;
                    }
                    case 340: {
                        tmp = tok.getNextQuotedString();
                        if (loc == null) continue block18;
                        ipx_table = (LEDLCITable)loc.getConfig("ipxdlci");
                        ** break;
                    }
                    case 305: {
                        ipnum = tok.getNextQuotedString();
                        ** break;
                    }
                    case 306: {
                        ipxnum = tok.getNextQuotedString();
                        ** break;
                    }
                    case 307: {
                        tmp = tok.getNextQuotedString();
                        if (ipnum == null || ip_table == null) continue block18;
                        dlci = (LEDLCI)ip_table.getConfig(ipnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipnum = null;
                        ** break;
                    }
                    case 308: {
                        tmp = tok.getNextQuotedString();
                        if (ipxnum == null || ipx_table == null) continue block18;
                        dlci = (LEDLCI)ipx_table.getConfig(ipxnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipxnum = null;
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block18;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("Locations", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParsePorts(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEPorts ports = null;
            LEBoard board = null;
            LEBoards boards = null;
            if (config instanceof LEPorts) {
                ports = (LEPorts)config;
            } else if (config instanceof LEBoards) {
                boards = (LEBoards)config;
            }
            boolean done = false;
            int next = 0;
            block8: while (!done) {
                int attribute;
                if (next > 0) {
                    attribute = next;
                    next = 0;
                } else {
                    attribute = tok.getNextInt();
                }
                switch (attribute) {
                    case 262144: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        String tmp = tok.getNextQuotedString();
                        if (boards == null || (board = (LEBoard)boards.getConfig(tmp)) == null) continue block8;
                        ports = (LEPorts)board.getConfig(LEBoard.PORTS);
                        break;
                    }
                    case 333: {
                        String tmp = tok.getNextQuotedString();
                        if (ports == null) continue block8;
                        if (tmp.equals(ASYNC_PORT)) {
                            next = LEPMEntityParser.ParseAsyncPort(ports, tok);
                            break;
                        }
                        if (tmp.equals(ISDN_PORT)) {
                            next = LEPMEntityParser.ParseISDNPort(ports, tok);
                            break;
                        }
                        if (tmp.equals(PARA_PORT)) {
                            next = LEPMEntityParser.ParseParallelPort(ports, tok);
                            break;
                        }
                        if (!tmp.equals(SYNC_PORT)) continue block8;
                        next = LEPMEntityParser.ParseSyncPort(ports, tok);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Ports", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static int ParseAsyncPort(LEPorts allPorts, LETokenizer tok) {
        int attribute = 0;
        try {
            LEAsyncPorts ports = (LEAsyncPorts)allPorts.getConfig("AsyncPort");
            LEConfig port = null;
            boolean done = false;
            block8: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 1: {
                        String tmp = tok.getNextQuotedString();
                        if (ports == null) continue block8;
                        port = (LEAsyncPort)ports.getConfig(tmp);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 23: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 332: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block8;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: {
                        LEHostOverrides over;
                        String tmp = tok.getNextQuotedString();
                        if (port == null || (over = (LEHostOverrides)port.getConfig("overrides")) == null) continue block8;
                        over.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Async Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    public static int ParseISDNPort(LEPorts allPorts, LETokenizer tok) {
        int attribute = 0;
        try {
            LEISDNPorts ports = (LEISDNPorts)allPorts.getConfig("ISDNPort");
            LEISDNPort port = null;
            boolean done = false;
            block9: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 1: {
                        String tmp = tok.getNextQuotedString();
                        if (ports == null) continue block9;
                        port = (LEISDNPort)ports.getConfig(tmp);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 181: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 317: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 325: 
                    case 332: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block9;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 189: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block9;
                        LEOctets octs = new LEOctets(tmp);
                        tmp = octs.toHexString();
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 289: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("ISDN Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    public static int ParseParallelPort(LEPorts allPorts, LETokenizer tok) {
        int attribute = 0;
        try {
            LEParallelPorts ports = (LEParallelPorts)allPorts.getConfig("ParallelPort");
            LEParallelPort port = null;
            boolean done = false;
            block7: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 1: {
                        String tmp = tok.getNextQuotedString();
                        if (ports == null) continue block7;
                        port = (LEParallelPort)ports.getConfig(tmp);
                        break;
                    }
                    case 173: 
                    case 309: 
                    case 310: 
                    case 311: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block7;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Parallel Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    public static int ParseSyncPort(LEPorts allPorts, LETokenizer tok) {
        int attribute = 0;
        try {
            LESyncPorts ports = (LESyncPorts)allPorts.getConfig("SyncPort");
            LEConfig port = null;
            LEDLCITable ip_table = null;
            LEDLCITable ipx_table = null;
            String ipnum = null;
            String ipxnum = null;
            boolean done = false;
            block14: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 1: {
                        String tmp = tok.getNextQuotedString();
                        if (ports == null || tmp.startsWith("X")) continue block14;
                        port = (LESyncPort)ports.getConfig(tmp);
                        break;
                    }
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 177: 
                    case 181: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 312: 
                    case 316: 
                    case 318: 
                    case 319: 
                    case 332: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block14;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 189: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block14;
                        LEOctets octs = new LEOctets(tmp);
                        tmp = octs.toHexString();
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 339: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block14;
                        ip_table = (LEDLCITable)port.getConfig(LESyncPort.IP_DLCI_TAB);
                        break;
                    }
                    case 340: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block14;
                        ipx_table = (LEDLCITable)port.getConfig(LESyncPort.IPX_DLCI_TAB);
                        break;
                    }
                    case 305: {
                        ipnum = tok.getNextQuotedString();
                        break;
                    }
                    case 306: {
                        ipxnum = tok.getNextQuotedString();
                        break;
                    }
                    case 307: {
                        String tmp = tok.getNextQuotedString();
                        if (ipnum == null || ip_table == null) continue block14;
                        LEDLCI dlci = (LEDLCI)ip_table.getConfig(ipnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipnum = null;
                        break;
                    }
                    case 308: {
                        String tmp = tok.getNextQuotedString();
                        if (ipxnum == null || ipx_table == null) continue block14;
                        LEDLCI dlci = (LEDLCI)ipx_table.getConfig(ipxnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipxnum = null;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Sync Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseNATMaps(LEConfig config, LETokenizer tok) {
        more = false;
        done = false;
        maps = (LENATMaps)config;
        map = null;
        rule = null;
        buf = null;
        notation = 0;
        netmask = null;
        portStart = null;
        portEnd = null;
        address = null;
        addressStart = null;
        addressEnd = null;
        lhs_index = 0;
        rhs_index = 0;
        index = 0;
        try {
            block29: while (true) lbl-1000:
            // 28 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x290000: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block29;
                        map = (LENATMap)maps.getConfig(tmp);
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        map = (LENATMap)maps.getConfig(tmp);
                        ** break;
                    }
                    case 341: {
                        tmp = tok.getNextQuotedString();
                        if (map != null) {
                            rule = (LENATMapRule)map.getConfig(tmp);
                            ** break;
                        }
                        rule = null;
                        ** break;
                    }
                    case 352: {
                        tmp = tok.getNextQuotedString();
                        if (rule == null) continue block29;
                        rule.setField("type", tmp);
                        ** break;
                    }
                    case 351: {
                        tmp = tok.getNextQuotedString();
                        if (rule == null) continue block29;
                        if (tmp.equals("off")) {
                            rule.setField("log", "off");
                            ** break;
                        }
                        rule.setField("log", "on");
                        ** break;
                    }
                    case 342: {
                        lhs_index = Integer.parseInt(tok.getNextQuotedString());
                        ** break;
                    }
                    case 343: {
                        rhs_index = Integer.parseInt(tok.getNextQuotedString()) + lhs_index;
                        ** break;
                    }
                    case 344: {
                        index = Integer.parseInt(tok.getNextQuotedString()) + 1;
                        ** break;
                    }
                    case 345: {
                        notation = Integer.parseInt(tok.getNextQuotedString());
                        ** break;
                    }
                    case 15: {
                        netmask = tok.getNextQuotedString();
                        ** break;
                    }
                    case 346: {
                        portStart = tok.getNextQuotedString();
                        ** break;
                    }
                    case 347: {
                        portEnd = tok.getNextQuotedString();
                        ** break;
                    }
                    case 348: {
                        address = tok.getNextQuotedString();
                        ** break;
                    }
                    case 349: {
                        addressStart = tok.getNextQuotedString();
                        ** break;
                    }
                    case 350: {
                        addressEnd = tok.getNextQuotedString();
                        if (rule == null) continue block29;
                        if (buf == null) {
                            buf = new StringBuffer();
                        } else {
                            buf.append(",");
                        }
                        switch (notation) {
                            case 1: {
                                buf.append(address);
                                buf.append('/');
                                buf.append(netmask);
                                break;
                            }
                            case 2: {
                                buf.append(addressStart);
                                buf.append('-');
                                buf.append(addressEnd);
                                break;
                            }
                            case 4: {
                                buf.append(addressStart);
                                break;
                            }
                            case 8: {
                                buf.append(addressStart);
                                buf.append(':');
                                buf.append(portStart);
                                break;
                            }
                            case 16: {
                                buf.append(addressStart);
                                buf.append(':');
                                buf.append(portStart);
                                buf.append('-');
                                buf.append(portEnd);
                                break;
                            }
                            case 132: {
                                buf.append("@ipaddr");
                                break;
                            }
                        }
                        if (index == lhs_index) {
                            rule.setField("lhs", buf.toString());
                            buf = null;
                            ** break;
                        }
                        if (index != rhs_index) continue block29;
                        rule.setField("rhs", buf.toString());
                        buf = null;
                        ** break;
                    }
                    case 12: {
                        tmp = tok.getNextQuotedString();
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block29;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("NAT Maps", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseEthernets(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEEthernets ethers = null;
            if (config instanceof LEEthernets) {
                ethers = (LEEthernets)config;
            }
            LEEthernet ether = null;
            boolean done = false;
            block11: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 720896: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || ethers == null) continue block11;
                        ether = (LEEthernet)ethers.getConfig(tmp);
                        break;
                    }
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block11;
                        ethers = (LEEthernets)board.get(LEBoard.ETHERNETS);
                        break;
                    }
                    case 260: {
                        String tmp = tok.getNextQuotedString();
                        if (ethers == null) continue block11;
                        ether = (LEEthernet)ethers.getConfig(tmp);
                        break;
                    }
                    case 190: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (ether == null) continue block11;
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 9: 
                    case 15: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 246: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String tmp = tok.getNextQuotedString();
                        if (ether == null) continue block11;
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 191: 
                    case 192: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            ether.setField(Integer.toString(attribute), "enable");
                            break;
                        }
                        ether.setField(Integer.toString(attribute), "disable");
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block11;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Ethernets", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseUsers(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig net_users = config.getConfig("netuser");
            LEConfig db_net_users = config.getConfig("netdialback");
            LEConfig login_users = config.getConfig("user");
            LEConfig db_login_users = config.getConfig("logindialback");
            LEConfig user = null;
            String name = null;
            String service = null;
            boolean done = false;
            block14: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x1C0000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        name = tok.getNextQuotedString();
                        break;
                    }
                    case 78: {
                        String tmp = tok.getNextQuotedString();
                        user = null;
                        if (config == null || name == null) continue block14;
                        if (tmp.equals("network")) {
                            user = net_users.getConfig(name);
                            user.setField("password", "");
                            break;
                        }
                        if (tmp.equals("dialback_network")) {
                            user = db_net_users.getConfig(name);
                            user.setField("password", "");
                            break;
                        }
                        if (tmp.equals("login")) {
                            user = login_users.getConfig(name);
                            user.setField("password", "");
                            break;
                        }
                        if (!tmp.equals("dialback_login")) continue block14;
                        user = db_login_users.getConfig(name);
                        break;
                    }
                    case 300: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 173: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null) continue block14;
                        if (tmp.equals("0.0.0.0")) {
                            user.setField("host", "default");
                        } else if (tmp.equals("255.255.255.255")) {
                            user.setField("host", "prompt");
                        } else {
                            user.setField("host", "specified");
                        }
                        user.setField("HostAddress", tmp);
                        break;
                    }
                    case 74: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null) continue block14;
                        if (tmp.equals("255.255.255.255")) {
                            user.setField("destination", "negotiated");
                        } else if (tmp.equals("255.255.255.254")) {
                            user.setField("destination", "assigned");
                        } else {
                            user.setField("destination", "specified");
                        }
                        user.setField("IPAddress", tmp);
                        break;
                    }
                    case 369: {
                        service = tok.getNextQuotedString();
                        break;
                    }
                    case 370: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null || service == null) continue block14;
                        if ((service.equals("netdata") || service.equals("telnet")) && tmp.length() > 0) {
                            service = String.valueOf(service) + "@" + tmp;
                        }
                        user.setField("service", service);
                        service = null;
                        break;
                    }
                    case 15: 
                    case 177: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 299: 
                    case 301: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 368: 
                    case 371: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null) continue block14;
                        user.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block14;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseUserPasswords(LEConfig config, LETokenizer tok) {
        if (!(config instanceof LEUsers)) {
            return false;
        }
        LEUsers users = (LEUsers)config;
        boolean more = false;
        try {
            boolean done = false;
            String name = null;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x310000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        name = tok.getNextQuotedString();
                        break;
                    }
                    case 300: {
                        String tmp = tok.getNextQuotedString();
                        if (name != null && tmp.length() > 0) {
                            LEConfig user = (LEConfig)users.getUser(name);
                            if (user instanceof LELoginUser) {
                                ((LELoginUser)user).setPassword(tmp);
                            } else if (user instanceof LENetUser) {
                                ((LENetUser)user).setPassword(tmp);
                            } else if (user instanceof LEDBNetUser) {
                                ((LEDBNetUser)user).setPassword(tmp);
                            }
                        }
                        name = null;
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User Passwords", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSecrets(LEConfig config, LETokenizer tok) {
        LERadius radius = (LERadius)config.get("2228224");
        LEChoicenet choicenet = (LEChoicenet)config.get("1507328");
        boolean more = false;
        try {
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x320000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 64: {
                        String tmp = tok.getNextQuotedString();
                        if (radius == null) continue block8;
                        radius.setSecret(tmp);
                        break;
                    }
                    case 65: {
                        String tmp = tok.getNextQuotedString();
                        if (choicenet == null) continue block8;
                        choicenet.setSecret(tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Secrets", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBGP(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block7: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 589824: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 9: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block7;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block7;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGP", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBGPPeers(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig peer = null;
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x160000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 9: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || config == null) continue block8;
                        peer = (LEBGPPeer)config.getConfig(tmp);
                        break;
                    }
                    case 96: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 177: {
                        String tmp = tok.getNextQuotedString();
                        if (peer == null) continue block8;
                        peer.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPeers", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSAs(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig ipsec_sas = config.getConfig("ipsec");
            LEConfig ipip_sas = config.getConfig("ipip");
            LEConfig proxy_sas = config.getConfig("proxy");
            LEConfig sa = null;
            String name = null;
            Object service = null;
            boolean done = false;
            block11: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x250000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        name = tok.getNextQuotedString();
                        break;
                    }
                    case 289: {
                        String tmp = tok.getNextQuotedString();
                        sa = null;
                        if (config == null || name == null) continue block11;
                        if (tmp.equals("IPSEC")) {
                            sa = ipsec_sas.getConfig(name);
                            break;
                        }
                        if (tmp.equals("IPIP")) {
                            sa = ipip_sas.getConfig(name);
                            break;
                        }
                        if (!tmp.equals("PROXY")) continue block11;
                        sa = proxy_sas.getConfig(name);
                        break;
                    }
                    case 74: 
                    case 225: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 247: {
                        String tmp = tok.getNextQuotedString();
                        if (sa == null) continue block11;
                        sa.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 226: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "none";
                        }
                        if (sa == null) continue block11;
                        sa.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 240: {
                        String tmp = tok.getNextQuotedString();
                        if (sa == null) continue block11;
                        int len = tmp.length();
                        StringBuffer buf = new StringBuffer(len);
                        int i = 0;
                        while (i < len) {
                            buf.append('*');
                            ++i;
                        }
                        sa.setField("secret", buf.toString());
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block11;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("SA", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBGPPolicies(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LETable policy = null;
            LEConfig rule = null;
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x300000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || config == null) continue block9;
                        policy = (LEBGPPolicy)config.getConfig(tmp);
                        break;
                    }
                    case 416: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || policy == null) continue block9;
                        rule = (LEBGPPolicyRule)policy.getConfig(tmp);
                        break;
                    }
                    case 417: 
                    case 418: 
                    case 419: 
                    case 420: 
                    case 421: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 426: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 431: {
                        String tmp = tok.getNextQuotedString();
                        if (rule == null) continue block9;
                        rule.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPolicies", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    static void LogBadAttribute(String section, int attr, String value) {
        LEDebug.getLog().log(20, "Bad ");
        LEDebug.getLog().log(20, section);
        LEDebug.getLog().log(20, " Attribute: ", attr);
        LEDebug.getLog().log(20, ", ");
        LEDebug.getLog().logln(20, value);
    }
}

