/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFilterRule;
import COM.livingston.util.LEVector;

public class LESAPRule
extends LEFilterRule {
    public static final String ACTION = "action";
    public static final String COMPARE = "cmp";
    public static final String HOST = "host";
    public static final String NETWORK = "network";
    public static final String SERVER = "server";
    public static final String SOCKET = "socket";
    public static final int KEY_COUNT = 6;
    public static final String DENY = "deny";
    public static final String PERMIT = "permit";
    public static final String COMPARE_EQ = "eq";
    public static final String COMPARE_GT = "gt";
    public static final String COMPARE_LT = "lt";
    static final String DEFAULT_NUM = "1";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[6];
            LESAPRule.s_keys[0] = ACTION;
            LESAPRule.s_keys[1] = COMPARE;
            LESAPRule.s_keys[2] = HOST;
            LESAPRule.s_keys[3] = NETWORK;
            LESAPRule.s_keys[4] = SERVER;
            LESAPRule.s_keys[5] = SOCKET;
        }
        return s_keys;
    }

    public LESAPRule(LEConfigFacility facility, String name, String number) {
        super(facility, name, number);
    }

    public void initialize(String action) {
        this.setField(ACTION, action);
        this.setField(COMPARE, "");
        this.setField(HOST, "");
        this.setField(NETWORK, "");
        this.setField(SERVER, "");
        this.setField(SOCKET, DEFAULT_NUM);
    }

    public Object clone() {
        LESAPRule config = new LESAPRule(this.m_facility, this.m_name, this.m_number);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String action = (String)this.get(ACTION);
        if (this.m_name == null || this.m_number == null || action == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("sapfilter ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(this.m_number);
        buf.append(" ");
        buf.append(action);
        String tmp = (String)this.get(SERVER);
        if (tmp != null && tmp.length() > 0) {
            buf.append(" server ");
            buf.append(tmp);
        }
        if ((tmp = (String)this.get(NETWORK)) != null && tmp.length() > 0) {
            buf.append(" network ");
            buf.append(tmp);
        }
        if ((tmp = (String)this.get(HOST)) != null && tmp.length() > 0) {
            buf.append(" host ");
            buf.append(tmp);
        }
        tmp = (String)this.get(COMPARE);
        String sck = (String)this.get(SOCKET);
        if (tmp != null && tmp.length() > 0 && sck != null && sck.length() > 0) {
            buf.append(" socket ");
            buf.append(tmp);
            buf.append(" ");
            buf.append(sck);
        }
        cmds.addElement(new String(buf));
        return true;
    }
}

