/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEIPIPSAs;
import COM.livingston.model.LEIPSecSAs;
import COM.livingston.model.LEProxySAs;

public class LESAs
extends LEConfig {
    public static final String IPSEC_SA = "ipsec";
    public static final String IPIP_SA = "ipip";
    public static final String PROXY_SA = "proxy";
    public static final int KEY_COUNT = 3;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[3];
            int i = 0;
            LESAs.s_keys[i++] = IPSEC_SA;
            LESAs.s_keys[i++] = IPIP_SA;
            LESAs.s_keys[i++] = PROXY_SA;
        }
        return s_keys;
    }

    public LESAs(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LESAs config = new LESAs(this.m_facility);
        config.copy(this);
        return config;
    }

    public Object getSA(String name) {
        LEIPIPSAs ipip;
        Object sa = null;
        LEIPSecSAs ipsec = (LEIPSecSAs)this.get(IPSEC_SA);
        if (ipsec != null) {
            sa = ipsec.get(name);
        }
        if (sa == null && (ipip = (LEIPIPSAs)this.get(IPIP_SA)) != null) {
            sa = ipip.get(name);
        }
        if (sa == null) {
            LEProxySAs proxy = (LEProxySAs)this.get(PROXY_SA);
            if (sa != null) {
                sa = proxy.get(name);
            }
        }
        return sa;
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(IPSEC_SA) ? new LEIPSecSAs(this.m_facility) : (key.equals(IPIP_SA) ? new LEIPIPSAs(this.m_facility) : (key.equals(PROXY_SA) ? new LEProxySAs(this.m_facility) : new LEConfig(this.m_facility)));
        return config;
    }
}

