/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LESPBar;
import COM.livingston.ui.LESPColumn;
import COM.livingston.ui.LESPRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class LESplitterPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    public static final int SIZE_UNSPECIFIED = 0;
    static final double PERCENT_UNSPECIFIED = 0.0;
    static final int BORDER = 5;
    Vector m_cols = new Vector();
    LESPBar m_bar = new LESPBar();
    boolean m_dragging;
    boolean m_inside;
    boolean m_over;
    Frame m_frame;

    public LESplitterPanel() {
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.doLayout();
    }

    public void addColumn(int n) {
        LESPColumn lESPColumn = new LESPColumn(n);
        this.m_cols.addElement(lESPColumn);
    }

    public void addColumn(double d) {
        LESPColumn lESPColumn = new LESPColumn(d);
        this.m_cols.addElement(lESPColumn);
    }

    public void addComponent(Component component, int n) {
        LESPColumn lESPColumn = this.getLastColumn();
        lESPColumn.addRow(component, n);
        this.add(component);
    }

    public void addComponent(Component component, double d) {
        LESPColumn lESPColumn = this.getLastColumn();
        lESPColumn.addRow(component, d);
        this.add(component);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_dragging) {
            this.m_inside = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_dragging) {
            this.m_inside = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_bar.m_orient != 0) {
            mouseEvent.consume();
            this.m_dragging = true;
            this.m_inside = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_dragging) {
            mouseEvent.consume();
            this.m_dragging = false;
            if (this.m_bar.m_row == null) {
                this.m_bar.m_col.m_pixels = this.m_bar.m_col.m_width + mouseEvent.getX() - this.m_bar.m_edge - 1;
                if (this.m_bar.m_col.m_pixels < 0) {
                    this.m_bar.m_col.m_pixels = 0;
                }
            } else {
                this.m_bar.m_row.m_pixels = this.m_bar.m_row.m_height + mouseEvent.getY() - this.m_bar.m_edge - 1;
                if (this.m_bar.m_row.m_pixels < 0) {
                    this.m_bar.m_row.m_pixels = 0;
                }
            }
            this.doLayout();
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_dragging && this.m_inside) {
            mouseEvent.consume();
            if (this.m_bar.move(mouseEvent.getX(), mouseEvent.getY())) {
                this.repaint();
            }
        }
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_dragging) {
            mouseEvent.consume();
            return;
        }
        boolean bl = this.checkResizeBars(this.m_cols, mouseEvent.getX(), mouseEvent.getY());
        if (bl && !this.m_over) {
            this.m_over = true;
            return;
        }
        if (!bl && this.m_over) {
            this.m_over = false;
            this.m_bar.reset();
        }
    }

    public void paint(Graphics graphics) {
        if (this.m_bar.m_orient != 0 && this.m_inside) {
            if (this.m_dragging) {
                this.m_bar.paint(graphics, false);
                return;
            }
            this.m_bar.paint(graphics, true);
        }
    }

    public synchronized void doLayout() {
        Dimension dimension = this.getSize();
        int n = this.m_cols.size();
        int n2 = dimension.width - (n + 1) * 5;
        this.getColumnWidths(n, n2);
        int n3 = 5;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 5;
            LESPColumn lESPColumn = (LESPColumn)this.m_cols.elementAt(n4);
            int n6 = lESPColumn.m_rows.size();
            int n7 = dimension.height - (n6 + 1) * 5;
            this.getRowHeights(lESPColumn, n6, n7);
            int n8 = 0;
            while (n8 < n6) {
                LESPRow lESPRow = (LESPRow)lESPColumn.m_rows.elementAt(n8);
                lESPRow.m_comp.setBounds(n3, n5, lESPColumn.m_width, lESPRow.m_height);
                n5 += 5 + lESPRow.m_height;
                lESPRow.m_comp.invalidate();
                lESPRow.m_comp.validate();
                ++n8;
            }
            n3 += 5 + lESPColumn.m_width;
            ++n4;
        }
        this.repaint();
    }

    LESPColumn getLastColumn() {
        LESPColumn lESPColumn;
        if (this.m_cols.size() == 0) {
            lESPColumn = new LESPColumn(0);
            this.m_cols.addElement(lESPColumn);
        } else {
            lESPColumn = (LESPColumn)this.m_cols.lastElement();
        }
        return lESPColumn;
    }

    void getColumnWidths(int n, int n2) {
        LESPColumn lESPColumn;
        int n3 = n2;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            lESPColumn = (LESPColumn)this.m_cols.elementAt(n5);
            if (lESPColumn.m_pixels != 0) {
                lESPColumn.m_width = lESPColumn.m_pixels;
            } else if (lESPColumn.m_percent != 0.0) {
                lESPColumn.m_width = (int)((double)n2 * lESPColumn.m_percent / 100.0);
            } else {
                ++n4;
                lESPColumn.m_width = 0;
            }
            n3 -= lESPColumn.m_width;
            ++n5;
        }
        if (n3 > 0 && n4 > 0) {
            n2 = n3;
            int n6 = 0;
            while (n6 < n) {
                lESPColumn = (LESPColumn)this.m_cols.elementAt(n6);
                if (lESPColumn.m_width == 0) {
                    lESPColumn.m_width = n2 / n4;
                    n3 -= lESPColumn.m_width;
                }
                ++n6;
            }
        }
        if (n3 > 0 && n > 0) {
            lESPColumn = (LESPColumn)this.m_cols.lastElement();
            lESPColumn.m_width += n3;
        }
    }

    void getRowHeights(LESPColumn lESPColumn, int n, int n2) {
        LESPRow lESPRow;
        int[] nArray = new int[n];
        int n3 = n2;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            lESPRow = (LESPRow)lESPColumn.m_rows.elementAt(n5);
            if (lESPRow.m_pixels != 0) {
                lESPRow.m_height = lESPRow.m_pixels;
            } else if (lESPRow.m_percent != 0.0) {
                lESPRow.m_height = (int)((double)n2 * lESPRow.m_percent / 100.0);
            } else {
                ++n4;
                lESPRow.m_height = 0;
            }
            n3 -= lESPRow.m_height;
            ++n5;
        }
        if (n3 > 0 && n4 > 0) {
            n2 = n3;
            int n6 = 0;
            while (n6 < n) {
                lESPRow = (LESPRow)lESPColumn.m_rows.elementAt(n6);
                if (lESPRow.m_height == 0) {
                    lESPRow.m_height = n2 / n4;
                    n3 -= lESPRow.m_height;
                }
                ++n6;
            }
            if (n3 > 0) {
                int n7 = n - 1;
                nArray[n7] = nArray[n7] + n3;
            }
        }
        if (n3 > 0 && n > 0) {
            lESPRow = (LESPRow)lESPColumn.m_rows.lastElement();
            lESPRow.m_height += n3;
        }
    }

    boolean checkResizeBars(Vector vector, int n, int n2) {
        int n3 = vector.size();
        int n4 = 5;
        int n5 = 0;
        while (n5 < n3) {
            if (n < n4) break;
            LESPColumn lESPColumn = (LESPColumn)this.m_cols.elementAt(n5);
            int n6 = n4 + lESPColumn.m_width;
            if (n > n4 && n < n6) {
                return this.checkRowBars(lESPColumn, n4, n, n2);
            }
            if (n5 == n3 - 1) break;
            n4 = n6;
            if (n > n4 && n < (n6 += 5)) {
                this.m_bar.set(lESPColumn, null, n4, 2, (n4 + n6) / 2, 0, this.getSize().height);
                return true;
            }
            n4 = n6;
            ++n5;
        }
        return false;
    }

    boolean checkRowBars(LESPColumn lESPColumn, int n, int n2, int n3) {
        int n4 = lESPColumn.m_rows.size();
        int n5 = 5;
        int n6 = 1;
        while (n6 < n4) {
            LESPRow lESPRow = (LESPRow)lESPColumn.m_rows.elementAt(n6 - 1);
            int n7 = (n5 += lESPRow.m_height) + 5;
            if (n3 > n5 && n3 < n7) {
                this.m_bar.set(lESPColumn, lESPRow, n5, 1, n - 5, (n5 + n7) / 2, lESPColumn.m_width + 5 + 5);
                return true;
            }
            n5 = n7;
            ++n6;
        }
        return false;
    }
}

