/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LETreeEtchedLAF;
import COM.livingston.ui.LETreeEvent;
import COM.livingston.ui.LETreeFlatLAF;
import COM.livingston.ui.LETreeGraphicsInfo;
import COM.livingston.ui.LETreeItem;
import COM.livingston.ui.LETreeLAF;
import COM.livingston.ui.LETreeListener;
import COM.livingston.util.LEDebug;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;

public class LETree
extends Panel
implements MouseListener,
AdjustmentListener {
    LETreeGraphicsInfo m_info;
    LETreeLAF m_selLAF;
    LETreeLAF m_unselLAF;
    LETreeItem m_selected;
    Vector m_items;
    Vector m_listeners;
    int m_rows;
    Dimension m_imgDim;
    int m_width;
    int m_height;
    Image m_offScreen;
    boolean m_redraw;
    int m_x;
    int m_y;
    int m_save_x;
    int m_save_y;
    Scrollbar m_vert;
    Scrollbar m_horz;

    public LETree() {
        this.addMouseListener(this);
        this.m_vert = new Scrollbar(1);
        this.m_vert.addAdjustmentListener(this);
        this.m_horz = new Scrollbar(0);
        this.m_horz.addAdjustmentListener(this);
        this.m_vert.setVisible(false);
        this.m_vert.setEnabled(false);
        this.m_horz.setVisible(false);
        this.m_horz.setEnabled(false);
        this.add(this.m_vert);
        this.add(this.m_horz);
        this.m_info = new LETreeGraphicsInfo();
        this.m_info.setImageObserver(this);
        this.m_items = new Vector();
        this.m_listeners = new Vector();
        this.m_imgDim = new Dimension();
        this.m_selLAF = new LETreeEtchedLAF(this.m_info);
        this.m_unselLAF = new LETreeFlatLAF(this.m_info);
        this.m_info.setMaxBorder(Math.max(this.m_selLAF.getBorder(), this.m_unselLAF.getBorder()));
    }

    public void addNotify() {
        super.addNotify();
        Graphics graphics = this.getGraphics();
        this.m_info.setGraphics(graphics);
        this.m_info.setGraphics(null);
        graphics.dispose();
    }

    public void setDefaultImages(Image image, Image image2) {
        this.m_info.setDefaultImages(image, image2);
    }

    public void addTree(LETreeItem lETreeItem) {
        this.m_items.addElement(lETreeItem);
        this.m_rows = lETreeItem.setPosition(this.m_rows, 0);
        this.m_width = -1;
    }

    public void recalcTree() {
        this.m_rows = 0;
        int n = this.m_items.size();
        int n2 = 0;
        while (n2 < n) {
            LETreeItem lETreeItem = (LETreeItem)this.m_items.elementAt(n2);
            this.m_rows = lETreeItem.setPosition(this.m_rows, 0);
            ++n2;
        }
        this.m_width = -1;
        this.repaint();
    }

    public void addListener(LETreeListener lETreeListener) {
        this.m_listeners.addElement(lETreeListener);
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            if (this.m_vert.isVisible()) {
                this.m_save_y = this.m_vert.getValue();
            }
            if (this.m_horz.isVisible()) {
                this.m_save_x = this.m_horz.getValue();
            }
        }
        super.setEnabled(bl);
        this.m_selLAF.setEnabled(bl);
        this.m_unselLAF.setEnabled(bl);
        if (this.m_vert.isVisible()) {
            this.m_vert.setEnabled(bl);
        }
        if (this.m_horz.isVisible()) {
            this.m_horz.setEnabled(bl);
        }
        this.m_redraw = true;
        if (bl) {
            if (this.m_vert.isVisible()) {
                this.m_vert.setValue(this.m_save_y);
            }
            if (this.m_horz.isVisible()) {
                this.m_horz.setValue(this.m_save_x);
            }
            this.m_x = -this.m_save_x;
            this.m_y = -this.m_save_y;
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        try {
            Serializable serializable;
            if (this.m_width == -1) {
                this.m_width = this.determineWidth(this.m_items, graphics);
                this.m_height = this.m_rows * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_maxBorder;
            }
            if (this.m_offScreen == null || this.m_width != this.m_imgDim.width || this.m_height != this.m_imgDim.height) {
                this.m_imgDim.width = this.m_width;
                this.m_imgDim.height = this.m_height;
                if (this.m_offScreen != null) {
                    this.m_offScreen.flush();
                }
                this.m_offScreen = this.createImage(this.m_width, this.m_height);
                this.prepareImage(this.m_offScreen, this);
                this.manageScrollbars();
                this.m_redraw = true;
            }
            if (this.m_redraw) {
                serializable = this;
                synchronized (serializable) {
                    Graphics graphics2 = this.m_offScreen.getGraphics();
                    graphics2.setColor(this.getBackground());
                    graphics2.setFont(graphics.getFont());
                    graphics2.fillRect(0, 0, this.m_width, this.m_height);
                    this.m_info.setGraphics(graphics2);
                    this.drawTree(this.m_unselLAF);
                    if (this.m_selected != null) {
                        this.drawPath(this.m_selLAF, this.m_selected, null);
                    }
                    this.m_redraw = false;
                    graphics2.dispose();
                    this.m_info.setGraphics(null);
                }
            }
            graphics.drawImage(this.m_offScreen, this.m_x, this.m_y, this);
            if (this.m_horz.isEnabled() && this.m_vert.isEnabled()) {
                serializable = this.m_horz.getBounds();
                Rectangle rectangle = this.m_vert.getBounds();
                graphics.clearRect(rectangle.x, ((Rectangle)serializable).y, rectangle.width, ((Rectangle)serializable).height);
            }
            serializable = this.getSize();
            int n = ((Dimension)serializable).width - (this.m_width + this.m_x);
            if (n > 0) {
                graphics.clearRect(((Dimension)serializable).width - n, 0, n, ((Dimension)serializable).height);
            }
            if ((n = ((Dimension)serializable).height - (this.m_height + this.m_y)) > 0) {
                graphics.clearRect(0, ((Dimension)serializable).height - n, ((Dimension)serializable).width, n);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 400);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.m_x = -this.m_horz.getValue();
        this.m_y = -this.m_vert.getValue();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Graphics graphics = this.m_offScreen.getGraphics();
        LETreeItem lETreeItem = this.getItemAt(n, n2, graphics);
        graphics.dispose();
        if (lETreeItem != null && lETreeItem != this.m_selected) {
            this.select(lETreeItem, true);
        }
        if (lETreeItem != null && mouseEvent.getClickCount() > 1) {
            if (lETreeItem.m_children != null) {
                lETreeItem.m_collapsed = !lETreeItem.m_collapsed;
                this.recalcTree();
            }
            this.notifyListeners(3, lETreeItem);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.doLayout();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.doLayout();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.doLayout();
    }

    public synchronized void doLayout() {
        if (this.m_width > -1) {
            this.manageScrollbars();
        }
    }

    public void drawTree(LETreeLAF lETreeLAF) {
        int n = this.m_items.size();
        int n2 = 0;
        while (n2 < n) {
            LETreeItem lETreeItem = (LETreeItem)this.m_items.elementAt(n2);
            this.drawItem(lETreeLAF, lETreeItem);
            ++n2;
        }
    }

    public void drawItem(LETreeLAF lETreeLAF, LETreeItem lETreeItem) {
        lETreeLAF.drawItem(lETreeItem);
        if (!lETreeItem.m_collapsed && lETreeItem.m_children != null) {
            LETreeItem lETreeItem2 = lETreeItem;
            int n = lETreeItem.m_children.size();
            int n2 = 0;
            while (n2 < n) {
                LETreeItem lETreeItem3 = (LETreeItem)lETreeItem.m_children.elementAt(n2);
                this.drawItem(lETreeLAF, lETreeItem3);
                if (n2 == n - 1) {
                    lETreeLAF.drawConnection(2, lETreeItem2.m_row, lETreeItem3);
                } else {
                    lETreeLAF.drawConnection(1, lETreeItem2.m_row, lETreeItem3);
                }
                lETreeItem2 = lETreeItem3;
                ++n2;
            }
        }
    }

    public void drawPath(LETreeLAF lETreeLAF, LETreeItem lETreeItem, LETreeItem lETreeItem2) {
        lETreeLAF.drawItem(lETreeItem);
        if (lETreeItem2 != null) {
            lETreeLAF.drawConnection(2, lETreeItem.m_row, lETreeItem2);
        }
        if (lETreeItem.m_parent != null) {
            this.drawPath(lETreeLAF, lETreeItem.m_parent, lETreeItem);
        }
    }

    public LETreeItem getItemAt(int n, int n2, Graphics graphics) {
        n -= this.m_x;
        int n3 = ((n2 -= this.m_y) - this.m_info.m_maxBorder) / (this.m_info.m_rowHeight + this.m_info.m_rowOffset);
        LETreeItem lETreeItem = this.getItemRow(this.m_items, n3);
        if (lETreeItem != null) {
            int n4 = lETreeItem.m_column * this.m_info.m_colOffset;
            int n5 = this.getItemWidth(lETreeItem, graphics);
            if (n < n4 || n > n5) {
                lETreeItem = null;
            }
        }
        return lETreeItem;
    }

    public LETreeItem getItemRow(Vector vector, int n) {
        LETreeItem lETreeItem = null;
        LETreeItem lETreeItem2 = null;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            lETreeItem = (LETreeItem)vector.elementAt(n3);
            if (lETreeItem.m_row == n) {
                lETreeItem2 = lETreeItem;
            } else if (!lETreeItem.m_collapsed && lETreeItem.m_children != null) {
                lETreeItem2 = this.getItemRow(lETreeItem.m_children, n);
            }
            if (lETreeItem2 != null) break;
            ++n3;
        }
        return lETreeItem2;
    }

    public LETreeItem getSelectedItem() {
        return this.m_selected;
    }

    public Vector getRoots() {
        return this.m_items;
    }

    public void select(LETreeItem lETreeItem, boolean bl) {
        if (bl && this.m_selected != null) {
            this.notifyListeners(2, this.m_selected);
        }
        boolean bl2 = false;
        LETreeItem lETreeItem2 = lETreeItem.m_parent;
        while (lETreeItem2 != null) {
            if (lETreeItem2.m_collapsed) {
                lETreeItem2.m_collapsed = false;
                bl2 = true;
            }
            lETreeItem2 = lETreeItem2.m_parent;
        }
        this.m_selected = lETreeItem;
        this.recalcTree();
        this.m_redraw = true;
        this.repaint();
        if (bl && this.m_selected != null) {
            this.notifyListeners(1, this.m_selected);
        }
    }

    int getItemWidth(LETreeItem lETreeItem, Graphics graphics) {
        int n = lETreeItem.m_column * this.m_info.m_colOffset + 2 * this.m_info.m_maxBorder + 2 * this.m_info.m_cellInset + this.m_info.m_maxImageWidth + this.m_info.m_imageBuffer + graphics.getFontMetrics().stringWidth(lETreeItem.m_label);
        return n;
    }

    void notifyListeners(int n, LETreeItem lETreeItem) {
        LETreeEvent lETreeEvent = new LETreeEvent(n, lETreeItem);
        int n2 = this.m_listeners.size();
        int n3 = 0;
        while (n3 < n2) {
            LETreeListener lETreeListener = (LETreeListener)this.m_listeners.elementAt(n3);
            if (lETreeListener != null) {
                lETreeListener.onLETreeEvent(lETreeEvent);
            }
            ++n3;
        }
    }

    int determineWidth(Vector vector, Graphics graphics) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            LETreeItem lETreeItem = (LETreeItem)vector.elementAt(n3);
            int n4 = this.getItemWidth(lETreeItem, graphics);
            int n5 = n = n4 > n ? n4 : n;
            if (!lETreeItem.m_collapsed && lETreeItem.m_children != null) {
                n4 = this.determineWidth(lETreeItem.m_children, graphics);
            }
            n = n4 > n ? n4 : n;
            ++n3;
        }
        return n;
    }

    void manageScrollbars() {
        Dimension dimension = this.m_vert.getPreferredSize();
        Dimension dimension2 = this.m_horz.getPreferredSize();
        Dimension dimension3 = this.getSize();
        int n = this.m_width - dimension3.width;
        int n2 = this.m_height - dimension3.height;
        if (n > 0 && n2 > 0) {
            this.manageVSB(true, dimension3.height - dimension2.height, this.m_height, dimension3.width - dimension.width, 0, dimension.width, dimension3.height - dimension2.height);
            this.manageHSB(true, dimension3.width - dimension.width, this.m_width, 0, dimension3.height - dimension2.height, dimension3.width - dimension.width, dimension2.height);
            return;
        }
        if (n > 0 && n2 + dimension2.height > 0) {
            this.manageVSB(true, dimension3.height - dimension2.height, this.m_height, dimension3.width - dimension.width, 0, dimension.width, dimension3.height - dimension2.height);
            this.manageHSB(true, dimension3.width - dimension.width, this.m_width, 0, dimension3.height - dimension2.height, dimension3.width - dimension.width, dimension2.height);
            return;
        }
        if (n2 > 0 && n + dimension.width > 0) {
            this.manageVSB(true, dimension3.height - dimension2.height, this.m_height, dimension3.width - dimension.width, 0, dimension.width, dimension3.height - dimension2.height);
            this.manageHSB(true, dimension3.width - dimension.width, this.m_width, 0, dimension3.height - dimension2.height, dimension3.width - dimension.width, dimension2.height);
            return;
        }
        if (n > 0) {
            this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.manageHSB(true, dimension3.width, this.m_width, 0, dimension3.height - dimension2.height, dimension3.width, dimension2.height);
            return;
        }
        if (n2 > 0) {
            this.manageVSB(true, dimension3.height, this.m_height, dimension3.width - dimension.width, 0, dimension.width, dimension3.height);
            this.manageHSB(false, 0, 0, 0, 0, 0, 0);
            return;
        }
        this.manageVSB(false, 0, 0, 0, 0, 0, 0);
        this.manageHSB(false, 0, 0, 0, 0, 0, 0);
    }

    void manageVSB(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        if (bl) {
            int n7 = 0;
            if (this.m_vert.isEnabled()) {
                n7 = this.m_vert.getValue();
            }
            n7 = n7 > n2 ? n2 : n7;
            this.m_y = -n7;
            this.m_vert.setBounds(n3, n4, n5, n6);
            this.m_vert.setValues(n7, n, 0, n2);
            this.m_vert.setUnitIncrement(this.m_info.m_rowHeight + this.m_info.m_rowOffset);
            this.m_vert.setBlockIncrement(n6);
            this.m_vert.setVisible(true);
            if (this.isEnabled()) {
                this.m_vert.setEnabled(true);
                return;
            }
            this.m_vert.setEnabled(false);
            return;
        }
        this.m_vert.setVisible(false);
        this.m_vert.setEnabled(false);
        this.m_y = 0;
    }

    void manageHSB(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        if (bl) {
            int n7 = 0;
            if (this.m_horz.isEnabled()) {
                n7 = this.m_horz.getValue();
            }
            n7 = n7 > n2 ? n2 : n7;
            this.m_x = -n7;
            this.m_horz.setBounds(n3, n4, n5, n6);
            this.m_horz.setValues(0, n, 0, n2);
            this.m_horz.setUnitIncrement(this.m_info.m_colOffset);
            this.m_horz.setBlockIncrement(n5);
            this.m_horz.setVisible(true);
            if (this.isEnabled()) {
                this.m_horz.setEnabled(true);
                return;
            }
            this.m_horz.setEnabled(false);
            return;
        }
        this.m_horz.setVisible(false);
        this.m_horz.setEnabled(false);
        this.m_x = 0;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_redraw = true;
            this.repaint();
            return false;
        }
        return true;
    }
}

