/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEModemSummaryMessage;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;

public class LEModemSummaryView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Button m_details;

    public LEModemSummaryView() {
        this.initialize(1, 2, 7);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 2;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_buttons.remove(this.m_reset);
        this.m_buttons.remove(this.m_restore);
        this.m_details = new Button("Details...");
        this.m_buttons.add((Component)this.m_details, 0);
        this.m_details.addActionListener(this);
        this.m_details.setEnabled(false);
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        super.onLEMLEvent(lEMLEvent);
        Frame frame = LEUiUtils.getFrame(this);
        if (!(frame instanceof LEViewSubWindow) && lEMLEvent.getType() == 3) {
            int n = this.getSelectSize();
            if (n == 1) {
                this.m_details.setEnabled(true);
                return;
            }
            this.m_details.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_details) {
            int[] nArray = this.getSelectedRows();
            if (nArray.length > 0) {
                String string = (String)this.getCellItem(nArray[0], 0);
                String string2 = (String)this.getCellItem(nArray[0], 1);
                if (string2.length() == 0) {
                    string2 = null;
                }
                LEMonitorDetailPanel.Display(string, string2);
                if (this.m_listener != null) {
                    LEVector lEVector = new LEVector();
                    lEVector.addElement(LEControlTree.ROOT);
                    lEVector.addElement(LEControlTree.MONITOR);
                    lEVector.addElement(LEControlTree.MODEMS);
                    LEViewEvent lEViewEvent = new LEViewEvent(3, lEVector);
                    this.m_listener.onLEViewEvent(lEViewEvent);
                    return;
                }
            }
        } else {
            if (actionEvent.getSource() == this.m_tearoff) {
                this.m_details.setEnabled(false);
                super.actionPerformed(actionEvent);
                return;
            }
            super.actionPerformed(actionEvent);
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEModemSummaryMessage) {
            LEModemSummaryMessage lEModemSummaryMessage = (LEModemSummaryMessage)object;
            String string2 = lEModemSummaryMessage.getBoard();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lEModemSummaryMessage);
                return;
            }
            this.updateRow(n, lEModemSummaryMessage);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("Total");
        objectArray[n2++] = new String("Down");
        objectArray[n2++] = new String("Admin");
        objectArray[n2++] = new String("Test");
        objectArray[n2++] = new String("Ready");
        objectArray[n2++] = new String("Connecting");
        objectArray[n2++] = new String("Established");
    }

    void createRow(String string, String string2, LEModemSummaryMessage lEModemSummaryMessage) {
        Object[] objectArray = new Object[11];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEModemSummaryMessage.getBoard();
        objectArray[n++] = new Integer(lEModemSummaryMessage.getTotal());
        objectArray[n++] = new Integer(lEModemSummaryMessage.getDeadCount() + lEModemSummaryMessage.getErrorCount());
        objectArray[n++] = new Integer(lEModemSummaryMessage.getAdminCount());
        objectArray[n++] = new Integer(lEModemSummaryMessage.getTestCount());
        objectArray[n++] = new Integer(lEModemSummaryMessage.getReadyCount());
        objectArray[n++] = new Integer(lEModemSummaryMessage.getBoundCount() + lEModemSummaryMessage.getConnCount());
        objectArray[n++] = new Integer(lEModemSummaryMessage.getEstabCount());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEModemSummaryMessage lEModemSummaryMessage) {
        int n2 = 0;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, new Integer(lEModemSummaryMessage.getTotal()));
        int n4 = ++n2;
        this.setCellItem(n, n4, new Integer(lEModemSummaryMessage.getDeadCount() + lEModemSummaryMessage.getErrorCount()));
        int n5 = ++n2;
        this.setCellItem(n, n5, new Integer(lEModemSummaryMessage.getAdminCount()));
        int n6 = ++n2;
        this.setCellItem(n, n6, new Integer(lEModemSummaryMessage.getTestCount()));
        int n7 = ++n2;
        this.setCellItem(n, n7, new Integer(lEModemSummaryMessage.getReadyCount()));
        int n8 = ++n2;
        this.setCellItem(n, n8, new Integer(lEModemSummaryMessage.getBoundCount() + lEModemSummaryMessage.getConnCount()));
        int n9 = ++n2;
        ++n2;
        this.setCellItem(n, n9, new Integer(lEModemSummaryMessage.getEstabCount()));
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEModemSummaryView.s_monitors[0] = 0x2C0000;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor Modem Summary";
    }
}

