/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDeltaLinesMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.util.LEAlphaNumericCompare;

public class LEMonLinesView
extends LEMonitorPanel {
    static int[] s_monitors = null;

    public LEMonLinesView() {
        this.initialize(1, 3, 10);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 4;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[7];
        int n3 = 0;
        while (n3 < 7) {
            this.m_resetCols[n3] = n3 + 6;
            ++n3;
        }
        this.setSortObject(2, new LEAlphaNumericCompare());
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEDeltaLinesMessage) {
            LEDeltaLinesMessage lEDeltaLinesMessage = (LEDeltaLinesMessage)object;
            String string2 = String.valueOf(lEDeltaLinesMessage.getBoard()) + lEDeltaLinesMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n != null) {
                this.updateRow((int)n, lEDeltaLinesMessage);
                return;
            }
        } else {
            if (object instanceof LEMonLinesMessage) {
                LEMonLinesMessage lEMonLinesMessage = (LEMonLinesMessage)object;
                String string3 = String.valueOf(lEMonLinesMessage.getBoard()) + lEMonLinesMessage.getName();
                Integer n = this.getRow(string, string3);
                if (n == null) {
                    this.createRow(string, string3, lEMonLinesMessage);
                    return;
                }
                this.updateRow((int)n, lEMonLinesMessage);
                return;
            }
            if (object instanceof LEStatusMessage) {
                this.updateStatus(string, (LEStatusMessage)object);
            }
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("Line");
        objectArray[n2++] = new String("Layer 1");
        objectArray[n2++] = new String("Layer 2");
        objectArray[n2++] = new String("Receive Level");
        objectArray[n2++] = new String("Blue Alarm");
        objectArray[n2++] = new String("Yellow Alarm");
        objectArray[n2++] = new String("Carrier Loss");
        objectArray[n2++] = new String("Sync Loss");
        objectArray[n2++] = new String("Bipolar Error");
        objectArray[n2++] = new String("CRC Error");
        objectArray[n2++] = new String("Multiframe Sync Error");
    }

    void createRow(String string, String string2, LEMonLinesMessage lEMonLinesMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonLinesMessage.getBoard();
        objectArray[n++] = lEMonLinesMessage.getName();
        objectArray[n++] = lEMonLinesMessage.getStatus();
        objectArray[n++] = lEMonLinesMessage.getStatus2();
        objectArray[n++] = lEMonLinesMessage.getRecvLevel();
        objectArray[n++] = new Long(lEMonLinesMessage.getBlueAlarm());
        objectArray[n++] = new Long(lEMonLinesMessage.getYellowAlarm());
        objectArray[n++] = new Long(lEMonLinesMessage.getCarrierLoss());
        objectArray[n++] = new Long(lEMonLinesMessage.getSyncLoss());
        objectArray[n++] = new Long(lEMonLinesMessage.getBIPolarError());
        objectArray[n++] = new Long(lEMonLinesMessage.getCRCError());
        objectArray[n++] = new Long(lEMonLinesMessage.getSyncError());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonLinesMessage lEMonLinesMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEMonLinesMessage.getStatus());
        int n4 = ++n2;
        this.setCellItem(n, n4, lEMonLinesMessage.getStatus2());
        int n5 = ++n2;
        ++n2;
        this.setCellItem(n, n5, lEMonLinesMessage.getRecvLevel());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getBlueAlarm()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getYellowAlarm()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getCarrierLoss()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getSyncLoss()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getBIPolarError()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getCRCError()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getSyncError()));
    }

    void updateRow(int n, LEDeltaLinesMessage lEDeltaLinesMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        if (lEDeltaLinesMessage.getRecvLevelChanged()) {
            this.setCellItem(n, n2, lEDeltaLinesMessage.getRecvLevel());
        }
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        if (lEDeltaLinesMessage.getBlueAlarmChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getBlueAlarm()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getYellowAlarmChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getYellowAlarm()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getCarrierLossChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getCarrierLoss()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getSyncLossChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getSyncLoss()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getBIPolarErrorChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getBIPolarError()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getCRCErrorChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getCRCError()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getSyncErrorChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getSyncError()));
        }
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonLinesView.s_monitors[0] = 131072;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor Lines";
    }
}

