/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEModemSummaryMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEMonitorFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEMonTotalsView
extends Panel
implements LEView,
LEAMObserver,
ActionListener,
Runnable {
    static LEPortMaster s_pm = null;
    LEPortMaster[] m_pms;
    LEMultiList m_lineList;
    LEMultiList m_modemList;
    Panel m_buttons;
    Button m_reset;
    Button m_restore;
    Label m_time;
    Hashtable m_lineMsgs = new Hashtable();
    Hashtable m_modemMsgs = new Hashtable();
    Hashtable m_counters = new Hashtable();
    Thread m_thread;

    public LEMonTotalsView() {
        this.setLayout(new BorderLayout(5, 5));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        this.m_lineList = new LEMultiList(1, 1, 7);
        Object[] objectArray = new String[]{"PortMaster", "Lines", "Blue Alarm", "Yellow Alarm", "Carrier Loss", "Sync Loss", "Bipolar Err", "CRC Err"};
        this.m_lineList.setTitles(0, objectArray);
        int n = 1;
        while (n < 8) {
            this.m_lineList.setCellJustification(n, 2);
            ++n;
        }
        panel.add(new LEScrollPanel(this.m_lineList));
        this.m_modemList = new LEMultiList(1, 1, 7);
        objectArray = new String[]{"PortMaster", "Modems", "Down", "Admin", "Test", "Ready", "Connecting", "Established"};
        this.m_modemList.setTitles(0, objectArray);
        int n2 = 1;
        while (n2 < 8) {
            this.m_modemList.setCellJustification(n2, 2);
            ++n2;
        }
        panel.add(new LEScrollPanel(this.m_modemList));
        this.add("Center", panel);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        this.m_reset = new Button("Reset Counters");
        this.m_buttons.add(this.m_reset);
        this.m_restore = new Button("Restore Counters");
        this.m_buttons.add(this.m_restore);
        this.m_time = new Label("");
        this.m_buttons.add(this.m_time);
        this.m_reset.addActionListener(this);
        this.m_restore.addActionListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void addListener(LEViewListener lEViewListener) {
    }

    public void deleteListener(LEViewListener lEViewListener) {
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        if (this.m_pms != null) {
            this.m_lineList.deleteAllRows();
            this.m_modemList.deleteAllRows();
            int n = 0;
            while (n < this.m_pms.length) {
                LEStatusFactory.GetFactory().deleteObserver(this.m_pms[n].getHostname(), this);
                this.stopMonitoring(this.m_pms[n]);
                ++n;
            }
        }
        this.m_pms = lEPortMasterArray;
        int n = 0;
        while (n < this.m_pms.length) {
            String string = this.m_pms[n].getHostname();
            if (!this.m_counters.containsKey(string)) {
                LEVector lEVector = new LEVector();
                lEVector.addElement(new Long(0L));
                lEVector.addElement(new Long(0L));
                lEVector.addElement(new Long(0L));
                lEVector.addElement(new Long(0L));
                lEVector.addElement(new Long(0L));
                lEVector.addElement(new Long(0L));
                this.m_counters.put(string, lEVector);
            }
            Object[] objectArray = new String[]{string, "", "", "", "", "", "", ""};
            this.m_lineList.addRow(objectArray);
            objectArray = new String[]{string, "", "", "", "", "", "", ""};
            this.m_modemList.addRow(objectArray);
            LEStatusFactory.GetFactory().addObserver(this.m_pms[n].getHostname(), this);
            this.startMonitoring(this.m_pms[n]);
            ++n;
        }
        this.m_lineList.redraw();
    }

    public void going() {
        int n = 0;
        while (n < this.m_pms.length) {
            LEStatusFactory.GetFactory().deleteObserver(this.m_pms[n].getHostname(), this);
            this.stopMonitoring(this.m_pms[n]);
            ++n;
        }
        this.m_pms = null;
        this.m_thread.stop();
    }

    public void gone() {
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonLinesMessage) {
            this.updateLine(string, (LEMonLinesMessage)object);
        }
        if (object instanceof LEModemSummaryMessage) {
            this.updateModem(string, (LEModemSummaryMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
            while (true) {
                this.updateLineStatistics();
                this.updateModemStatistics();
                Thread.currentThread();
                Thread.sleep(30000L);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = actionEvent.getSource() == this.m_reset;
        int n = this.m_lineList.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.m_lineList.getCellItem(n2, 0);
            LEVector lEVector = (LEVector)this.m_counters.get(string);
            if (lEVector != null) {
                int n3 = 2;
                while (n3 < 8) {
                    Long l;
                    if (bl) {
                        Long l2 = (Long)this.m_lineList.getCellItem(n2, n3);
                        Long l3 = (Long)lEVector.elementAt(n3 - 2);
                        l = new Long(l3 + l2);
                    } else {
                        l = new Long(0L);
                    }
                    lEVector.setElementAt(l, n3 - 2);
                    ++n3;
                }
            }
            ++n2;
        }
        if (bl) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
            this.m_time.setText("Last Reset: " + dateFormat.format(date));
        } else {
            this.m_time.setText("");
        }
        this.m_buttons.invalidate();
        this.m_buttons.validate();
        this.updateLineStatistics();
    }

    synchronized void updateModemStatistics() {
        int n = this.m_modemList.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            String string = (String)this.m_modemList.getCellItem(n2, 0);
            Hashtable hashtable = (Hashtable)this.m_modemMsgs.get(string);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    LEModemSummaryMessage lEModemSummaryMessage = (LEModemSummaryMessage)enumeration.nextElement();
                    l += (long)lEModemSummaryMessage.getTotal();
                    l2 += (long)(lEModemSummaryMessage.getDeadCount() + lEModemSummaryMessage.getErrorCount());
                    l3 += (long)lEModemSummaryMessage.getAdminCount();
                    l4 += (long)lEModemSummaryMessage.getTestCount();
                    l5 += (long)lEModemSummaryMessage.getReadyCount();
                    l6 += (long)(lEModemSummaryMessage.getBoundCount() + lEModemSummaryMessage.getConnCount());
                    l7 += (long)lEModemSummaryMessage.getEstabCount();
                }
            }
            this.m_modemList.setCellItem(n2, 1, new Long(l));
            this.m_modemList.setCellItem(n2, 2, new Long(l2));
            this.m_modemList.setCellItem(n2, 3, new Long(l3));
            this.m_modemList.setCellItem(n2, 4, new Long(l4));
            this.m_modemList.setCellItem(n2, 5, new Long(l5));
            this.m_modemList.setCellItem(n2, 6, new Long(l6));
            this.m_modemList.setCellItem(n2, 7, new Long(l7));
            ++n2;
        }
    }

    synchronized void updateLineStatistics() {
        int n = this.m_lineList.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            LEVector lEVector;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            String string = (String)this.m_lineList.getCellItem(n2, 0);
            Hashtable hashtable = (Hashtable)this.m_lineMsgs.get(string);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    LEMonLinesMessage lEMonLinesMessage = (LEMonLinesMessage)enumeration.nextElement();
                    ++l;
                    l2 += lEMonLinesMessage.getBlueAlarm();
                    l3 += lEMonLinesMessage.getYellowAlarm();
                    l4 += lEMonLinesMessage.getCarrierLoss();
                    l5 += lEMonLinesMessage.getSyncLoss();
                    l6 += lEMonLinesMessage.getBIPolarError();
                    l7 += lEMonLinesMessage.getCRCError();
                }
            }
            if ((lEVector = (LEVector)this.m_counters.get(string)) != null) {
                l2 -= ((Long)lEVector.elementAt(0)).longValue();
                l3 -= ((Long)lEVector.elementAt(1)).longValue();
                l4 -= ((Long)lEVector.elementAt(2)).longValue();
                l5 -= ((Long)lEVector.elementAt(3)).longValue();
                l6 -= ((Long)lEVector.elementAt(4)).longValue();
                l7 -= ((Long)lEVector.elementAt(5)).longValue();
            }
            this.m_lineList.setCellItem(n2, 1, new Long(l));
            this.m_lineList.setCellItem(n2, 2, new Long(l2));
            this.m_lineList.setCellItem(n2, 3, new Long(l3));
            this.m_lineList.setCellItem(n2, 4, new Long(l4));
            this.m_lineList.setCellItem(n2, 5, new Long(l5));
            this.m_lineList.setCellItem(n2, 6, new Long(l6));
            this.m_lineList.setCellItem(n2, 7, new Long(l7));
            ++n2;
        }
        this.m_lineList.redraw();
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        LEMonitorFactory.GetFactory().addObserver(lEPortMaster.getHostname(), this);
        LEMonitorFacility lEMonitorFacility = lEPortMaster.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        lEMonitorFacility.startMonitor(131072, -1);
        lEMonitorFacility.startMonitor(0x2C0000, -1);
    }

    void stopMonitoring(LEPortMaster lEPortMaster) {
        LEMonitorFactory.GetFactory().deleteObserver(lEPortMaster.getHostname(), this);
        LEMonitorFacility lEMonitorFacility = lEPortMaster.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        lEMonitorFacility.stopMonitor(131072, -1);
        lEMonitorFacility.stopMonitor(0x2C0000, -1);
    }

    void updateLine(String string, LEMonLinesMessage lEMonLinesMessage) {
        String string2 = lEMonLinesMessage.getName();
        String string3 = lEMonLinesMessage.getBoard();
        String string4 = string3 != null ? String.valueOf(string2) + " " + string3 : string2;
        Hashtable<String, LEMonLinesMessage> hashtable = (Hashtable<String, LEMonLinesMessage>)this.m_lineMsgs.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, LEMonLinesMessage>();
            this.m_lineMsgs.put(string, hashtable);
        }
        hashtable.put(string4, lEMonLinesMessage);
    }

    void updateModem(String string, LEModemSummaryMessage lEModemSummaryMessage) {
        String string2 = lEModemSummaryMessage.getBoard();
        String string3 = string2 != null ? string2 : " ";
        Hashtable<String, LEModemSummaryMessage> hashtable = (Hashtable<String, LEModemSummaryMessage>)this.m_modemMsgs.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, LEModemSummaryMessage>();
            this.m_modemMsgs.put(string, hashtable);
        }
        hashtable.put(string3, lEModemSummaryMessage);
    }

    void updateStatus(String string, LEStatusMessage lEStatusMessage) {
        if (this.m_pms == null) {
            return;
        }
        LEPortMaster lEPortMaster = null;
        int n = 0;
        while (n < this.m_pms.length) {
            if (this.m_pms[n].getHostname().equals(string)) {
                lEPortMaster = this.m_pms[n];
            }
            ++n;
        }
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                if (lEPortMaster == null) break;
                this.startMonitoring(lEPortMaster);
                return;
            }
            case 2: 
            case 4: {
                if (lEPortMaster == null) break;
                this.stopMonitoring(lEPortMaster);
                return;
            }
        }
    }
}

