/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEMonModemsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPort;
import COM.livingston.model.LEPorts;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class LEMonUsersView
extends LEMonitorDetailPanel {
    static int[] s_monitors = null;
    Button m_resetPorts;

    public LEMonUsersView() {
        this.initialize(1, 3, 10);
        this.setCellJustification(1, 2);
        this.getNumColumns();
        int n = 5;
        while (n < 11) {
            this.setCellJustification(n, 2);
            ++n;
        }
        this.m_resetCols = new int[2];
        this.m_resetCols[0] = 7;
        this.m_resetCols[1] = 8;
        this.m_resetPorts = new Button("Reset Port");
        this.m_buttons.add((Component)this.m_resetPorts, 0);
        this.m_resetPorts.addActionListener(this);
        this.m_resetPorts.setEnabled(false);
    }

    public synchronized void onLEMLEvent(LEMLEvent lEMLEvent) {
        super.onLEMLEvent(lEMLEvent);
        if (lEMLEvent.getType() == 3) {
            if (this.getSelectSize() > 0) {
                this.m_resetPorts.setEnabled(true);
                return;
            }
            this.m_resetPorts.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.m_resetPorts) {
            super.actionPerformed(actionEvent);
            return;
        }
        if (this.getSelectSize() == 0) {
            return;
        }
        LEMonUsersView lEMonUsersView = this;
        synchronized (lEMonUsersView) {
            LEConfig lEConfig;
            Object object;
            LEPorts lEPorts = null;
            if (this.m_selected_brd != null) {
                object = (LEBoards)this.m_selected_pm.get("2555904");
                if (object == null) {
                    return;
                }
                lEConfig = (LEBoard)((LEConfig)object).get(this.m_selected_brd);
                if (lEConfig == null) {
                    return;
                }
                lEPorts = (LEPorts)lEConfig.get(LEBoard.PORTS);
            } else {
                lEPorts = (LEPorts)this.m_selected_pm.get("262144");
            }
            if (lEPorts == null) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            int n = 0;
            while (true) {
                if (n >= nArray.length) break;
                object = (String)this.getCellItem(nArray[n], 3);
                lEConfig = null;
                LEVector lEVector = null;
                if (object != null) {
                    lEConfig = lEPorts.getPort((String)object);
                }
                if (lEConfig != null) {
                    lEVector = ((LEPort)lEConfig).reset();
                }
                if (lEVector != null) {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), this.m_selected_pm.getConfigFacility(), lEVector);
                }
                ++n;
            }
            int n2 = 0;
            while (true) {
                if (n2 >= nArray.length) {
                    return;
                }
                this.removeRow(nArray[n2] - n2);
                ++n2;
            }
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonSessionsMessage) {
            this.updateSession(string, (LEMonSessionsMessage)object);
            return;
        }
        if (object instanceof LEMonModemsMessage) {
            this.updateModem(string, (LEMonModemsMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("User");
        objectArray[n2++] = new String("Port");
        objectArray[n2++] = new String("Modem");
        objectArray[n2++] = new String("Start");
        objectArray[n2++] = new String("Idle");
        objectArray[n2++] = new String("In Bytes");
        objectArray[n2++] = new String("Out Bytes");
        objectArray[n2++] = new String("RD Rate");
        objectArray[n2++] = new String("TR Rate");
        objectArray[n2++] = new String("Protocol");
        objectArray[n2++] = new String("Comp.");
    }

    void createRow(String string, String string2, LEMonSessionsMessage lEMonSessionsMessage) {
        Object[] objectArray = new Object[13];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonSessionsMessage.getBoard();
        objectArray[n++] = lEMonSessionsMessage.getUsername();
        objectArray[n++] = lEMonSessionsMessage.getPortName();
        objectArray[n++] = new String("");
        objectArray[n++] = lEMonSessionsMessage.getStartTime();
        objectArray[n++] = lEMonSessionsMessage.getIdleTime();
        objectArray[n++] = new Long(lEMonSessionsMessage.getInputBytes());
        objectArray[n++] = new Long(lEMonSessionsMessage.getOutputBytes());
        objectArray[n++] = new String("");
        objectArray[n++] = new String("");
        objectArray[n++] = new String("");
        objectArray[n++] = new String("");
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonSessionsMessage lEMonSessionsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEMonSessionsMessage.getStartTime());
        int n4 = ++n2;
        ++n2;
        this.setCellItem(n, n4, lEMonSessionsMessage.getIdleTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData != null) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getInputBytes()));
        }
        ++n2;
        if (lEMonitorData != null) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getOutputBytes()));
        }
        ++n2;
    }

    void updateRow(int n, LEMonModemsMessage lEMonModemsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        int n3 = ++n2;
        ++n2;
        this.setCellItem(n, n3, lEMonModemsMessage.getName());
        ++n2;
        ++n2;
        ++n2;
        int n4 = ++n2;
        this.setCellItem(n, n4, lEMonModemsMessage.getRXRate());
        int n5 = ++n2;
        this.setCellItem(n, n5, lEMonModemsMessage.getTXRate());
        int n6 = ++n2;
        this.setCellItem(n, n6, lEMonModemsMessage.getProtocol());
        int n7 = ++n2;
        ++n2;
        this.setCellItem(n, n7, lEMonModemsMessage.getCompression());
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[2];
            LEMonUsersView.s_monitors[0] = 65536;
            LEMonUsersView.s_monitors[1] = 196608;
        }
        return s_monitors;
    }

    boolean isValidBoardType(String string) {
        return string.equals("Quad T1") || string.equals("Tri E1");
    }

    void updateSession(String string, LEMonSessionsMessage lEMonSessionsMessage) {
        if (this.m_selected_pm == null || !string.equals(this.m_selected_pm.getHostname())) {
            return;
        }
        if (!this.isCurrentBoard(lEMonSessionsMessage.getBoard())) {
            return;
        }
        String string2 = lEMonSessionsMessage.getPortName();
        String string3 = lEMonSessionsMessage.getUsername();
        Integer n = this.getRow(string, string2);
        if (n == null) {
            if (string3 != null && string3.length() > 0) {
                this.createRow(string, string2, lEMonSessionsMessage);
                return;
            }
        } else {
            if (string3 != null && string3.length() > 0) {
                String string4 = (String)this.getCellItem(n, 2);
                if (string4.equals(string3)) {
                    this.updateRow((int)n, lEMonSessionsMessage);
                    return;
                }
                this.removeRow(n);
                this.createRow(string, string2, lEMonSessionsMessage);
                return;
            }
            this.removeRow(n);
        }
    }

    void updateModem(String string, LEMonModemsMessage lEMonModemsMessage) {
        if (this.m_selected_pm == null || !string.equals(this.m_selected_pm.getHostname())) {
            return;
        }
        if (!this.isCurrentBoard(lEMonModemsMessage.getBoard())) {
            return;
        }
        String string2 = lEMonModemsMessage.getPortName();
        Integer n = this.getRow(string, string2);
        if (n != null) {
            this.updateRow((int)n, lEMonModemsMessage);
        }
    }

    void removeRow(int n) {
        this.deleteRow(n);
        this.rebuildRowKeys();
    }

    String getMonitorName() {
        return "Monitor Users";
    }
}

