/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.ui.LEImageView;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.util.LEResource;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEMonitorLegend
extends Frame
implements WindowListener,
ItemListener {
    static final String IRX_111 = "IRX-111";
    static final String IRX_112 = "IRX-112";
    static final String IRX_114 = "IRX-114";
    static final String IRX_211 = "IRX-211";
    static final String OR_AP = "OR-AP";
    static final String OR_HS = "OR-HS";
    static final String OR_LS = "OR-LS";
    static final String OR_M = "OR-M";
    static final String OR_ST = "OR-ST";
    static final String OR_U = "OR-U";
    static final String PM_4 = "PM-4";
    static final String PM_3 = "PM-3";
    static final String PM_2 = "PM-2/PM-2r";
    static final String PM_2E = "PM-2e/PM-2er";
    static final String PM_2EI = "PM-2ei";
    static final String PM_25 = "PM-25";
    static LEMonitorLegend s_legend = null;
    LEScrollPanel m_main;

    public static void Display() {
        if (s_legend == null) {
            s_legend = new LEMonitorLegend();
            return;
        }
        s_legend.toFront();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.showLegend((String)itemEvent.getItem());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        s_legend = null;
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    LEMonitorLegend() {
        super("Monitor Legend");
        this.addWindowListener(this);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        Choice choice = new Choice();
        choice.add(PM_4);
        choice.add(PM_3);
        choice.add(PM_2);
        choice.add(PM_2E);
        choice.add(PM_2EI);
        choice.add(PM_25);
        choice.add(OR_AP);
        choice.add(OR_HS);
        choice.add(OR_M);
        choice.add(OR_ST);
        choice.add(OR_U);
        choice.add(IRX_111);
        choice.add(IRX_112);
        choice.add(IRX_114);
        choice.add(IRX_211);
        choice.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.add(new Label("PortMaster Model: "));
        panel.add(choice);
        this.add("North", panel);
        this.m_main = new LEScrollPanel();
        this.add("Center", this.m_main);
        this.showLegend(choice.getItem(0));
        this.pack();
        ((Component)this).setVisible(true);
    }

    void showLegend(String string) {
        Image image = this.getImageFor(string);
        LEScrollablePanel lEScrollablePanel = image != null ? new LEScrollablePanel(new LEImageView(image), false, false) : new LEScrollablePanel(new Panel(), false, false);
        this.m_main.setScrollable(lEScrollablePanel);
    }

    Image getImageFor(String string) {
        Image image = null;
        if (string.equals(PM_4)) {
            image = LEResource.GetImage("pm4_legend.gif");
        } else if (string.equals(PM_3)) {
            image = LEResource.GetImage("pm3_legend.gif");
        } else if (string.equals(PM_2)) {
            image = LEResource.GetImage("pm2_legend.gif");
        } else if (string.equals(PM_2E)) {
            image = LEResource.GetImage("pm2e_legend.gif");
        } else if (string.equals(PM_2EI)) {
            image = LEResource.GetImage("pm2ei_legend.gif");
        } else if (string.equals(PM_25)) {
            image = LEResource.GetImage("pm25_legend.gif");
        } else if (string.equals(OR_AP)) {
            image = LEResource.GetImage("oru-fr.gif");
        } else if (string.equals(OR_HS)) {
            image = LEResource.GetImage("orhs-fr.gif");
        } else if (string.equals(OR_LS)) {
            image = LEResource.GetImage("orls-fr.gif");
        } else if (string.equals(OR_M)) {
            image = LEResource.GetImage("orm-fr.gif");
        } else if (string.equals(OR_ST)) {
            image = LEResource.GetImage("orst-fr.gif");
        } else if (string.equals(OR_U)) {
            image = LEResource.GetImage("oru-fr.gif");
        } else if (string.equals(IRX_111)) {
            image = LEResource.GetImage("rx111.gif");
        } else if (string.equals(IRX_112)) {
            image = LEResource.GetImage("rx112.gif");
        } else if (string.equals(IRX_114)) {
            image = LEResource.GetImage("rx114.gif");
        } else if (string.equals(IRX_211)) {
            image = LEResource.GetImage("rx211.gif");
        }
        return image;
    }
}

