/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEDataSpecFactory;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class LESaveView
extends LEBorderPanel
implements LEView,
LEConfirmClient,
Runnable,
ActionListener,
ItemListener {
    static Insets s_defInsets = new Insets(3, 5, 3, 5);
    Label m_boxes;
    Checkbox m_entire;
    Checkbox m_specific;
    Panel m_switches;
    Panel m_buttons;
    Button m_save;
    Button m_browse;
    Button m_cancel;
    TextField m_path;
    TextArea m_comments;
    File m_file;
    Hashtable m_tags;
    LEVector m_pms;
    LEViewListener m_listener;
    boolean m_cancelFlag;
    boolean m_secrets;
    boolean m_passwords;

    public LESaveView() {
        this.setInsets(5, 5, 5, 5);
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        this.createMain(panel);
        this.add("Center", panel);
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_pms = new LEVector();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(lEPortMasterArray[n].getHostname());
            this.m_pms.addElement(lEPortMasterArray[n]);
            ++n;
        }
        this.m_boxes.setText(new String(stringBuffer));
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        if (this.m_buttons == null) {
            this.m_buttons = new Panel();
            this.m_buttons.setLayout(new FlowLayout(1));
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(1, 2, 10, 10));
            this.m_save = new Button("Back Up");
            panel.add(this.m_save);
            this.m_save.addActionListener(this);
            this.m_cancel = new Button("Cancel");
            panel.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            this.m_cancel.setEnabled(false);
            this.m_buttons.add(panel);
        }
        return this.m_buttons;
    }

    public void going() {
    }

    public void gone() {
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_save) {
            this.save();
            return;
        }
        if (actionEvent.getSource() == this.m_cancel) {
            this.m_cancelFlag = true;
            this.m_cancel.setEnabled(false);
            return;
        }
        this.browse();
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.saveToFile((File)object);
        }
    }

    public void cancelAction(Object object) {
    }

    public void run() {
        this.lock();
        try {
            String string = this.m_file.getPath();
            LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string, 1);
            lEDSSFlatFile.connect();
            lEDSSFlatFile.writeComments(this.m_comments.getText());
            this.m_cancelFlag = false;
            int n = this.m_pms.size();
            int n2 = 0;
            while (!this.m_cancelFlag && n2 < n) {
                LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.elementAt(n2);
                if (lEPortMaster.isConnected()) {
                    this.savePM(lEDSSFlatFile, lEPortMaster);
                }
                ++n2;
            }
            lEDSSFlatFile.disconnect();
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), iOException.getMessage());
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        LEStatusManager.StatusComplete();
        this.unlock();
    }

    void savePM(LEDSSFlatFile lEDSSFlatFile, LEPortMaster lEPortMaster) {
        boolean bl = !this.m_specific.getState();
        Component[] componentArray = this.m_switches.getComponents();
        int n = 0;
        while (!this.m_cancelFlag && n < componentArray.length) {
            if (componentArray[n] instanceof Checkbox) {
                Checkbox checkbox = (Checkbox)componentArray[n];
                if (bl || checkbox.getState()) {
                    String string = checkbox.getLabel();
                    String string2 = (String)this.m_tags.get(checkbox);
                    this.saveSection(lEDSSFlatFile, lEPortMaster, string, string2);
                }
            }
            ++n;
        }
    }

    void saveSection(LEDSSFlatFile lEDSSFlatFile, LEPortMaster lEPortMaster, String string, String string2) {
        if (this.m_secrets && (string2.equals("2228224") || string2.equals("1507328"))) {
            lEPortMaster.get(string2);
            lEPortMaster.getSecrets();
        }
        if (this.m_passwords && string2.equals("1835008")) {
            lEPortMaster.get(string2);
            lEPortMaster.getUserPasswords();
        }
        LEStatusManager.SetStatus("Saving " + string + " commands for " + lEPortMaster.getHostname());
        LEConfig lEConfig = (LEConfig)lEPortMaster.get(string2);
        if (lEConfig != null) {
            LEVector lEVector = new LEVector();
            lEConfig.getCommands(lEVector);
            lEDSSFlatFile.writeSection(string, lEVector);
        }
    }

    void lock() {
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(8, null));
        }
        LEUiUtils.setContainerState(this, false);
        this.m_save.setEnabled(false);
        this.m_cancel.setEnabled(true);
    }

    void unlock() {
        this.m_save.setEnabled(true);
        this.m_cancel.setEnabled(false);
        LEUiUtils.setContainerState(this, true);
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(9, null));
        }
    }

    void save() {
        if (this.m_pms.size() == 0) {
            return;
        }
        String string = this.m_path.getText();
        if (string == null || string.length() < 1) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A file must be specified!");
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
            String string2 = String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?";
            LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, string2, stringArray, (Object)file);
            ((Component)lEConfirmDialog).setVisible(true);
            return;
        }
        this.saveToFile(file);
    }

    void saveToFile(File file) {
        boolean bl = false;
        int n = this.m_pms.size();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.elementAt(n2);
            if (lEPortMaster.supports(0x320000)) {
                bl = true;
            }
            ++n2;
        }
        this.m_secrets = false;
        this.m_passwords = false;
        if (bl) {
            LEBackupDialog lEBackupDialog;
            if (this.areSecretsSelected()) {
                lEBackupDialog = new LEBackupDialog(LEUiUtils.GetBaseFrame(), "secrets");
                this.m_secrets = lEBackupDialog.shouldBackup();
            }
            if (this.arePasswordsSelected()) {
                lEBackupDialog = new LEBackupDialog(LEUiUtils.GetBaseFrame(), "user passwords");
                this.m_passwords = lEBackupDialog.shouldBackup();
            }
        }
        this.m_file = file;
        new Thread(this).start();
    }

    void browse() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Back Up Configuration", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        fileDialog.show();
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            ((TextComponent)this.m_path).setText(string3);
            LEAppInfo.setLastDirectory(string);
        }
    }

    void createMain(Panel panel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Font font = LEFont.getBoldFont();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = s_defInsets;
        Label label = new Label("PortMaster(s):");
        label.setFont(font);
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = this.m_boxes = new Label();
        panel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Back Up:");
        label.setFont(font);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.m_entire = new Checkbox("Entire Configuration", checkboxGroup, true);
        panel2.add(this.m_entire);
        this.m_entire.addItemListener(this);
        this.m_specific = new Checkbox("Specific Sections", checkboxGroup, false);
        panel2.add(this.m_specific);
        this.m_specific.addItemListener(this);
        gridBagConstraints.gridx = 1;
        panel.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.m_switches = new Panel();
        Checkbox[] checkboxArray = this.getSections();
        if (checkboxArray != null) {
            int n = checkboxArray.length / 4;
            if (checkboxArray.length % 4 > 0) {
                ++n;
            }
            this.m_switches.setLayout(new GridLayout(n, 4, 2, 2));
            int n2 = 0;
            while (n2 < checkboxArray.length) {
                this.m_switches.add(checkboxArray[n2]);
                ++n2;
            }
        }
        gridBagConstraints.gridy = 2;
        LEUiUtils.setContainerState(this.m_switches, false);
        panel.add(this.m_switches);
        gridBagLayout.setConstraints(this.m_switches, gridBagConstraints);
        label = new Label("Back Up to File:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        this.m_path = new TextField();
        panel2.add("Center", this.m_path);
        ((Component)this.m_path).setBackground(LEColor.getTextBackground());
        this.m_browse = new Button("Browse...");
        panel2.add("East", this.m_browse);
        this.m_browse.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        panel.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        label = new Label("Comments:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.m_comments = new TextArea();
        ((Component)this.m_comments).setBackground(LEColor.getTextBackground());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        panel.add(this.m_comments);
        gridBagLayout.setConstraints(this.m_comments, gridBagConstraints);
    }

    Checkbox[] getSections() {
        Checkbox[] checkboxArray = null;
        try {
            LEVector lEVector;
            LEDataSpec lEDataSpec = LEDataSpecFactory.GetPortMasterSpec();
            if (lEDataSpec != null && (lEVector = lEDataSpec.getAllSpecs()) != null) {
                int n = lEVector.size();
                checkboxArray = new Checkbox[n];
                this.m_tags = new Hashtable();
                int n2 = 0;
                while (n2 < n) {
                    LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
                    String string = lEDataSpec2.getDescription();
                    if (string == null) {
                        string = lEDataSpec2.getTag();
                    }
                    checkboxArray[n2] = new Checkbox(string);
                    this.m_tags.put(checkboxArray[n2], lEDataSpec2.getTag());
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
        }
        return checkboxArray;
    }

    void setState() {
        if (this.m_specific.getState()) {
            LEUiUtils.setContainerState(this.m_switches, true);
            return;
        }
        LEUiUtils.setContainerState(this.m_switches, false);
    }

    boolean arePasswordsSelected() {
        if (this.m_entire.getState()) {
            return true;
        }
        Component[] componentArray = this.m_switches.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            String string;
            Checkbox checkbox;
            if (componentArray[n] instanceof Checkbox && (checkbox = (Checkbox)componentArray[n]).getState() && (string = (String)this.m_tags.get(checkbox)).equals("1835008")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean areSecretsSelected() {
        if (this.m_entire.getState()) {
            return true;
        }
        Component[] componentArray = this.m_switches.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            String string;
            Checkbox checkbox;
            if (componentArray[n] instanceof Checkbox && (checkbox = (Checkbox)componentArray[n]).getState() && ((string = (String)this.m_tags.get(checkbox)).equals("2228224") || string.equals("1507328"))) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

