/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import oracle.ewt.EwtComponent;
import oracle.ewt.alert.AlertRowLayout;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;

public class BaseAlert
extends BufferedDialog
implements KeyListener,
ContainerListener {
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 1;
    public static final int TYPE_NOTE = 2;
    public static final int TYPE_MISC = 3;
    private Component _defaultComponent;
    private Component _cancelComponent;
    private Component _helpComponent;
    private Component _pressed;
    private Image _icon;
    private ImageCanvas _iconWidget;
    private EwtComponent _messagePanel;
    private Locale _locale;
    private LWComponent _buttonPanel;
    private MultiLineLabel _messageLabel;
    private String _message;
    private int _alertType;
    private boolean _firstTime;
    private Component _centerOver;
    private static final int _BORDER_INSET = 13;
    private static final int _MESSAGE_LEFT_BORDER = 10;
    private static final int _MESSAGE_BOTTOM_BORDER = 13;
    private static final int _MESSAGE_ICON_DELTA = 23;
    private static final int _MINIMUM_LABEL_WIDTH = 45;
    static /* synthetic */ Class class$oracle$ewt$alert$BaseAlert;

    public BaseAlert(Frame frame, int n) {
        this(frame, "", n);
    }

    public BaseAlert(Frame frame, String string, int n) {
        super(frame, true);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Illegal alert type");
        }
        this._alertType = n;
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "images/stop.gif";
                break;
            }
            case 1: {
                string2 = "images/caution.gif";
                break;
            }
            case 2: {
                string2 = "images/note.gif";
                break;
            }
        }
        if (string2 != null) {
            this._icon = ImageUtils.getImageResource(class$oracle$ewt$alert$BaseAlert != null ? class$oracle$ewt$alert$BaseAlert : (class$oracle$ewt$alert$BaseAlert = BaseAlert.class$("oracle.ewt.alert.BaseAlert")), string2);
        }
        this._buttonPanel = new LWComponent();
        this._buttonPanel.setLayout(this.createRowLayout());
        this.add("South", this._buttonPanel);
        this.addKeyListener(this);
        this.addContainerListener(this);
        this._buttonPanel.addContainerListener(this);
        this.setMessage(string);
        this.enableEvents(64L);
    }

    public void dismissAlert(Component component) {
        this._pressed = component;
        ((Component)this).setVisible(false);
    }

    public Component getPressed() {
        return this._pressed;
    }

    public void setMessage(String string) {
        this._message = string;
        if (this._messageLabel != null) {
            this._messageLabel.setText(string);
        }
    }

    public String getMessage() {
        return this._message;
    }

    public void setIcon(Image image) {
        this._icon = image;
        if (this._iconWidget != null) {
            this._iconWidget.setImage(image);
            this._iconWidget.setVisible(this._icon != null);
        }
    }

    public Image getIcon() {
        return this._icon;
    }

    public Component addUserButton(String string, Component component) {
        return this._buttonPanel.add(string, component);
    }

    public final Component addUserButton(Component component) {
        return this.addUserButton(null, component);
    }

    public synchronized void removeComponent(Component component) {
        if (this._defaultComponent == component) {
            this._defaultComponent = null;
        }
        if (this._cancelComponent == component) {
            this._cancelComponent = null;
        }
        if (this._helpComponent == component) {
            this._helpComponent = null;
        }
        this._buttonPanel.remove(component);
    }

    public synchronized void removeAllComponents(Component component) {
        this._defaultComponent = null;
        this._cancelComponent = null;
        this._helpComponent = null;
        this._buttonPanel.removeAll();
    }

    public void setDefaultComponent(Component component) {
        this._defaultComponent = component;
        if (this._defaultComponent != null) {
            this._defaultComponent.requestFocus();
        }
    }

    public Component getDefaultComponent() {
        return this._defaultComponent;
    }

    public void setCancelComponent(Component component) {
        this._cancelComponent = component;
    }

    public Component getCancelComponent() {
        return this._cancelComponent;
    }

    public void setHelpComponent(Component component) {
        this._helpComponent = component;
    }

    public Component getHelpComponent() {
        return this._helpComponent;
    }

    public int getAlertType() {
        return this._alertType;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.getParent();
        if (container != null && (locale = container.getLocale()) != null) {
            return locale;
        }
        return super.getLocale();
    }

    public void setButtonLayoutManager(LayoutManager layoutManager) {
        this._buttonPanel.setLayout(layoutManager);
    }

    public void show() {
        this._pressed = null;
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setBorder(new MarginBorder(0, 10, 13, 0));
        ewtComponent.setLayout(new BorderLayout(23, 0));
        this._iconWidget = new ImageCanvas(this._icon);
        this._iconWidget.setVisible(this._icon != null);
        if (this._icon != null) {
            ImageUtils.loadImage(this._icon);
        }
        ewtComponent.add("West", this._iconWidget);
        this._messageLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.getMessage());
        ewtComponent.add("Center", this._messageLabel);
        this._messagePanel = ewtComponent;
        this.add("Center", ewtComponent);
        this.pack();
        if (this._defaultComponent != null) {
            this._defaultComponent.requestFocus();
        } else if (this._cancelComponent != null) {
            this._cancelComponent.requestFocus();
        } else {
            this._buttonPanel.transferFocus();
        }
        WindowUtils.centerWindow(this, this._centerOver);
        this._firstTime = true;
        super.show();
    }

    public void hide() {
        if (this._messagePanel != null) {
            this.remove(this._messagePanel);
            this._messagePanel = null;
        }
        this._messageLabel = null;
        this._iconWidget = null;
        super.hide();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        Component component = null;
        switch (keyEvent.getKeyCode()) {
            case 27: {
                component = this.getCancelComponent();
                break;
            }
            case 112: 
            case 156: {
                component = this.getHelpComponent();
                break;
            }
        }
        if (component != null) {
            keyEvent.consume();
            this.doComponentKey(component);
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addKeyListener(this);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeKeyListener(this);
    }

    public Insets insets() {
        Insets insets = super.insets();
        Insets insets2 = (Insets)insets.clone();
        insets2.top += 13;
        insets2.left += 13;
        insets2.bottom += 13;
        insets2.right += 13;
        return insets2;
    }

    public Dimension getPreferredSize() {
        MultiLineLabel multiLineLabel = this._messageLabel;
        if (multiLineLabel == null) {
            return super.getPreferredSize();
        }
        int n = 45 * FontUtils.getAverageWidth(this.getFont());
        Dimension dimension = multiLineLabel.getPreferredSize();
        if (dimension.width < n) {
            multiLineLabel.setWrappingLocked(false);
            multiLineLabel.setWrapWidth(n);
        }
        Dimension dimension2 = super.getPreferredSize();
        if (dimension.width < n) {
            multiLineLabel.setWrappingLocked(true);
        }
        return dimension2;
    }

    protected void doComponentKey(Component component) {
    }

    protected LayoutManager createRowLayout() {
        return new AlertRowLayout();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            Component component = this.getDefaultComponent();
            if (component != null) {
                this.doComponentKey(component);
                return;
            }
        } else if (windowEvent.getID() == 205) {
            if (this._alertType == 0 && this._firstTime) {
                Toolkit.getDefaultToolkit().beep();
            }
            this._firstTime = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

