/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.border;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import oracle.ewt.border.Border;
import oracle.ewt.border.BorderManager;
import oracle.ewt.border.DynamicBorder;
import oracle.ewt.graphics.frame.FramePainter;

public class GroupBoxBorder
extends Border
implements DynamicBorder {
    private BorderManager _bordermgr;
    private Font _font;
    private String _label;
    private FramePainter _framePainter;
    private int _thickness;
    private static final int LABEL_INSET = 10;

    public GroupBoxBorder(String string, FramePainter framePainter, int n) {
        this(string, framePainter, n, null);
    }

    public GroupBoxBorder(String string, FramePainter framePainter, int n, Border border) {
        super(border);
        this._label = string;
        this._framePainter = framePainter;
        this._thickness = n;
    }

    public final FramePainter getFramePainter() {
        return this._framePainter;
    }

    public final String getLabel() {
        return this._label;
    }

    public final int getThickness() {
        return this._thickness;
    }

    public final void setFramePainter(FramePainter framePainter) {
        FramePainter framePainter2 = this.getFramePainter();
        if (framePainter != framePainter2) {
            this._framePainter = framePainter;
            if (this._bordermgr != null) {
                int n = this.getThickness();
                Insets insets = framePainter2.thicknessToInsets(n);
                Insets insets2 = framePainter.thicknessToInsets(n);
                if (insets.top != insets2.top || insets.left != insets2.left || insets.bottom != insets2.bottom || insets.right != insets2.right) {
                    this._bordermgr.borderResizeNotify();
                    return;
                }
                this._bordermgr.borderRepaintNotify();
            }
        }
    }

    public final void setLabel(String string) {
        this._label = string;
        if (this._bordermgr != null) {
            this._bordermgr.borderRepaintNotify();
        }
    }

    public final void setThickness(int n) {
        if (n != this.getThickness()) {
            this._thickness = n;
            if (this._bordermgr != null) {
                this._bordermgr.borderResizeNotify();
            }
        }
    }

    public final BorderManager getBorderManager() {
        return this._bordermgr;
    }

    public final void setBorderManager(BorderManager borderManager) {
        this._bordermgr = borderManager;
    }

    protected Insets getBorderInsets() {
        Serializable serializable;
        int n = 0;
        Font font = this.getFont();
        if (font != null && this._bordermgr != null) {
            serializable = this._bordermgr.getFontMetrics(font);
            n = ((FontMetrics)serializable).getMaxAscent() + ((FontMetrics)serializable).getMaxDescent() + ((FontMetrics)serializable).getLeading();
        }
        serializable = this._framePainter.thicknessToInsets(this._thickness);
        if (n > ((Insets)serializable).top) {
            ((Insets)serializable).top = n;
        }
        return serializable;
    }

    protected Font getFont() {
        if (this._bordermgr == null) {
            return null;
        }
        Font font = this._bordermgr.getFont();
        if (font != null && font != this._font) {
            this._font = font;
            this._bordermgr.borderResizeNotify();
        }
        return this._font;
    }

    protected void paintBorder(Graphics graphics, int n, int n2, int n3, int n4, BorderManager borderManager) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n5 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
        Color color = this._framePainter.prefersBackground() ? borderManager.getBorderBackground() : borderManager.getBorderForeground();
        graphics.setColor(color);
        this._framePainter.paint(graphics, n, n2 + n5 / 2, n3, n4 - n5 / 2, this._thickness);
        graphics.setColor(borderManager.getBorderBackground());
        graphics.fillRect(n + 10, n2, fontMetrics.stringWidth(this._label), n5);
        graphics.setFont(font);
        graphics.setColor(borderManager.getBorderForeground());
        graphics.drawString(this._label, n + 10, n2 + fontMetrics.getAscent());
    }
}

