/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class ArrowUtils {
    private static final int _ARROW_WIDTH = 11;
    private static final int _ARROW_HEIGHT = 10;
    private static Image _upArrow;
    private static Image _downArrow;
    private static Image _rightArrow;
    private static Image _leftArrow;

    public static Image getRightArrow() {
        if (_rightArrow == null) {
            _rightArrow = ArrowUtils._createHorizontalArrow(true);
        }
        return _rightArrow;
    }

    public static Image getLeftArrow() {
        if (_leftArrow == null) {
            _leftArrow = ArrowUtils._createHorizontalArrow(false);
        }
        return _leftArrow;
    }

    public static Image getUpArrow() {
        if (_upArrow == null) {
            _upArrow = ArrowUtils._createVerticalArrow(true);
        }
        return _upArrow;
    }

    public static Image getDownArrow() {
        if (_downArrow == null) {
            _downArrow = ArrowUtils._createVerticalArrow(false);
        }
        return _downArrow;
    }

    private static Image _createVerticalArrow(boolean bl) {
        int n;
        int n2;
        byte[] byArray = ArrowUtils._getColorArray();
        byte[] byArray2 = new byte[110];
        ArrowUtils._zeroArray(byArray2);
        if (bl) {
            n2 = 0;
            n = 11;
        } else {
            n2 = 99;
            n = -11;
        }
        byArray2[(n2 += 3 * n) + 5] = 1;
        n2 += n;
        int n3 = 4;
        while (n3 <= 6) {
            byArray2[n2 + n3] = 1;
            ++n3;
        }
        n2 += n;
        n3 = 3;
        while (n3 <= 7) {
            byArray2[n2 + n3] = 1;
            ++n3;
        }
        n2 += n;
        n3 = 2;
        while (n3 <= 8) {
            byArray2[n2 + n3] = 1;
            ++n3;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray, 0, false, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(11, 10, (ColorModel)indexColorModel, byArray2, 0, 11);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    /*
     * Unable to fully structure code
     */
    private static Image _createHorizontalArrow(boolean var0) {
        var1_1 = ArrowUtils._getColorArray();
        var2_2 = new byte[110];
        ArrowUtils._zeroArray(var2_2);
        var4_3 = var0 != false ? 3 : 6;
        var3_4 = 20;
        var5_5 = 0;
        while (var5_5 <= 6) {
            block4: {
                var6_6 = 3 - var5_5;
                if (var6_6 < 0) {
                    var6_6 = -var6_6;
                }
                var6_6 = 4 - var6_6;
                var7_8 = var3_4 + var4_3;
                if (!var0) ** GOTO lbl19
                while (--var6_6 >= 0) {
                    var2_2[var7_8 + var6_6] = 1;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    var2_2[var7_8 - var6_6] = 1;
lbl19:
                    // 2 sources

                    ** while (--var6_6 >= 0)
                }
            }
            var3_4 += 10;
            ++var5_5;
        }
        var6_7 = new IndexColorModel(8, 2, var1_1, 0, false, 0);
        var7_9 = new MemoryImageSource(10, 11, (ColorModel)var6_7, var2_2, 0, 10);
        return Toolkit.getDefaultToolkit().createImage(var7_9);
    }

    private static void _zeroArray(byte[] byArray) {
        int n = byArray.length;
        int n2 = n > 8 ? 8 : n;
        while (n2-- > 0) {
            byArray[n2] = 0;
        }
        if (n <= 8) {
            return;
        }
        n2 = 8;
        while (n2 << 1 <= n) {
            System.arraycopy(byArray, 0, byArray, n2, n2);
            n2 <<= 1;
        }
        System.arraycopy(byArray, 0, byArray, n2, n - n2);
    }

    private static byte[] _getColorArray() {
        byte[] byArray = new byte[6];
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        int n = SystemColor.controlText.getRGB();
        byArray[3] = (byte)((n & 0xFF0000) >> 16);
        byArray[4] = (byte)((n & 0xFF00) >> 8);
        byArray[5] = (byte)(n & 0xFF);
        return byArray;
    }
}

