/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.LightweightPeer;
import oracle.ewt.popup.NoPopupOwnerException;
import oracle.ewt.popup.PopupOwner;

public class PopupUtils {
    private static final int _CENTER = 0;
    private static final int _TO_LEFT = 1;
    private static final int _TO_RIGHT = 2;
    private static final int _LEFT = 3;
    private static final int _RIGHT = 4;
    private static final int _ABOVE_TOP = 1;
    private static final int _BELOW_BOTTOM = 2;
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    public static final int HORIZONTAL_CENTER = 0;
    public static final int TO_LEFT = 5;
    public static final int TO_RIGHT = 10;
    public static final int LEFT = 15;
    public static final int RIGHT = 20;
    public static final int VERTICAL_CENTER = 0;
    public static final int ABOVE_TOP = 1;
    public static final int BELOW_BOTTOM = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;

    public static PopupOwner findPopupOwner(Component component) {
        PopupOwner popupOwner = null;
        while (component != null) {
            if (component instanceof PopupOwner) {
                popupOwner = (PopupOwner)((Object)component);
            }
            if (component instanceof Window) break;
            component = component.getParent();
        }
        return popupOwner;
    }

    public static PopupOwner displayPopupAt(Component component, Component component2, int n, int n2, Dimension dimension) {
        return PopupUtils.displayPopupRelativeTo(component, component2, new Rectangle(n, n2, 0, 0), dimension, 18);
    }

    public static PopupOwner displayPopupRelativeTo(Component component, Component component2, Rectangle rectangle, Dimension dimension, int n) {
        PopupOwner popupOwner = PopupUtils._addPopup(component, component2);
        if (popupOwner != null) {
            if (rectangle == null) {
                rectangle = component.getBounds();
                rectangle.setLocation(0, 0);
            }
            Point point = PopupUtils._translatePoint(component, popupOwner, rectangle.x, rectangle.y);
            rectangle = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            if (dimension == null) {
                dimension = component2.getPreferredSize();
            }
            Dimension dimension2 = component2.getMinimumSize();
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (!PopupUtils._displayPopupRelativeTo(component2, popupOwner, rectangle, dimension, n, dimension2)) {
                popupOwner.removePopup(component2);
                popupOwner = null;
            }
        }
        return popupOwner;
    }

    public static PopupOwner displayPopupRelativeTo(Component component, Component component2, Rectangle rectangle, Dimension dimension, int[] nArray) {
        PopupOwner popupOwner = PopupUtils._addPopup(component, component2);
        if (popupOwner != null) {
            if (rectangle == null) {
                rectangle = component.getBounds();
                rectangle.setLocation(0, 0);
            }
            Point point = PopupUtils._translatePoint(component, popupOwner, rectangle.x, rectangle.y);
            rectangle = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            if (dimension == null) {
                dimension = component2.getPreferredSize();
            }
            int n = 0;
            while (n < nArray.length) {
                if (PopupUtils._displayPopupRelativeTo(component2, popupOwner, rectangle, dimension, nArray[n], dimension)) {
                    return popupOwner;
                }
                ++n;
            }
            Dimension dimension2 = component2.getMinimumSize();
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (!dimension2.equals(dimension)) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (PopupUtils._displayPopupRelativeTo(component2, popupOwner, rectangle, dimension, nArray[n2], dimension2)) {
                        return popupOwner;
                    }
                    ++n2;
                }
            }
            popupOwner.removePopup(component2);
            popupOwner = null;
        }
        return null;
    }

    public static void hidePopup(Component component) {
        Container container = component.getParent();
        if (container instanceof PopupOwner) {
            ((PopupOwner)((Object)container)).removePopup(component);
        }
    }

    private static boolean _displayPopupRelativeTo(Component component, PopupOwner popupOwner, Rectangle rectangle, Dimension dimension, int n, Dimension dimension2) {
        Dimension dimension3 = ((Container)((Object)popupOwner)).getSize();
        Insets insets = ((Container)((Object)popupOwner)).getInsets();
        int[] nArray = PopupUtils._pinValues(n / 5, rectangle.x, dimension.width, rectangle.width, dimension3.width - (insets.left + insets.right), insets.left);
        int n2 = nArray[0];
        int n3 = nArray[1];
        nArray = PopupUtils._pinValues(n % 5, rectangle.y, dimension.height, rectangle.height, dimension3.height - (insets.top + insets.bottom), insets.top);
        int n4 = nArray[0];
        int n5 = nArray[1];
        if (n3 < dimension2.width || n5 < dimension2.height) {
            return false;
        }
        popupOwner.setPopupBounds(component, n2, n4, n3, n5);
        component.validate();
        popupOwner.showPopup(component, n2, n4);
        return true;
    }

    private static int[] _pinValues(int n, int n2, int n3, int n4, int n5, int n6) {
        n2 -= n6;
        switch (n) {
            case 0: {
                int n7 = n2 + n4 / 2;
                n3 = Math.min(n3, 2 * Math.min(n7, n5 - n7));
                n2 = n7 - n3 / 2;
                break;
            }
            case 1: {
                n2 -= n3;
                break;
            }
            case 2: {
                n2 += n4;
                break;
            }
            case 4: {
                n2 += n4 - n3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal justification");
            }
            case 3: 
        }
        if (n2 < 0) {
            n3 += n2;
            n2 = 0;
        }
        if (n2 + n3 > n5) {
            n3 = n5 - n2;
        }
        int[] nArray = new int[]{n2 += n6, n3};
        return nArray;
    }

    private static Point _translatePoint(Component component, PopupOwner popupOwner, int n, int n2) {
        while (component != popupOwner) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    private static PopupOwner _findBottomPopupOwner(Component component) {
        PopupOwner popupOwner = null;
        while (component != null) {
            if (component instanceof PopupOwner) {
                popupOwner = (PopupOwner)((Object)component);
            }
            if (component instanceof Window || !(component.getPeer() instanceof LightweightPeer)) break;
            component = component.getParent();
        }
        return popupOwner;
    }

    private static PopupOwner _addPopup(Component component, Component component2) {
        PopupOwner popupOwner;
        PopupOwner popupOwner2 = PopupUtils.findPopupOwner(component);
        if (popupOwner2 == null) {
            throw new NoPopupOwnerException();
        }
        popupOwner2.addPopup(component2);
        if (component2.getPeer() instanceof LightweightPeer && popupOwner2 != (popupOwner = PopupUtils._findBottomPopupOwner(component))) {
            popupOwner2.removePopup(component2);
            popupOwner.addPopup(component2);
            return popupOwner;
        }
        return popupOwner2;
    }

    private PopupUtils() {
    }
}

