/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling.scrollBox;

import java.awt.event.AdjustmentEvent;
import oracle.ewt.lwAWT.LWScrollbar;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

class EwtLWScrollbar
extends LWScrollbar {
    Scrollable _scrollee;
    boolean _alwaysdisplay;

    public EwtLWScrollbar() {
        this(1);
    }

    public EwtLWScrollbar(int n) {
        this(n, true);
    }

    public EwtLWScrollbar(int n, boolean bl) {
        super(n);
        this._alwaysdisplay = bl;
        if (bl && !this.isVisible()) {
            this.setVisible(true);
        }
        this.enableEvents(256L);
    }

    public Scrollable getScrollee() {
        return this._scrollee;
    }

    public boolean isDisplayedAlways() {
        return this._alwaysdisplay;
    }

    public void setDisplayedAlways(boolean bl) {
        this._alwaysdisplay = bl;
    }

    public void setScrollee(Scrollable scrollable) throws ScrollableException {
        if (this._scrollee != null && this._scrollee != scrollable) {
            this._scrollee.detachAdjustable(this);
        }
        this._scrollee = scrollable;
        if (scrollable != null) {
            if (this.getOrientation() == 0) {
                scrollable.attachHAdjustable(this);
                return;
            }
            scrollable.attachVAdjustable(this);
        }
    }

    public void setValues(int n, int n2, int n3, int n4) {
        super.setValues(n, n2, n3, n4);
        if (!this._alwaysdisplay && n4 - n3 - n2 > 0 != this.isVisible()) {
            new Updater().scheduleSelf();
        }
    }

    public void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        super.processAdjustmentEvent(adjustmentEvent);
        if (this._scrollee != null) {
            int n = adjustmentEvent.getValue();
            int n2 = this._getAction(adjustmentEvent.getAdjustmentType());
            if (this.getOrientation() == 0) {
                this._scrollee.handleHScroll(n, n2);
                return;
            }
            this._scrollee.handleVScroll(n, n2);
        }
    }

    void _hideOrShowSelf() {
        if (!this._alwaysdisplay) {
            this.setVisible(this.getMaximum() - this.getMinimum() - this.getVisibleAmount() > 0);
        }
    }

    private int _getAction(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        return n2;
    }

    private class Updater
    implements Task {
        public void scheduleSelf() {
            TaskScheduler.getDefaultTaskScheduler().schedule(this, 0);
        }

        public void runTask(TaskEvent taskEvent) {
            EwtLWScrollbar.this._hideOrShowSelf();
        }

        Updater() {
            EwtLWScrollbar.this = EwtLWScrollbar.this;
        }
    }
}

