/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import oracle.help.Book;
import oracle.help.Help;
import oracle.help.HelpBook;

public class HelpManager {
    Help _help;
    Book _defaultBook;
    Hashtable _idTable;
    KeyListener _F1Listener;
    MouseListener _popupHandler;

    public HelpManager(Help help) {
        this._help = help;
        this._F1Listener = new _keyListener();
        this._popupHandler = new _mouseListener();
        this._idTable = new Hashtable(10);
    }

    public void setDefaultBook(Book book) {
        this._defaultBook = book;
    }

    public void addBook(Book book, boolean bl) {
        Help help = this._help;
        help._context.addBook((HelpBook)book, -1, true);
        if (bl) {
            this._defaultBook = book;
        }
    }

    public void removeBook(Book book) {
        this._help.removeBook(book);
    }

    public void setBookVisible(Book book, boolean bl) {
        this._help.setBookVisible(book, bl);
    }

    public void addComponent(Component component, String string) {
        if (this._defaultBook == null) {
            return;
        }
        this.addComponent(component, this._defaultBook, string);
    }

    public void addComponent(Component component, Book book, String string) {
        this.addComponent(component, book, string, false, false);
    }

    public void addComponent(Component component, String string, boolean bl, boolean bl2) {
        if (this._defaultBook == null) {
            return;
        }
        this.addComponent(component, this._defaultBook, string, bl, bl2);
    }

    public void addComponent(Component component, Book book, String string, boolean bl, boolean bl2) {
        TopicInfo topicInfo;
        if (bl) {
            component.addKeyListener(this._F1Listener);
        }
        if (bl2) {
            component.addMouseListener(this._popupHandler);
        }
        if ((topicInfo = (TopicInfo)this._idTable.get(component)) != null) {
            this._idTable.remove(component);
        }
        this._idTable.put(component, new TopicInfo(book, string));
    }

    public void showHelpForComponent(Component component) {
        TopicInfo topicInfo = (TopicInfo)this._idTable.get(component);
        if (topicInfo != null) {
            this._help.showTopic(topicInfo.book, topicInfo.topicId);
        }
    }

    public void showTopic(String string) {
        this._help.showTopic(this._defaultBook, string);
    }

    public void showContents() {
        this._help.showContents();
    }

    public void showIndex() {
        this._help.showIndex();
    }

    public void showSearch() {
        this._help.showSearch();
    }

    protected Help getHelpObject() {
        return this._help;
    }

    private class _keyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 112) {
                HelpManager.this.showHelpForComponent((Component)keyEvent.getSource());
            }
        }

        _keyListener() {
            HelpManager.this = HelpManager.this;
        }
    }

    private class _mouseListener
    extends MouseAdapter
    implements ActionListener {
        private PopupMenu _popup = new PopupMenu();
        private Component _component;

        public _mouseListener() {
            HelpManager.this = HelpManager.this;
            MenuItem menuItem = new MenuItem("Help");
            menuItem.addActionListener(this);
            this._popup.add(menuItem);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                this._component = (Component)mouseEvent.getSource();
                if (((MenuComponent)this._popup).getParent() != null) {
                    ((MenuComponent)this._popup).getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpManager.this.showHelpForComponent(this._component);
            ((MenuComponent)this._popup).getParent().remove(this._popup);
        }
    }

    private class TopicInfo {
        public Book book;
        public String topicId;

        public TopicInfo(Book book, String string) {
            HelpManager.this = HelpManager.this;
            this.book = book;
            this.topicId = string;
        }
    }
}

