/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.util.Date;
import sunw.hotjava.misc.HttpCookie;

public class Cookie {
    public int version = 0;
    public String attribute;
    public String value;
    public String domain;
    public String path;
    public String comment;
    public Date expires;
    public boolean isSecure;

    public Cookie(HttpCookie httpCookie) {
        this.attribute = httpCookie.getName();
        String string = httpCookie.getNameValue();
        int n = string.indexOf("=");
        this.value = string.substring(n);
        this.domain = httpCookie.getDomain();
        this.path = httpCookie.getPath();
        this.expires = httpCookie.getExpirationDate();
        this.isSecure = httpCookie.isSecure();
    }

    public String toString() {
        String string;
        if (this.version == 0) {
            string = String.valueOf(this.attribute) + "=" + this.value;
            if (this.expires != null) {
                string = String.valueOf(string) + "; expires=" + this.expires;
            }
            if (this.path != null) {
                string = String.valueOf(string) + "; path=" + this.path;
            }
            if (this.domain != null) {
                string = String.valueOf(string) + "; domain=" + this.domain;
            }
            if (this.isSecure) {
                string = String.valueOf(string) + "; secure";
            }
        } else {
            string = "$Version=" + this.version + ";";
            string = String.valueOf(string) + this.attribute + "=" + this.value;
            if (this.expires != null) {
                string = String.valueOf(string) + "; $Expires=" + this.expires;
            }
            if (this.path != null) {
                string = String.valueOf(string) + "; $Path=" + this.path;
            }
            if (this.domain != null) {
                string = String.valueOf(string) + "; $Domain=" + this.domain;
            }
            if (this.isSecure) {
                string = String.valueOf(string) + "; $Secure";
            }
        }
        return string;
    }

    public static Cookie parseFromString(String string) {
        return new Cookie(new HttpCookie(string));
    }
}

