/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.forms;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TextItem;
import sunw.hotjava.forms.FORM;
import sunw.hotjava.forms.FormChoice;
import sunw.hotjava.forms.FormTextField;
import sunw.hotjava.forms.ImageCanvas;
import sunw.hotjava.forms.OPTION;
import sunw.hotjava.forms.SubmitThread;
import sunw.hotjava.misc.Globals;
import sunw.html.Attributes;

public class FormPanel
extends Panel
implements DocPanel {
    static final int TEXT = 1;
    static final int PASSWORD = 2;
    static final int CHECKBOX = 3;
    static final int RADIO = 4;
    static final int SUBMIT = 5;
    static final int RESET = 6;
    static final int IMAGE = 7;
    static final int HIDDEN = 8;
    static final int TEXTAREA = 9;
    static final int CHOICE = 10;
    static final int LIST = 11;
    Formatter win;
    Document doc;
    TagItem item;
    Component comp;
    String maxOptionString = "";
    int type;
    int sizeAttribute = 1;
    String imageSubmitClickLoc;
    static final boolean debug = false;

    void dbg(String string) {
    }

    public boolean isHidden() {
        return this.type == 8;
    }

    public FORM getFormItem() {
        return (FORM)this.item.getFormParent();
    }

    String getData(DocItem docItem) {
        String string = "";
        int n = docItem.getIndex();
        int n2 = n + docItem.getOffset();
        while (n++ < n2) {
            docItem = this.doc.getItem(n);
            if (!docItem.isText()) continue;
            string = String.valueOf(string) + ((TextItem)docItem).getText();
        }
        return string;
    }

    Vector getOptions() {
        Vector<DocItem> vector = new Vector<DocItem>();
        int n = this.item.getIndex();
        int n2 = n + this.item.getOffset();
        while (n++ < n2) {
            DocItem docItem = this.doc.getItem(n);
            if (!(docItem instanceof OPTION)) continue;
            vector.addElement(docItem);
            n += docItem.getOffset();
        }
        return vector;
    }

    Vector getOptionList() {
        Vector<String> vector = new Vector<String>();
        int n = this.item.getIndex();
        int n2 = n + this.item.getOffset();
        while (n++ < n2) {
            DocItem docItem = this.doc.getItem(n);
            if (!(docItem instanceof OPTION)) continue;
            vector.addElement(this.getData(docItem).trim());
            n += docItem.getOffset();
        }
        return vector;
    }

    Vector getOptionValueList() {
        Vector<String> vector = new Vector<String>();
        int n = this.item.getIndex();
        int n2 = n + this.item.getOffset();
        while (n++ < n2) {
            DocItem docItem = this.doc.getItem(n);
            if (!(docItem instanceof OPTION)) continue;
            OPTION oPTION = (OPTION)docItem;
            String string = null;
            Attributes attributes = oPTION.getAttributes();
            string = attributes == null || attributes.get("value") == null ? this.getData(docItem).trim() : attributes.get("value");
            vector.addElement(string == null ? "" : string);
            n += docItem.getOffset();
        }
        return vector;
    }

    String getStringAttribute(String string, String string2) {
        Attributes attributes = this.item.getAttributes();
        if (attributes != null) {
            String string3 = attributes.get(string);
            if (string3 != null) {
                return string3;
            }
            return string2;
        }
        return string2;
    }

    int getIntAttribute(String string, int n) {
        String string2 = this.getStringAttribute(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n;
    }

    int getAscent() {
        switch (this.type) {
            case 1: 
            case 2: {
                return 19;
            }
        }
        return 10;
    }

    void ampersand(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('&');
        }
    }

    void value(StringBuffer stringBuffer) {
        String string = this.getStringAttribute("name", null);
        if (string != null) {
            string = URLEncoder.encode(string);
        }
        String string2 = null;
        switch (this.type) {
            case 1: 
            case 2: {
                string2 = ((TextField)this.comp).getText();
                break;
            }
            case 3: 
            case 4: {
                if (!((Checkbox)this.comp).getState()) {
                    return;
                }
                string2 = this.getStringAttribute("value", "on");
                break;
            }
            case 5: 
            case 8: {
                string2 = this.getStringAttribute("value", "");
                break;
            }
            case 9: {
                string2 = this.canonicalizeNewlines(((TextArea)this.comp).getText());
                break;
            }
            case 10: {
                int n = ((Choice)this.comp).getSelectedIndex();
                Vector vector = this.getOptionValueList();
                if (vector.size() <= 0) break;
                this.ampersand(stringBuffer);
                stringBuffer.append(string);
                stringBuffer.append("=");
                String string3 = URLEncoder.encode((String)vector.elementAt(n));
                stringBuffer.append(string3);
                break;
            }
            case 11: {
                int[] nArray = ((List)this.comp).getSelectedIndexes();
                Vector vector = this.getOptionValueList();
                if (vector.size() <= 0 || nArray.length <= 0) break;
                this.ampersand(stringBuffer);
                stringBuffer.append(string);
                stringBuffer.append('=');
                String string4 = URLEncoder.encode((String)vector.elementAt(nArray[0]));
                stringBuffer.append(string4);
                int n = 1;
                while (n < nArray.length) {
                    stringBuffer.append('&');
                    stringBuffer.append(string);
                    stringBuffer.append('=');
                    string4 = URLEncoder.encode((String)vector.elementAt(nArray[n]));
                    stringBuffer.append(string4);
                    ++n;
                }
                break;
            }
            case 7: {
                if (this.imageSubmitClickLoc == null) break;
                if (stringBuffer.length() != 0) {
                    this.ampersand(stringBuffer);
                }
                stringBuffer.append(this.imageSubmitClickLoc);
                this.imageSubmitClickLoc = null;
                break;
            }
        }
        if (string != null && string2 != null) {
            this.ampersand(stringBuffer);
            stringBuffer.append(string);
            stringBuffer.append('=');
            String string5 = URLEncoder.encode(string2);
            stringBuffer.append(string5);
        }
    }

    String canonicalizeNewlines(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\n' && stringBuffer.charAt(n - 1) != '\r') {
                stringBuffer.insert(n, '\r');
                ++n;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void reset() {
        switch (this.type) {
            case 1: {
                ((TextComponent)((TextField)this.comp)).setText(this.getStringAttribute("value", ""));
                return;
            }
            case 2: {
                ((TextComponent)((TextField)this.comp)).setText(this.getStringAttribute("value", ""));
                return;
            }
            case 3: {
                ((Checkbox)this.comp).setState(this.getStringAttribute("checked", null) != null);
                return;
            }
            case 4: {
                ((Checkbox)this.comp).setState(this.getStringAttribute("checked", null) != null);
                return;
            }
            case 9: {
                ((TextArea)this.comp).setText(this.getData(this.item));
                return;
            }
            case 10: {
                Choice choice = (Choice)this.comp;
                int n = 0;
                Enumeration enumeration = this.getOptions().elements();
                while (enumeration.hasMoreElements()) {
                    OPTION oPTION = (OPTION)enumeration.nextElement();
                    if (oPTION.selected()) {
                        choice.select(n);
                        return;
                    }
                    ++n;
                }
                return;
            }
            case 11: {
                List list = (List)this.comp;
                int n = 0;
                Enumeration enumeration = this.getOptions().elements();
                while (enumeration.hasMoreElements()) {
                    OPTION oPTION = (OPTION)enumeration.nextElement();
                    if (oPTION.selected()) {
                        list.deselect(n);
                        list.select(n);
                    } else if (list.isIndexSelected(n)) {
                        list.deselect(n);
                    }
                    ++n;
                }
                return;
            }
        }
    }

    FormPanel(Formatter formatter, Document document, TagItem tagItem, String string) {
        Object object;
        this.win = formatter;
        this.doc = document;
        this.item = tagItem;
        if (string == null) {
            string = this.getStringAttribute("type", "text").toLowerCase();
        }
        if (string.equals("text")) {
            this.type = 1;
            this.sizeAttribute = this.getIntAttribute("size", 20);
            this.comp = new FormTextField(this.getIntAttribute("maxlength", Integer.MAX_VALUE));
            ((TextField)this.comp).addActionListener(new UserActionListener());
        } else if (string.equals("password")) {
            this.type = 2;
            this.sizeAttribute = this.getIntAttribute("size", 20);
            this.comp = new FormTextField(this.getIntAttribute("maxlength", Integer.MAX_VALUE));
            ((TextField)this.comp).setEchoCharacter('#');
        } else if (string.equals("checkbox")) {
            this.type = 3;
            this.comp = new Checkbox();
        } else if (string.equals("radio")) {
            this.type = 4;
            this.comp = new Checkbox();
            object = null;
            Attributes attributes = tagItem.getAttributes();
            String string2 = attributes.get("name");
            if (string2 == null) {
                string2 = attributes.get("NAME");
            }
            FORM fORM = (FORM)tagItem.getFormParent();
            Enumeration enumeration = fORM.getFormElements();
            while (enumeration.hasMoreElements()) {
                TagItem tagItem2 = (TagItem)enumeration.nextElement();
                FormPanel formPanel = this.getFormPanelFrom(tagItem2);
                if (formPanel == null) continue;
                Attributes attributes2 = formPanel.item.getAttributes();
                String string3 = attributes2.get("name");
                if (string3 == null) {
                    string3 = attributes2.get("NAME");
                }
                if (formPanel.type != 4 || string3 == null || !string3.equalsIgnoreCase(string2)) continue;
                object = ((Checkbox)formPanel.comp).getCheckboxGroup();
                break;
            }
            ((Checkbox)this.comp).setCheckboxGroup((CheckboxGroup)(object == null ? new CheckboxGroup() : object));
        } else if (string.equals("submit")) {
            this.type = 5;
            this.comp = new Button(this.getStringAttribute("value", "submit"));
            ((Button)this.comp).addActionListener(new UserActionListener());
        } else if (string.equals("reset")) {
            this.type = 6;
            this.comp = new Button(this.getStringAttribute("value", "reset"));
            ((Button)this.comp).addActionListener(new UserActionListener());
        } else if (string.equals("image")) {
            this.type = 7;
            object = null;
            String string4 = this.getStringAttribute("border", "");
            try {
                URL uRL = new URL(document.getBaseURL(), this.getStringAttribute("src", ""));
                object = Globals.getImage(uRL);
            }
            catch (MalformedURLException malformedURLException) {}
            this.comp = new ImageCanvas((Image)object, string4);
            ((ImageCanvas)this.comp).addActionListener(new UserActionListener());
        } else if (string.equals("hidden")) {
            this.type = 8;
        } else if (string.equals("select")) {
            if (this.getStringAttribute("multiple", null) != null || this.getIntAttribute("size", 1) > 1) {
                this.type = 11;
                this.sizeAttribute = this.getListSizeAttribute(document, tagItem);
                this.comp = new List(this.getIntAttribute("size", 1), false);
                if (this.getStringAttribute("multiple", null) != null) {
                    ((List)this.comp).setMultipleSelections(true);
                }
                object = this.getOptionList().elements();
                while (object.hasMoreElements()) {
                    String string5 = (String)object.nextElement();
                    if (string5.length() > this.maxOptionString.length()) {
                        this.maxOptionString = string5;
                    }
                    ((List)this.comp).addItem(string5);
                }
            } else {
                this.type = 10;
                this.comp = System.getProperty("os.name").indexOf("Windows") >= 0 ? new Choice() : new FormChoice();
                object = this.getOptionList().elements();
                while (object.hasMoreElements()) {
                    ((Choice)this.comp).addItem((String)object.nextElement());
                }
                this.comp.setBackground(Color.white);
                this.comp.setForeground(Color.black);
            }
        } else if (string.equals("textarea")) {
            this.type = 9;
            this.comp = new TextArea();
        }
        if (this.comp != null) {
            this.add(this.comp);
        }
        this.setVisible(false);
        this.reset();
        object = formatter.getDocumentState();
        this.setBackground(((DocumentState)object).background);
    }

    protected FormPanel getFormPanelFrom(DocItem docItem) {
        Formatter formatter;
        Formatter formatter2 = this.win;
        Vector vector = new Vector();
        while ((formatter = formatter2.getParentFormatter()) != null) {
            formatter2 = formatter;
        }
        this.getFormPanelDeepSearch(docItem, formatter2, vector);
        if (vector.size() == 0) {
            return null;
        }
        return (FormPanel)vector.elementAt(0);
    }

    private void getFormPanelDeepSearch(DocItem docItem, Formatter formatter, Vector vector) {
        docItem.getFormPanel(formatter, vector);
        if (vector.size() > 0) {
            return;
        }
        Vector vector2 = formatter.getChildFormatters();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                Formatter formatter2 = (Formatter)vector2.elementAt(n);
                this.getFormPanelDeepSearch(docItem, formatter2, vector);
                if (vector.size() > 0) {
                    return;
                }
                ++n;
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.comp == null) {
            return new Dimension(0, 0);
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return ((TextField)this.comp).getPreferredSize(this.sizeAttribute);
            }
            case 9: {
                return ((TextArea)this.comp).getPreferredSize(this.getIntAttribute("rows", 20), this.getIntAttribute("cols", 60));
            }
            case 11: {
                Dimension dimension = ((List)this.comp).getPreferredSize(this.sizeAttribute);
                Font font = this.comp.getFont();
                if (font == null) {
                    return dimension;
                }
                FontMetrics fontMetrics = this.comp.getFontMetrics(font);
                int n = fontMetrics.stringWidth(this.maxOptionString);
                dimension.width = n += 30;
                return dimension;
            }
            case 8: {
                return new Dimension(0, 0);
            }
        }
        return this.comp.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getPreferredSize();
    }

    public void layout() {
        if (this.comp != null) {
            Dimension dimension = this.getSize();
            this.comp.setSize(dimension.width, dimension.height);
        }
    }

    public void activateSubItems() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void interruptLoading() {
    }

    public void notify(Document document, int n, int n2, int n3) {
    }

    public void reformat() {
    }

    public int findYFor(int n) {
        return 0;
    }

    void imageSubmit(String string, ActionEvent actionEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = actionEvent.getActionCommand();
        int n = string2.indexOf(58);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(++n);
        if (string == null || string.equals("")) {
            this.imageSubmitClickLoc = "x=" + string3 + "&y=" + string4;
        } else {
            string = URLEncoder.encode(string);
            this.imageSubmitClickLoc = String.valueOf(string) + ".x" + "=" + string3 + "&" + string + ".y" + "=" + string4;
        }
        this.submit(stringBuffer, actionEvent);
    }

    void submit(ActionEvent actionEvent) {
        this.submit(new StringBuffer(), actionEvent);
    }

    void submit(StringBuffer stringBuffer, ActionEvent actionEvent) {
        Object object;
        FORM fORM = (FORM)this.item.getFormParent();
        if (fORM == null) {
            return;
        }
        int n = 0;
        Enumeration enumeration = fORM.getFormElements();
        while (enumeration.hasMoreElements()) {
            ++n;
            TagItem tagItem = (TagItem)enumeration.nextElement();
            object = this.getFormPanelFrom(tagItem);
            if (object != null && ((FormPanel)object).type == 5 && object != this || ((FormPanel)object).type == 7) continue;
            ((FormPanel)object).value(stringBuffer);
        }
        if (this.type == 7) {
            this.value(stringBuffer);
        }
        boolean bl = (actionEvent.getModifiers() & 1) != 0;
        object = new SubmitThread(this, stringBuffer.toString(), bl);
        ((Thread)object).start();
    }

    public void processUserAction(ActionEvent actionEvent) {
        FORM fORM = null;
        switch (this.type) {
            case 6: {
                fORM = (FORM)this.item.getFormParent();
                Enumeration enumeration = fORM.getFormElements();
                while (enumeration.hasMoreElements()) {
                    TagItem tagItem = (TagItem)enumeration.nextElement();
                    FormPanel formPanel = this.getFormPanelFrom(tagItem);
                    formPanel.reset();
                }
                return;
            }
            case 7: {
                this.imageSubmit(this.getStringAttribute("name", null), actionEvent);
                return;
            }
            case 1: {
                boolean bl = false;
                boolean bl2 = false;
                fORM = (FORM)this.item.getFormParent();
                Enumeration enumeration = fORM.getFormElements();
                while (enumeration.hasMoreElements()) {
                    TagItem tagItem = (TagItem)enumeration.nextElement();
                    FormPanel formPanel = this.getFormPanelFrom(tagItem);
                    int n = formPanel.getComponentCount();
                    int n2 = 0;
                    while (n2 < n) {
                        Component component = formPanel.getComponent(n2);
                        if (!bl2) {
                            if (actionEvent.getSource() == component) {
                                bl2 = true;
                            }
                        } else if (component instanceof FormTextField) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) break;
                }
                if (bl) {
                    this.transferFocus();
                    return;
                }
                this.submit(actionEvent);
                return;
            }
            case 5: {
                this.submit(actionEvent);
                return;
            }
        }
    }

    protected MasterDocumentPanel getContainingMasterDocumentPanel() {
        return MasterDocumentPanel.getContainingMasterDocumentPanel(this);
    }

    private int getListSizeAttribute(Document document, TagItem tagItem) {
        int n = this.getIntAttribute("size", -1);
        if (n <= 0) {
            n = 0;
            int n2 = tagItem.getIndex() + tagItem.getOffset();
            int n3 = tagItem.getIndex();
            while (n3 < n2) {
                if (document.items[n3] instanceof OPTION) {
                    ++n;
                }
                ++n3;
            }
        }
        if (n > 20) {
            n = 20;
        } else if (n < 1) {
            n = 1;
        }
        return n;
    }

    class UserActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FormPanel.this.processUserAction(actionEvent);
        }

        UserActionListener() {
            FormPanel.this = FormPanel.this;
        }
    }
}

