/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.forms.LEHostsForm;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEHost;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEClipboard;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEHostsView
implements LEModelView,
ActionListener,
LEMLListener,
LEObserver {
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_REFRESH = "refresh";
    LEViewListener m_listener;
    LEHostsForm m_form = new LEHostsForm();
    LEScrollPanel m_panel;
    Panel m_buttons;
    Button m_edit;
    Button m_delete;

    public LEHostsView() {
        LEClipboard.GetClipboard().addObserver(this);
    }

    public void setContext(LEVector lEVector) {
        this.m_form.setContext(lEVector);
        this.m_form.addListener(this);
        this.m_panel = new LEScrollPanel(this.m_form);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 10, 10));
        panel.setLayout(new GridLayout(1, 4, 10, 10));
        Button button = new Button("Add...");
        panel.add(button);
        button.setActionCommand(ACTION_ADD);
        button.addActionListener(this);
        this.m_delete = new Button("Delete");
        panel.add(this.m_delete);
        this.m_delete.setActionCommand(ACTION_DELETE);
        this.m_delete.addActionListener(this);
        this.m_delete.setEnabled(false);
        button = new Button("Refresh");
        panel.add(button);
        button.setActionCommand(ACTION_REFRESH);
        button.addActionListener(this);
        this.m_buttons.add(panel);
        this.checkClipboard();
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 3) {
            this.setState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_ADD)) {
            this.m_form.add();
            return;
        }
        if (string.equals(ACTION_DELETE)) {
            this.m_form.delete();
            return;
        }
        if (string.equals(ACTION_REFRESH)) {
            this.m_form.refresh();
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n == LEClipboard.CUT) {
                this.cut();
                return;
            }
            if (n == LEClipboard.COPY) {
                this.copy();
                return;
            }
            if (n == LEClipboard.PASTE) {
                this.paste();
                return;
            }
            if (n == LEClipboard.DELETE) {
                this.delete();
                return;
            }
            if (n == LEClipboard.CONTENT) {
                this.checkClipboard();
            }
        }
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_form.setPortMasters(lEPortMasterArray);
    }

    public Component getMainPanel() {
        return this.m_panel;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void going() {
        this.m_form.deleteListener(this);
        LEClipboard.GetClipboard().deleteObserver(this);
    }

    public void gone() {
        this.m_form.gone();
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    void setState() {
        int[] nArray = this.m_form.getSelectedRows();
        if (nArray.length > 0) {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(true);
            }
        } else if (this.m_delete != null) {
            this.m_delete.setEnabled(false);
        }
        this.checkClipboard();
    }

    void cut() {
        this.copy();
        this.delete();
    }

    void copy() {
        int[] nArray = this.m_form.getSelectedRows();
        if (nArray.length > 1) {
            LEVector lEVector = new LEVector();
            int n = 0;
            while (n < nArray.length) {
                Object object = this.m_form.getEntry(nArray[n]);
                if (object instanceof LEConfig) {
                    object = ((LEConfig)object).clone();
                }
                lEVector.addElement(object);
                ++n;
            }
            LEClipboard.GetClipboard().setContents(lEVector);
            return;
        }
        if (nArray.length == 1) {
            Object object = this.m_form.getEntry(nArray[0]);
            if (object instanceof LEConfig) {
                object = ((LEConfig)object).clone();
            }
            LEClipboard.GetClipboard().setContents(object);
        }
    }

    void paste() {
        Object object = LEClipboard.GetClipboard().getContents();
        if (object != null) {
            this.m_form.paste(object);
        }
    }

    void delete() {
        this.m_form.delete();
    }

    void checkClipboard() {
        int[] nArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        LEClipboard lEClipboard = LEClipboard.GetClipboard();
        Object object = lEClipboard.getContents();
        if (this.pasteable(object)) {
            bl3 = true;
        }
        if ((nArray = this.m_form.getSelectedRows()).length > 0) {
            bl2 = true;
            if (this.m_delete != null) {
                bl = true;
                bl4 = true;
            }
        }
        lEClipboard.setState(bl, bl2, bl3, bl4);
    }

    boolean pasteable(Object object) {
        LEVector lEVector;
        if (object instanceof LEVector && (lEVector = (LEVector)object).size() > 0) {
            object = lEVector.elementAt(0);
        }
        return object instanceof LEHost;
    }
}

