/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEAlarmFactory;
import com.lucent.ra.nms.backend.LEAlarmMessage;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEVector;
import java.util.Hashtable;

public class LEMonAlarmsView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Hashtable m_alarms = new Hashtable();

    public LEMonAlarmsView() {
        this.m_buttons.remove(this.m_reset);
        this.m_buttons.remove(this.m_restore);
        this.initialize(1, 1, 5);
        this.setCellJustification(2, 2);
        this.setCellJustification(3, 2);
        this.setCellJustification(4, 2);
        this.m_resetCols = new int[1];
        this.m_resetCols[0] = 4;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEAlarmMessage) {
            this.updateAlarm(string, (LEAlarmMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void updateAlarm(String string, LEAlarmMessage lEAlarmMessage) {
        String string2 = lEAlarmMessage.getName();
        Integer n = this.getRow(string, string2);
        if (n == null) {
            this.createRow(string, string2, lEAlarmMessage);
            return;
        }
        this.updateRow(string, n, lEAlarmMessage);
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Message");
        objectArray[n2++] = new String("Severity");
        objectArray[n2++] = new String("Time");
        objectArray[n2++] = new String("Count");
        objectArray[n2++] = new String("State");
    }

    void createRow(String string, String string2, LEAlarmMessage lEAlarmMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        LEPortMaster lEPortMaster = this.getPM(string);
        objectArray[n++] = lEPortMaster.getDescription();
        objectArray[n++] = lEAlarmMessage.getMessage();
        objectArray[n++] = lEAlarmMessage.getSeverity();
        lEAlarmMessage.checkForTicks(lEPortMaster.getSoftwareVersion());
        objectArray[n++] = lEAlarmMessage.getFormatedTime();
        objectArray[n++] = new Long(lEAlarmMessage.getCount());
        String string3 = lEAlarmMessage.getState();
        if (string3 == null) {
            string3 = "";
        }
        objectArray[n++] = string3;
        this.addRow(string, string2, objectArray);
    }

    void updateRow(String string, int n, LEAlarmMessage lEAlarmMessage) {
        int n2 = 0;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEAlarmMessage.getMessage());
        int n4 = ++n2;
        this.setCellItem(n, n4, lEAlarmMessage.getSeverity());
        lEAlarmMessage.checkForTicks(this.getPM(string).getSoftwareVersion());
        int n5 = ++n2;
        ++n2;
        this.setCellItem(n, n5, lEAlarmMessage.getFormatedTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEAlarmMessage.getCount()));
        ++n2;
        String string2 = lEAlarmMessage.getState();
        if (string2 != null) {
            this.setCellItem(n, n2++, string2);
        }
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonAlarmsView.s_monitors[0] = 655360;
        }
        return s_monitors;
    }

    void startMonitoringNow(LEPortMaster lEPortMaster, String string) {
        if (!lEPortMaster.isConnected()) {
            return;
        }
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        String string2 = lEPortMaster.getResourceID();
        LEVector lEVector = lEPMConnectionFacade.getAlarms();
        int n = lEVector == null ? 0 : lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            this.updateAlarm(string2, (LEAlarmMessage)lEVector.elementAt(n2));
            ++n2;
        }
        LEAlarmFactory.GetFactory().addObserver(string2, this);
    }

    void stopMonitoringNow(LEPortMaster lEPortMaster, String string) {
        String string2 = lEPortMaster.getResourceID();
        LEAlarmFactory.GetFactory().deleteObserver(string2, this);
        this.remove(string2);
    }

    String getMonitorName() {
        return "Monitor Alarms";
    }
}

