/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.forms.LEOrderedListForm;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewEvent;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEOrderedListView
implements LEModelView,
ActionListener,
Runnable {
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_REFRESH = "refresh";
    LEViewListener m_listener;
    LEOrderedListForm m_form;
    Panel m_buttons = new Panel();
    String m_action;

    public LEOrderedListView() {
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        Button button = new Button("Save...");
        button.setActionCommand(ACTION_SAVE);
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Refresh");
        button.setActionCommand(ACTION_REFRESH);
        button.addActionListener(this);
        panel.add(button);
        this.m_buttons.add(panel);
    }

    public void setContext(LEVector lEVector) {
        this.m_form = new LEOrderedListForm();
        this.m_form.setContext(lEVector);
    }

    public void save() {
        this.m_form.save();
    }

    public void refresh() {
        this.m_form.refresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dispatch(actionEvent.getActionCommand());
    }

    public void handleAction(String string) {
        if (string.equals(ACTION_SAVE)) {
            this.save();
            return;
        }
        if (string.equals(ACTION_REFRESH)) {
            this.refresh();
        }
    }

    public void lock() {
        this.m_form.setEnabled(false);
        this.m_buttons.setEnabled(false);
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(8, null));
        }
    }

    public void unlock() {
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(9, null));
        }
        this.m_form.setEnabled(true);
        this.m_buttons.setEnabled(true);
    }

    public void dispatch(String string) {
        this.lock();
        this.m_action = string;
        new Thread((Runnable)this, "LEOrderedListView.dispatch").start();
    }

    public void run() {
        this.handleAction(this.m_action);
        this.m_action = null;
        this.unlock();
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_form.setPortMasters(lEPortMasterArray);
    }

    public Component getMainPanel() {
        return this.m_form;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void going() {
        LEHelpManager.SetHelp("");
    }

    public void gone() {
        this.m_form.gone();
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }
}

