/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.amf;

import com.lucent.ra.nms.amf.LEAMManager_R;
import com.lucent.ra.nms.amf.LEAMRouter_R;
import com.lucent.ra.nms.amf.LEAsyncMessage;
import com.lucent.ra.nms.amf.LECCMap;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEAMRouter_RI
extends UnicastRemoteObject
implements LEAMRouter_R,
Runnable {
    public static final String ALL_IDS = "";
    static final String ADD_MANAGER = "add_manager";
    static final String REMOVE_MANAGER = "remove_manager";
    static LEAMRouter_RI s_router = null;
    LEVector m_msgs = new LEVector();
    Hashtable m_ids = new Hashtable();
    String m_ignoreId;
    long m_wait;
    int m_count;
    long m_start;
    long m_mark;
    long m_idle;
    boolean m_idleFlag;

    public static LEAMRouter_RI Initialize() {
        block2: {
            if (s_router != null) break block2;
            try {
                s_router = new LEAMRouter_RI();
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return s_router;
    }

    public static LEAMRouter_RI GetAMRouter() {
        return s_router;
    }

    public LEAMRouter_RI() throws RemoteException {
        Thread thread = new Thread(this);
        thread.setName("Asynchronous Message Router");
        thread.start();
    }

    public void addObserver(String string, LEAMManager_R lEAMManager_R) throws RemoteException {
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(string, ADD_MANAGER, lEAMManager_R);
        this.distribute(lEAsyncMessage);
    }

    public void removeObserver(String string, LEAMManager_R lEAMManager_R) throws RemoteException {
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(string, REMOVE_MANAGER, lEAMManager_R);
        this.distribute(lEAsyncMessage);
    }

    public void distribute(String string, String string2, Object object) {
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(string, string2, object);
        this.distribute(lEAsyncMessage);
    }

    public void distribute(LEAsyncMessage lEAsyncMessage) {
        try {
            this.m_msgs.addElement(lEAsyncMessage);
            LEAMRouter_RI lEAMRouter_RI = this;
            synchronized (lEAMRouter_RI) {
                this.notify();
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void setIgnoreId(String string) {
        this.m_ignoreId = string;
    }

    public LECCMap getCCMap() {
        LECCMap lECCMap = new LECCMap();
        Enumeration enumeration = this.m_ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LEVector lEVector = (LEVector)this.m_ids.get(string);
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                LEAMManager_R lEAMManager_R = (LEAMManager_R)lEVector.elementAt(n2);
                try {
                    String string2 = lEAMManager_R.getResourceID();
                    if (this.m_ignoreId == null || !string2.equals(this.m_ignoreId)) {
                        lECCMap.add(string, string2);
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return lECCMap;
    }

    public void run() {
        this.m_start = System.currentTimeMillis();
        this.m_idle = 0L;
        this.m_idleFlag = false;
        while (true) {
            try {
                while (this.m_msgs.size() > 0) {
                    LEAsyncMessage lEAsyncMessage = (LEAsyncMessage)this.m_msgs.removeElementAt(0);
                    String string = lEAsyncMessage.getType();
                    if (string.equals(ADD_MANAGER)) {
                        this.addManager(lEAsyncMessage.getID(), (LEAMManager_R)lEAsyncMessage.getData());
                        continue;
                    }
                    if (string.equals(REMOVE_MANAGER)) {
                        this.removeManager(lEAsyncMessage.getID(), (LEAMManager_R)lEAsyncMessage.getData());
                        continue;
                    }
                    this.routeMessage(lEAsyncMessage);
                }
                LEAMRouter_RI lEAMRouter_RI = this;
                synchronized (lEAMRouter_RI) {
                    if (this.m_msgs.size() == 0) {
                        this.m_mark = System.currentTimeMillis();
                        this.m_idleFlag = true;
                        this.wait();
                        this.m_idleFlag = false;
                        this.m_idle += System.currentTimeMillis() - this.m_mark;
                    }
                    continue;
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                continue;
            }
            break;
        }
    }

    public boolean haveClientsFor(String string) {
        return this.m_ids.contains(string);
    }

    public boolean verifyClientsFor(String string) {
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            return false;
        }
        boolean bl = false;
        LEAMManager_R lEAMManager_R = null;
        int n = lEVector.size();
        int n2 = n - 1;
        while (!bl && n2 > -1) {
            try {
                lEAMManager_R = (LEAMManager_R)lEVector.elementAt(n2);
                if (lEAMManager_R.ping()) {
                    bl = true;
                } else {
                    lEVector.removeElementAt(n2);
                }
            }
            catch (ConnectException connectException) {
                lEVector.removeElementAt(n2);
                LEDebug.getLog().logln(20, connectException);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            --n2;
        }
        return bl;
    }

    public synchronized long getLastWait() {
        long l = 0L;
        if (this.m_count > 0) {
            l = this.m_wait / (long)this.m_count;
        }
        this.m_wait = 0L;
        this.m_count = 0;
        return l;
    }

    public synchronized int getIdleTime() {
        long l = System.currentTimeMillis();
        long l2 = l - this.m_start;
        long l3 = this.m_idle;
        if (this.m_idleFlag) {
            l3 += l - this.m_mark;
            this.m_mark = l;
        }
        this.m_start = l;
        this.m_idle = 0L;
        return (int)((double)l3 / (double)l2 * 100.0);
    }

    void addManager(String string, LEAMManager_R lEAMManager_R) {
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            lEVector = new LEVector();
            this.m_ids.put(string, lEVector);
        }
        lEVector.addElementUnique(lEAMManager_R);
    }

    void removeManager(String string, LEAMManager_R lEAMManager_R) {
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            return;
        }
        lEVector.removeElement(lEAMManager_R);
    }

    void routeMessage(LEAsyncMessage lEAsyncMessage) {
        LEVector lEVector = (LEVector)this.m_ids.get(ALL_IDS);
        if (lEVector != null) {
            this.notify(lEVector, lEAsyncMessage);
        }
        if ((lEVector = (LEVector)this.m_ids.get(lEAsyncMessage.getID())) != null) {
            this.notify(lEVector, lEAsyncMessage);
        }
        this.m_wait += System.currentTimeMillis() - lEAsyncMessage.getTimestamp();
        ++this.m_count;
    }

    void notify(LEVector lEVector, LEAsyncMessage lEAsyncMessage) {
        LEAMManager_R lEAMManager_R = null;
        int n = lEVector.size();
        int n2 = n - 1;
        while (n2 > -1) {
            try {
                lEAMManager_R = (LEAMManager_R)lEVector.elementAt(n2);
                lEAMManager_R.process(lEAsyncMessage);
                lEAMManager_R = null;
            }
            catch (ConnectException connectException) {
                LEDebug.getLog().logln(20, connectException);
                lEVector.removeElementAt(n2);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            --n2;
        }
    }
}

