/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEFilterFileParser;
import com.lucent.ra.nms.model.LEFilters;
import com.lucent.ra.nms.model.LELocationFileParser;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LENATMaps;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;

public class LEFileConnectionFacade
implements LEConnectionFacade {
    LEConnectionManager m_cm;
    String m_path;
    String m_id;
    LEConfig m_config;
    LEDSSFlatFile m_dssfile;
    int m_mode;

    public LEFileConnectionFacade(LEConnectionManager lEConnectionManager, LEConfig lEConfig, String string, String string2) {
        this.m_cm = lEConnectionManager;
        this.m_path = LEAppInfo.createFullPath(string, string2);
        this.m_id = LEResourceID.CreateFile_ID(this.m_path);
        this.m_config = lEConfig;
        this.m_dssfile = null;
        this.m_mode = -1;
    }

    public LEFileConnectionFacade(LEConnectionManager lEConnectionManager, LEConfig lEConfig, String string) {
        this.m_cm = lEConnectionManager;
        this.m_path = string;
        this.m_id = LEResourceID.CreateFile_ID(this.m_path);
        this.m_config = lEConfig;
        this.m_dssfile = null;
        this.m_mode = -1;
    }

    public LEDSS getDSS() {
        return this.m_dssfile;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_path;
    }

    public boolean getConfig(String string) {
        try {
            this.openFile(0);
            LEVector lEVector = this.m_dssfile.getCommands();
            if (string.equals("filter")) {
                LEFilterFileParser lEFilterFileParser = new LEFilterFileParser();
                lEFilterFileParser.readFilters(lEVector);
                LEFilters lEFilters = lEFilterFileParser.getFilters();
                this.m_config.set(string, lEFilters);
            } else if (string.equals("1703936")) {
                LELocationFileParser lELocationFileParser = new LELocationFileParser();
                lELocationFileParser.createPatterns();
                lELocationFileParser.readLocations(lEVector);
                LELocations lELocations = lELocationFileParser.getLocations();
                this.m_config.set(string, lELocations);
            } else if (string.equals("2686976")) {
                LENATMaps lENATMaps = new LENATMaps(this);
                this.m_config.set(string, lENATMaps);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }

    public boolean getConfig(String string, String string2) {
        return this.getConfig(string);
    }

    public LEVector getTOC(int n) {
        return null;
    }

    public LEPMCommand execute(String string) {
        LEVector lEVector = new LEVector(1);
        lEVector.add(string);
        LEPMCommand lEPMCommand = new LEPMCommand(string);
        try {
            this.openFile(1);
            this.m_dssfile.writeConfig(lEVector);
            lEPMCommand.setStatus(true);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            lEPMCommand.setResult("No connection");
            lEPMCommand.setStatus(false);
        }
        lEVector = null;
        return lEPMCommand;
    }

    public boolean supportsEntities() {
        return true;
    }

    public boolean supports(int n) {
        return true;
    }

    public void close() throws IOException {
        if (this.m_dssfile != null) {
            this.m_cm.disconnectFrom(this.m_dssfile);
        }
        this.m_dssfile = null;
    }

    public boolean isConnected() {
        return this.m_dssfile != null;
    }

    public void disconnect() {
        try {
            this.close();
            return;
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
            return;
        }
    }

    public boolean reconnect() {
        return true;
    }

    protected void openFile(int n) throws IOException {
        if (this.m_dssfile != null) {
            if (this.m_mode == n) {
                return;
            }
            this.close();
        }
        this.m_mode = n;
        this.m_dssfile = this.m_cm.connectToFile(this.m_path, this.m_mode);
        this.m_dssfile.connect();
    }
}

