/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.context;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import oracle.help.HelpBook;
import oracle.help.QuickTourWindow;
import oracle.help.TopicNotFoundException;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.navigator.OptionsDialog;
import oracle.help.navigator.SearchDialog;
import oracle.help.topicWindow.TopicWindow;
import oracle.help.topicWindow.TopicWindowPanel;
import oracle.help.util.Library;
import oracle.help.util.WindowManager;

public class GlobalContext {
    private NavigatorWindow _navigator = null;
    private WindowManager _windowManager = new WindowManager(this);
    private SearchDialog _searchDialog;
    private Library _library = new Library();
    private OptionsDialog _optionsDialog;
    private String _charset;
    private AppletContext _appletContext;
    private QuickTourWindow _helpWindow;
    private boolean _restoreSearchDialog = false;
    private boolean _restoreNavigator = false;

    public GlobalContext() {
        Locale locale = Locale.getDefault();
        if (locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE)) {
            this._charset = "SJIS";
            return;
        }
        this._charset = "8859_1";
    }

    public String getDefaultCharset() {
        return this._charset;
    }

    public void setDefaultCharset(String string) {
        this._charset = new String(string);
        this._windowManager.setCharset(string);
        this._navigator.setCharset(string);
    }

    public void dispose() {
        this._windowManager.removeAllWindows();
        if (this._navigator != null) {
            this._navigator.setVisible(false);
            this._navigator.dispose();
        }
        if (this._searchDialog != null) {
            this._searchDialog.setVisible(false);
            this._searchDialog.dispose();
        }
        this._library = null;
    }

    public void displayURL(HelpBook helpBook, URL uRL) {
        this.displayURL(helpBook, uRL, false);
    }

    public void displayURL(HelpBook helpBook, URL uRL, boolean bl) {
        this.displayURL(helpBook, uRL, bl, null, null);
    }

    public void displayURL(HelpBook helpBook, URL uRL, boolean bl, Point point, Dimension dimension) {
        if (this._appletContext != null) {
            this._appletContext.showDocument(uRL, "Help");
            return;
        }
        this._windowManager.displayURL(helpBook, uRL, bl, point, dimension);
    }

    public void showTopic(HelpBook helpBook, String string, boolean bl, Point point, Dimension dimension) throws TopicNotFoundException {
        Hashtable hashtable = (Hashtable)helpBook.getTopicsHashtable();
        if (hashtable == null) {
            return;
        }
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            throw new TopicNotFoundException("\"" + string + "\"" + " help topic not found in the book \"" + helpBook.getTitle() + "\"");
        }
        try {
            URL uRL = new URL(String.valueOf(helpBook.getBaseURL()) + string2);
            this.displayURL(helpBook, uRL, bl, point, dimension);
            return;
        }
        catch (Exception exception) {
            System.out.println("Topic not found : " + string);
            return;
        }
    }

    public void showTopic(HelpBook helpBook, String string, boolean bl) throws TopicNotFoundException {
        this.showTopic(helpBook, string, false, null, null);
    }

    public void showTopic(HelpBook helpBook, String string) throws TopicNotFoundException {
        this.showTopic(helpBook, string, false);
    }

    public void setHTMLBrowser(Class clazz) {
        this._windowManager.setHTMLBrowser(clazz);
    }

    public void setAppletContext(AppletContext appletContext) {
        this._appletContext = appletContext;
    }

    protected void setActiveWindow() {
        this._windowManager.setActiveWindow();
    }

    protected TopicWindow getActiveWindow() {
        return this._windowManager.getActiveWindow();
    }

    public void removeWindow(TopicWindow topicWindow) {
        this._windowManager.removeWindow(topicWindow);
    }

    public void undockTopicWindowPanel(TopicWindowPanel topicWindowPanel, Dimension dimension) {
        this._windowManager.undock(topicWindowPanel, dimension);
    }

    public Dimension getTopicWindowInitialSize() {
        return TopicWindow.getInitialSize();
    }

    public URL getActiveWindowUrl() {
        TopicWindow topicWindow = this._windowManager.getActiveWindow();
        if (topicWindow != null) {
            return topicWindow.getURL();
        }
        return null;
    }

    public URL getCurrentWindowUrl() {
        return this._windowManager.getCurrentWindowUrl();
    }

    public HelpBook getCurrentWindowBook() {
        return this._windowManager.getCurrentWindowBook();
    }

    public boolean isWindowsListEmpty() {
        return this._windowManager.getTopicWindowCount() == 0;
    }

    private TopicWindow createTopicWindow() {
        return this._windowManager.createTopicWindow();
    }

    public void dockTopicWindowPanel(TopicWindow topicWindow) {
        this._windowManager.dock(topicWindow);
    }

    public boolean isNavigatorDocked() {
        if (this._navigator == null) {
            return false;
        }
        return this._navigator.isDocked();
    }

    public void showNavigatorWindow() {
        this.showNavigator(false, false);
    }

    public void showIndex() {
        this.showNavigator(true, false);
    }

    public void showContents() {
        this.showNavigator(true, true);
    }

    protected void showNavigator(boolean bl, boolean bl2) {
        this.getNavigatorWindow(true);
        if (bl) {
            if (bl2) {
                this._navigator.showContents();
            } else {
                this._navigator.showIndex();
            }
        } else {
            this._navigator.refresh();
        }
        this._navigator.setVisible(true);
        this._navigator.show();
        this._navigator.toFront();
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            if (this._navigator != null) {
                this._restoreNavigator = this._navigator.isVisible();
                this._navigator.setVisible(bl);
            }
            if (this._searchDialog != null) {
                this._restoreSearchDialog = this._searchDialog.isVisible();
                this._searchDialog.setVisible(bl);
            }
        } else {
            if (this._restoreNavigator) {
                this.showNavigatorWindow();
            }
            if (this._restoreSearchDialog) {
                this._searchDialog.setVisible(bl);
            }
        }
        this._windowManager.setTopicWindowsVisible(bl);
    }

    public void addBook(HelpBook helpBook, int n, boolean bl) {
        if (helpBook != null) {
            this._library.addBook(helpBook, n, bl);
        }
    }

    public void replaceBook(int n, HelpBook helpBook) throws ArrayIndexOutOfBoundsException {
        this._library.replaceBook(n, helpBook);
    }

    public Enumeration getBooks() {
        return this._library.getBooks();
    }

    public int getBookCount() {
        return this._library.getBookCount();
    }

    public HelpBook getBookAt(int n) throws ArrayIndexOutOfBoundsException {
        return this._library.getBook(n);
    }

    public void setBookVisible(HelpBook helpBook, boolean bl) {
        this._library.setBookVisible(helpBook, bl);
    }

    public void removeBook(HelpBook helpBook) {
        this._library.removeBook(helpBook);
    }

    public Library getLibrary() {
        return this._library;
    }

    public boolean isNavigatorVisible() {
        if (this._navigator == null) {
            return false;
        }
        return this._navigator.isVisible();
    }

    public void refreshNavigator() {
        if (this._navigator != null && this._navigator.isVisible()) {
            this._navigator.refresh();
        }
    }

    public void setCurrentWindow(TopicWindow topicWindow) {
        this._windowManager.setCurrentWindow(topicWindow);
    }

    public NavigatorWindow getNavigatorWindow(boolean bl) {
        if (this._navigator != null || !bl) {
            return this._navigator;
        }
        this._navigator = new NavigatorWindow(this);
        Toolkit toolkit = this._navigator.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this._navigator.getSize();
        Dimension dimension3 = TopicWindow.getInitialSize();
        SearchDialog.getInitialSize();
        int n = dimension.width - dimension2.width - dimension3.width - 10;
        if (n < 0 && (n = dimension.width - dimension2.width - 10) < 0 && (n = dimension.width - dimension2.width) < 0) {
            n = 10;
        }
        ((Component)this._navigator).setLocation(n, 10);
        return this._navigator;
    }

    public void showSearchDialog() {
        HelpBook[] helpBookArray = this._library.getVisibleBooks();
        boolean bl = false;
        int n = 0;
        while (n < helpBookArray.length) {
            if (helpBookArray[n].containsSearch()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        if (this._searchDialog == null) {
            this.createSearchDialog();
        }
        this._searchDialog.requestFocus();
        this._searchDialog.setVisible(true);
        this._searchDialog.toFront();
    }

    private void createSearchDialog() {
        this._searchDialog = new SearchDialog(this);
        Toolkit toolkit = this._searchDialog.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this._searchDialog.getSize();
        if (this.isNavigatorVisible() && this._navigator.isShowing()) {
            Dimension dimension3 = this._navigator.getSize();
            Point point = this._navigator.getLocation();
            int n = point.x + dimension3.width / 2;
            int n2 = point.y + dimension3.height / 2;
            if (dimension.width < n + dimension2.width) {
                n = dimension.width - dimension2.width;
            }
            if (dimension.height < n2 + dimension2.height) {
                n2 = dimension.height - dimension2.height;
            }
            ((Component)this._searchDialog).setLocation(n, n2);
            return;
        }
        ((Component)this._searchDialog).setLocation(dimension.width - (dimension2.width + 10), dimension.height - (dimension2.height + 10));
    }

    public OptionsDialog getOptionsDialog() {
        if (this._optionsDialog == null) {
            this._optionsDialog = new OptionsDialog(new Frame());
            this._optionsDialog.setCharset(this._charset);
        }
        return this._optionsDialog;
    }

    public void showHelpOnHelp() {
        URL uRL = this.getClass().getResource("helpdoc/helphelp.htm");
        if (uRL == null) {
            return;
        }
        if (this._appletContext != null) {
            this._appletContext.showDocument(uRL, "HelpOnHelp");
            return;
        }
        if (this._helpWindow == null) {
            if (this._windowManager.getHTMLBrowser() != null) {
                try {
                    this._helpWindow = new QuickTourWindow(this._windowManager.getHTMLBrowser());
                }
                catch (Exception exception) {}
            }
            if (this._helpWindow == null) {
                this._helpWindow = new QuickTourWindow();
            }
            this._helpWindow.setFrontpage(uRL);
            this._helpWindow.setTitle("Help on Help");
        }
        ((Component)this._helpWindow).setVisible(true);
    }
}

