/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEMonEnvMessage;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEScrollablePanel;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEMonStatusView
extends Panel
implements LEPMView,
LEAMObserver,
LEMLListener,
ItemListener,
ActionListener {
    public static final String DASH = "-";
    public static final String ZERO = "0";
    public static final String MANAGER = "4";
    public static final String ETHERNET = "10";
    public static final String ETHER_DUAL = "11";
    static LEPortMaster s_pm = null;
    LEPortMaster[] m_pms;
    LEPortMaster m_selPM;
    Panel m_pmPanel;
    Choice m_pmChoice;
    LEMultiList m_boards;
    Label[] m_values;
    Button m_on;
    Button m_off;

    public static void Display(LEPortMaster lEPortMaster) {
        s_pm = lEPortMaster;
    }

    public LEMonStatusView() {
        this.setLayout(new BorderLayout(0, 0));
        this.m_pmPanel = new Panel();
        this.m_pmPanel.setLayout(new FlowLayout(1));
        this.m_pmChoice = new Choice();
        this.m_pmChoice.addItemListener(this);
        this.m_pmPanel.add(this.m_pmChoice);
        this.add("North", this.m_pmPanel);
        LEBorderPanel lEBorderPanel = new LEBorderPanel(1);
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.add("West", this.createPowerPanel());
        lEBorderPanel.add("Center", this.createBoardPanel());
        this.add("Center", lEBorderPanel);
    }

    public void addListener(LEViewListener lEViewListener) {
    }

    public void deleteListener(LEViewListener lEViewListener) {
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        return null;
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        int n;
        this.m_pms = lEPortMasterArray;
        this.updatePMChoice(this.m_pms);
        int n2 = -1;
        if (s_pm == null) {
            n = 0;
            while (n2 == -1 && n < this.m_pms.length) {
                if (this.m_pms[n] == this.m_selPM) {
                    n2 = n;
                }
                ++n;
            }
        }
        if (n2 == -1) {
            if (this.m_selPM != null) {
                this.stopMonitoring(this.m_selPM);
            }
            this.m_selPM = null;
            n2 = 0;
        }
        if (s_pm != null) {
            n2 = -1;
            n = 0;
            while (n2 == -1 && n < this.m_pms.length) {
                if (this.m_pms[n] == s_pm) {
                    n2 = n;
                }
                ++n;
            }
            if (n2 == -1) {
                n2 = 0;
            }
            s_pm = null;
        }
        if (this.m_pms.length > 0) {
            this.m_pmChoice.select(n2);
            if (this.m_selPM == null) {
                this.m_selPM = this.m_pms[n2];
                this.startMonitoring(this.m_selPM);
                this.refreshBoards(this.m_selPM);
            }
        }
    }

    public void going() {
        if (this.m_selPM != null) {
            this.stopMonitoring(this.m_selPM);
        }
        this.m_boards.deleteListener(this);
    }

    public void gone() {
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 3) {
            boolean bl = false;
            int[] nArray = this.m_boards.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                String string = (String)this.m_boards.getCellItem(nArray[n], 0);
                if (string.equals(MANAGER) || string.equals(ETHERNET) || string.equals(ETHER_DUAL)) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                this.m_on.setEnabled(false);
                this.m_off.setEnabled(false);
                return;
            }
            this.m_on.setEnabled(true);
            this.m_off.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LEBoard lEBoard;
        String string;
        if (this.m_selPM == null) {
            return;
        }
        LEBoards lEBoards = (LEBoards)this.m_selPM.get("2555904");
        if (lEBoards == null) {
            return;
        }
        String string2 = actionEvent.getActionCommand();
        String string3 = string2.equals("On") ? "on" : "off";
        boolean bl = false;
        int[] nArray = this.m_boards.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            String string4;
            string = (String)this.m_boards.getCellItem(nArray[n], 0);
            if (!(string.equals(MANAGER) || string.equals(ETHERNET) || string.equals(ETHER_DUAL) || (lEBoard = (LEBoard)lEBoards.get(string)) == null || (string4 = (String)lEBoard.get(LEBoard.POWER)).equals(string3))) {
                lEBoard.set(LEBoard.POWER, string3);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            LEVector lEVector = lEBoards.saveChanges();
            lEBoards.refresh();
            lEStatusDialog.hideStatus();
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), this.m_selPM.getConnectionFacade(), lEVector);
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                string = (String)this.m_boards.getCellItem(nArray[n2], 0);
                lEBoard = (LEBoard)lEBoards.get(string);
                if (lEBoard != null) {
                    this.m_boards.setCellItem(nArray[n2], 1, lEBoard.getType());
                    this.m_boards.setCellItem(nArray[n2], 4, lEBoard.getStatus());
                }
                ++n2;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.m_pmChoice.getSelectedIndex();
        if (this.m_pms[n] != this.m_selPM) {
            if (this.m_selPM != null) {
                this.stopMonitoring(this.m_selPM);
            }
            this.m_selPM = this.m_pms[n];
            this.startMonitoring(this.m_selPM);
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_selPM == null) {
            return;
        }
        if (!string.equals(this.m_selPM.getResourceID())) {
            return;
        }
        if (object instanceof LEMonEnvMessage) {
            this.updateEnv((LEMonEnvMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void refreshBoards(LEPortMaster lEPortMaster) {
        try {
            this.m_boards.deleteAllRows();
            LEBoards lEBoards = (LEBoards)lEPortMaster.get("2555904");
            if (lEBoards != null) {
                LEVector lEVector = lEBoards.getKeys();
                int n = lEVector.size();
                int n2 = 0;
                while (n2 < n) {
                    this.addRow((String)lEVector.elementAt(n2), null);
                    ++n2;
                }
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        String string = lEPortMaster.getResourceID();
        LEMonitorFactory.GetFactory().addObserver(string, this);
        LEStatusFactory.GetFactory().addObserver(string, this);
        lEPMConnectionFacade.startMonitor(0x330000, -1, LEPMConnectionFacade.NO_GROUP, 60000);
    }

    void stopMonitoring(LEPortMaster lEPortMaster) {
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        String string = lEPortMaster.getResourceID();
        LEMonitorFactory.GetFactory().deleteObserver(string, this);
        LEStatusFactory.GetFactory().deleteObserver(string, this);
        lEPMConnectionFacade.stopMonitor(0x330000, -1, LEPMConnectionFacade.NO_GROUP, 60000);
        this.resetValues();
    }

    void updatePMChoice(LEPortMaster[] lEPortMasterArray) {
        this.m_pmChoice.removeAll();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.m_pmChoice.add(lEPortMasterArray[n].getDescription());
            ++n;
        }
        this.m_pmChoice.invalidate();
        this.m_pmPanel.invalidate();
        this.m_pmPanel.validate();
    }

    void updateEnv(LEMonEnvMessage lEMonEnvMessage) {
        if (this.m_selPM == null) {
            return;
        }
        this.m_values[0].setText(lEMonEnvMessage.getMaxPower());
        this.m_values[1].setText(lEMonEnvMessage.getUsedPower());
        this.m_values[2].setText(lEMonEnvMessage.getReqPower());
        this.m_values[3].setText(lEMonEnvMessage.getPowerSupply("top"));
        this.m_values[4].setText(lEMonEnvMessage.getPowerSupply("middle"));
        this.m_values[5].setText(lEMonEnvMessage.getPowerSupply("bottom"));
        this.m_values[6].setText(lEMonEnvMessage.getPrimaryDC());
        this.m_values[7].setText(lEMonEnvMessage.getSecondaryDC());
        this.m_values[8].setText(lEMonEnvMessage.getFan(1));
        this.m_values[9].setText(lEMonEnvMessage.getFan(2));
        this.m_values[10].setText(lEMonEnvMessage.getFan(3));
        this.m_values[11].setText(lEMonEnvMessage.getFan(4));
        LEBoards lEBoards = (LEBoards)this.m_selPM.get("2555904");
        if (lEBoards == null) {
            return;
        }
        int n = 0;
        while (n < 15) {
            String string = Integer.toString(n);
            LEBoard lEBoard = (LEBoard)lEBoards.get(string);
            if (lEBoard != null) {
                int n2 = this.getRowFor(string);
                if (n2 > -1) {
                    String string2 = this.getTemperature(lEMonEnvMessage.getBoardTemp(string));
                    String string3 = this.getPower(lEMonEnvMessage.getBoardPower(string));
                    this.m_boards.setCellItem(n2, 1, lEBoard.getType());
                    this.m_boards.setCellItem(n2, 2, string2);
                    this.m_boards.setCellItem(n2, 3, string3);
                    this.m_boards.setCellItem(n2, 4, lEBoard.getStatus());
                } else {
                    this.addRow(string, lEMonEnvMessage);
                }
            }
            ++n;
        }
        this.m_boards.repaint();
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.refreshBoards(this.m_selPM);
                return;
            }
        }
    }

    void resetValues() {
        int n = 0;
        while (n < this.m_values.length) {
            this.m_values[n].setText("");
            ++n;
        }
        this.m_boards.deleteAllRows();
    }

    void addRow(String string, LEMonEnvMessage lEMonEnvMessage) {
        if (this.m_selPM == null) {
            return;
        }
        LEBoards lEBoards = (LEBoards)this.m_selPM.get("2555904");
        if (lEBoards == null) {
            return;
        }
        LEBoard lEBoard = (LEBoard)lEBoards.get(string);
        if (lEBoard == null) {
            return;
        }
        Object[] objectArray = new Object[]{string, lEBoard.getType(), lEMonEnvMessage == null ? "" : this.getTemperature(lEMonEnvMessage.getBoardTemp(string)), lEMonEnvMessage == null ? "" : this.getPower(lEMonEnvMessage.getBoardPower(string)), lEBoard.getStatus()};
        this.m_boards.addRow(objectArray);
        int n = this.m_boards.getNumRows() - 1;
        this.m_boards.setRowObject(n, string);
    }

    int getRowFor(String string) {
        int n = -1;
        int n2 = this.m_boards.getNumRows();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (string.equals((String)this.m_boards.getRowObject(n3))) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    String getPower(String string) {
        if (string == null || string.equals(ZERO)) {
            return DASH;
        }
        return string;
    }

    String getTemperature(String string) {
        if (string == null) {
            return DASH;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = Integer.parseInt(string);
            if (n == 0) {
                return DASH;
            }
            int n2 = 9 * n / 5 + 32;
            stringBuffer.append(n);
            stringBuffer.append('C');
            stringBuffer.append(" / ");
            stringBuffer.append(n2);
            stringBuffer.append('F');
        }
        catch (Exception exception) {
            stringBuffer.setLength(0);
            stringBuffer.append(DASH);
            LEDebug.getLog().logln(20, exception);
        }
        return stringBuffer.toString();
    }

    Component createPowerPanel() {
        Font font = LEFont.getBoldFont();
        this.m_values = new Label[12];
        int n = 0;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(19, 1, 0, 0));
        Label label = new Label(" Power (watts):", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   Maximum:", n++, ""));
        panel.add(this.createValuePanel(font, "   Used:", n++, ""));
        panel.add(this.createValuePanel(font, "   Required:", n++, ""));
        panel.add(new Label(""));
        label = new Label(" AC Power Supplies:", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   Top:", n++, ""));
        panel.add(this.createValuePanel(font, "   Middle:", n++, ""));
        panel.add(this.createValuePanel(font, "   Bottom:", n++, ""));
        panel.add(new Label(""));
        label = new Label(" DC Power Supplies:", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   Primary:", n++, ""));
        panel.add(this.createValuePanel(font, "   Secondary:", n++, ""));
        panel.add(new Label(""));
        label = new Label(" Fans:", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   1:", n++, ""));
        panel.add(this.createValuePanel(font, "   2:", n++, ""));
        panel.add(this.createValuePanel(font, "   3:", n++, ""));
        panel.add(this.createValuePanel(font, "   4:", n++, ""));
        return new LEScrollPanel(new LEScrollablePanel(panel, false, false));
    }

    Component createValuePanel(Font font, String string, int n, String string2) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 0, 0));
        Label label = new Label(string, 0);
        label.setFont(font);
        panel.add(label);
        this.m_values[n] = new Label(string2, 0);
        panel.add(this.m_values[n]);
        return panel;
    }

    Component createBoardPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.m_boards = new LEMultiList(1, 1, 4);
        Object[] objectArray = new String[]{"Board", "Type", "Temperature (c)", "Power (watts)", "Status"};
        this.m_boards.setTitles(0, objectArray);
        this.m_boards.setCellJustification(0, 2);
        this.m_boards.setCellJustification(2, 2);
        this.m_boards.setCellJustification(3, 2);
        this.m_boards.addListener(this);
        panel.add("Center", new LEScrollPanel(this.m_boards));
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(new Label("Power Selected Board(s): "));
        this.m_on = new Button("On");
        panel2.add(this.m_on);
        this.m_on.addActionListener(this);
        this.m_off = new Button("Off");
        panel2.add(this.m_off);
        this.m_off.addActionListener(this);
        panel.add("South", panel2);
        return panel;
    }

    String getMonitorName() {
        return "Monitor Chassis";
    }
}

