/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEFilter;
import com.lucent.ra.nms.model.LEFilters;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEFiltersForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_addName;

    public LEFiltersForm() {
        this.m_renameEntries = true;
    }

    public void setContext(String string, LEVector lEVector) {
        this.m_platform = string;
        this.m_context = lEVector;
        this.m_tags.addElement("ip_rule");
        this.m_tags.addElement("ipx_rule");
        this.m_tags.addElement("sap_rule");
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortable(3, true);
        this.setSortable(4, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = PORTMASTER;
        objectArray[1] = "Filter";
        objectArray[2] = "IP Rule Count";
        objectArray[3] = "IPX Rule Count";
        objectArray[4] = "SAP Rule Count";
        this.setTitles(0, objectArray);
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        Object object = lETable.get(string2);
        if (object instanceof LEFilter) {
            LEFilter lEFilter = (LEFilter)object;
            if ((object = lEFilter.get("ip_rule")) instanceof LETable) {
                objectArray[2] = Integer.toString(((LETable)object).size());
            }
            if ((object = lEFilter.get("ipx_rule")) instanceof LETable) {
                objectArray[3] = Integer.toString(((LETable)object).size());
            }
            if ((object = lEFilter.get("sap_rule")) instanceof LETable) {
                objectArray[4] = Integer.toString(((LETable)object).size());
            }
        }
        this.addRow(objectArray);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("Filter Name:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Filter", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A filter name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable.get(this.m_addName) == null) {
            LEVector lEVector = ((LEFilters)lETable).add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            }
            this.addEntry(lEPortMaster.getDescription(), lETable, this.m_addName);
            lENewEntry = new LENewEntry(lEPortMaster, lETable, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a filter named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEFilters)) {
            return;
        }
        LEFilters lEFilters = (LEFilters)lETable;
        LEVector lEVector = lEFilters.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        String string;
        if (!(object instanceof LEFilter)) {
            return null;
        }
        LEFilter lEFilter = (LEFilter)object;
        LEFilters lEFilters = (LEFilters)this.getTable(lEPortMaster);
        if (lEFilters.get(string = lEFilter.getName()) != null) {
            string = LETableForm.GetUniqueKey(lEFilters, string, 16);
        }
        if ((lEVector = lEFilters.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
        }
        return string;
    }

    String renameEntry(LEPortMaster lEPortMaster, LETable lETable, String string) {
        String string2 = null;
        LERenameDialog lERenameDialog = new LERenameDialog(LEUiUtils.GetBaseFrame(), lETable.getKeySpec(), string);
        String string3 = lERenameDialog.getNewName();
        if (string3 != null) {
            Object object = lETable.get(string3);
            if (object == null) {
                LEVector lEVector = ((LEFilters)lETable).add(string3);
                if (lEVector == null) {
                    string2 = string3;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a filter named " + string3);
            }
        }
        return string2;
    }
}

