/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.util.Locale;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.InteriorPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BackgroundFill;
import oracle.ewt.painter.Fill;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.TransparentFill;

class SharedPainter
implements PaintContext {
    private int _repaintFrozenLevel;
    private Rectangle _frozenDamage;
    private Rectangle _frozenSyncDamage;
    private Fill _fill;
    private static byte _OVERLAP_NOT_COMPUTED;
    private static byte _OVERLAP_DOES_NOT;
    private static byte _OVERLAP_OVERLAPS;
    private byte[] _childrenOverlap;
    private Component[] _childrenMirror;
    private Container _comp;

    public SharedPainter(Container container, Fill fill) {
        this._comp = container;
        this._fill = fill;
    }

    public void setFill(Fill fill) {
        if (fill == null) {
            fill = TransparentFill.getFill();
        }
        if (fill != this._fill) {
            this._fill = fill;
            this._comp.repaint();
        }
    }

    public Fill getFill() {
        return this._fill;
    }

    public Color getPaintBackground() {
        return this._comp.getBackground();
    }

    public Font getPaintFont() {
        return this._comp.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this._comp.getFontMetrics(font);
    }

    public int getPaintState() {
        int n = 0;
        if (!this._comp.isEnabled()) {
            n |= 1;
        }
        return n;
    }

    public ImageObserver getImageObserver() {
        return this._comp;
    }

    public Locale getPaintLocale() {
        return this._comp.getLocale();
    }

    public void freezeRepaints() {
        ++this._repaintFrozenLevel;
    }

    public void unfreezeRepaints(DoubleBuffer doubleBuffer) {
        --this._repaintFrozenLevel;
        if (this._repaintFrozenLevel == 0) {
            Rectangle rectangle;
            Rectangle rectangle2;
            Object object = this;
            synchronized (object) {
                rectangle2 = this._frozenDamage;
                this._frozenDamage = null;
                rectangle = this._frozenSyncDamage;
                this._frozenSyncDamage = null;
            }
            if (rectangle != null) {
                if (rectangle2 != null && rectangle.intersects(rectangle2)) {
                    this._clipToParents(rectangle2);
                    rectangle.add(rectangle2);
                    rectangle2 = null;
                }
                object = null;
                if (this._comp instanceof LWComponent) {
                    object = (LWComponent)this._comp;
                }
                this.paintImmediate(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (LWComponent)object, doubleBuffer);
            }
            if (rectangle2 != null) {
                this._comp.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
    }

    public synchronized void shiftFrozenDamage(int n, int n2) {
        if (this._frozenDamage != null) {
            this._frozenDamage.x += n;
            this._frozenDamage.y += n2;
        }
        if (this._frozenSyncDamage != null) {
            this._frozenSyncDamage.x += n;
            this._frozenSyncDamage.y += n2;
        }
    }

    public void clearClipCache() {
        this._childrenOverlap = null;
    }

    public boolean isClippedBySibling() {
        Container container = this._comp;
        if (!container.isVisible()) {
            return false;
        }
        if (container instanceof Window) {
            return false;
        }
        Container container2 = container.getParent();
        if (container2 != null && container2 instanceof ImmediatePainter) {
            return ((ImmediatePainter)((Object)container2)).isChildClipped(container);
        }
        return false;
    }

    public boolean isChildClipped(Component component) {
        if (this.isClippedBySibling()) {
            return true;
        }
        Container container = this._comp;
        SharedPainter sharedPainter = this;
        synchronized (sharedPainter) {
            byte by;
            int n = container.getComponentCount();
            if (n <= 1) {
                boolean bl = false;
                Object var5_7 = null;
                return bl;
            }
            Component[] componentArray = this._childrenMirror;
            int n2 = 0;
            while (n2 < n) {
                if (componentArray[n2] == component) break;
                ++n2;
            }
            byte[] byArray = this._childrenOverlap;
            if (byArray == null) {
                this._childrenOverlap = byArray = new byte[n];
                by = _OVERLAP_NOT_COMPUTED;
            } else {
                by = byArray[n2];
            }
            if (by == _OVERLAP_NOT_COMPUTED) {
                this._childrenOverlap[n2] = by = this._computeOverlaps(component, componentArray, n2);
            }
            boolean bl = by == _OVERLAP_OVERLAPS;
            Object var5_8 = null;
            return bl;
        }
    }

    public void paintImmediateClipped(int n, int n2, int n3, int n4, LWComponent lWComponent, DoubleBuffer doubleBuffer) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this._clipToParents(rectangle);
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.paintImmediate(rectangle.x, rectangle.y, rectangle.width, rectangle.height, lWComponent, doubleBuffer);
        }
    }

    public void paintImmediate(int n, int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        this.paintImmediate(n, n2, n3, n4, null, doubleBuffer);
    }

    public void paintImmediate(int n, int n2, int n3, int n4, LWComponent lWComponent, DoubleBuffer doubleBuffer) {
        Container container = this._comp;
        if (this._repaintFrozenLevel == 0 || !this._addFrozenDamage(n, n2, n3, n4, true)) {
            if (lWComponent != null && lWComponent.isPaintPropagationRequired()) {
                Point point = container.getLocation();
                n += point.x;
                n2 += point.y;
                Container container2 = container.getParent();
                if (container2 == null) {
                    return;
                }
                if (container2 instanceof ImmediatePainter) {
                    ((ImmediatePainter)((Object)container2)).paintImmediateUnclipped(n, n2, n3, n4);
                    return;
                }
                Graphics graphics = container2.getGraphics();
                if (graphics != null) {
                    graphics.clipRect(n, n2, n3, n4);
                    if (lWComponent.isTransparent()) {
                        container2.update(graphics);
                    } else {
                        container2.paint(graphics);
                    }
                    graphics.dispose();
                    return;
                }
                container.repaint(n, n2, n3, n4);
                return;
            }
            Graphics graphics = container.getGraphics();
            if (graphics != null) {
                graphics.clipRect(n, n2, n3, n4);
                this.paint(graphics, doubleBuffer, (InteriorPainter)((Object)container));
                graphics.dispose();
                return;
            }
            container.repaint(n, n2, n3, n4);
        }
    }

    public boolean repaint(int n, int n2, int n3, int n4) {
        return !this._addFrozenDamage(n, n2, n3, n4, false);
    }

    public void paint(Graphics graphics, DoubleBuffer doubleBuffer, InteriorPainter interiorPainter) {
        Object object;
        block6: {
            Graphics graphics2 = graphics;
            Container container = this._comp;
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                object = this._comp.getSize();
                graphics.setClip(0, 0, ((Dimension)object).width, ((Dimension)object).height);
            }
            object = graphics instanceof PrintGraphics ? null : doubleBuffer.getOffscreenBuffer(container);
            try {
                if (object != null) {
                    graphics = ((Image)object).getGraphics();
                    GraphicUtils.synchronizeGraphics(graphics, graphics2);
                    if (this.getFill().isTransparent()) {
                        this.paintBackground(graphics, BackgroundFill.getFill());
                    }
                }
                this.paintExtents(graphics, interiorPainter);
                if (object == null) break block6;
                Rectangle rectangle2 = graphics2.getClipBounds();
                int n = rectangle2.x;
                int n2 = rectangle2.y;
                graphics2.drawImage((Image)object, n, n2, n + rectangle2.width, n2 + rectangle2.height, n, n2, n + rectangle2.width, n2 + rectangle2.height, container);
                graphics.dispose();
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_12 = null;
                    if (object == null) break block7;
                    doubleBuffer.releaseOffscreenBuffer((Image)object);
                }
                throw throwable;
            }
        }
        Object var9_11 = null;
        if (object != null) {
            doubleBuffer.releaseOffscreenBuffer((Image)object);
        }
    }

    protected void paintExtents(Graphics graphics, InteriorPainter interiorPainter) {
        this.paintBackground(graphics, this.getFill());
        if (this._comp.getComponentCount() > 0) {
            Graphics graphics2 = graphics.create();
            interiorPainter.paintInterior(graphics2);
            graphics2.dispose();
            try {
                interiorPainter.paintChildren(graphics);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        interiorPainter.paintInterior(graphics);
    }

    protected void paintBackground(Graphics graphics, Fill fill) {
        Dimension dimension = this._comp.getSize();
        fill.paint(graphics, dimension.width, dimension.height, this);
    }

    synchronized void add(Component component, int n) {
        this.clearClipCache();
        int n2 = this._comp.getComponentCount();
        Component[] componentArray = this._childrenMirror;
        if (componentArray == null || n2 > componentArray.length) {
            if (n2 < 4) {
                this._childrenMirror = this._comp.getComponents();
                return;
            }
            int n3 = componentArray == null ? 4 : componentArray.length + 8;
            Component[] componentArray2 = new Component[n3];
            if (componentArray != null) {
                System.arraycopy(componentArray, 0, componentArray2, 0, componentArray.length);
            }
            componentArray = componentArray2;
            this._childrenMirror = componentArray2;
        }
        if (n == -1 || n == n2 - 1) {
            componentArray[n2 - 1] = component;
            return;
        }
        System.arraycopy(componentArray, n, componentArray, n + 1, n2 - n - 1);
        componentArray[n] = component;
    }

    synchronized void remove(int n) {
        this.clearClipCache();
        int n2 = this._comp.getComponentCount();
        Component[] componentArray = this._childrenMirror;
        if (n < n2) {
            System.arraycopy(componentArray, n + 1, componentArray, n, n2 - n);
        }
        componentArray[n2] = null;
    }

    synchronized void removeAll() {
        this.clearClipCache();
        this._childrenMirror = null;
    }

    private boolean _addFrozenDamage(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (this._repaintFrozenLevel == 0) {
            bl2 = false;
        } else {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            SharedPainter sharedPainter = this;
            synchronized (sharedPainter) {
                boolean bl3 = bl2 = this._repaintFrozenLevel != 0;
                if (bl2) {
                    Rectangle rectangle2;
                    Rectangle rectangle3 = rectangle2 = bl ? this._frozenSyncDamage : this._frozenDamage;
                    if (rectangle2 == null) {
                        rectangle2 = rectangle;
                    } else {
                        rectangle2.add(rectangle);
                    }
                    if (bl) {
                        this._frozenSyncDamage = rectangle2;
                    } else {
                        this._frozenDamage = rectangle2;
                    }
                }
            }
        }
        return bl2;
    }

    private byte _computeOverlaps(Component component, Component[] componentArray, int n) {
        Rectangle rectangle = component.getBounds();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2.isVisible() && component2.getBounds().intersects(rectangle)) {
                return _OVERLAP_OVERLAPS;
            }
            ++n2;
        }
        return _OVERLAP_DOES_NOT;
    }

    void _clipToParents(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        Container container = this._comp;
        do {
            Rectangle rectangle2 = container.getBounds();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            n += rectangle2.x;
            n2 += rectangle2.y;
            SharedPainter._intersectRect(rectangle, rectangle, rectangle2);
        } while ((container = container.getParent()) != null && !(container instanceof Window));
        rectangle.x -= n;
        rectangle.y -= n2;
    }

    static void _intersectRect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = rectangle2.x;
        int n2 = n + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = n3 + rectangle2.height;
        int n5 = rectangle3.x;
        int n6 = n5 + rectangle3.width;
        int n7 = rectangle3.y;
        int n8 = n7 + rectangle3.height;
        rectangle.x = n >= n5 ? n : n5;
        rectangle.y = n3 >= n7 ? n3 : n7;
        rectangle.width = (n2 <= n6 ? n2 : n6) - rectangle.x;
        rectangle.height = (n4 <= n8 ? n4 : n8) - rectangle.y;
    }

    static {
        _OVERLAP_DOES_NOT = 1;
        _OVERLAP_OVERLAPS = (byte)2;
    }
}

