/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWDataSourceList;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.help.HelpBook;
import oracle.help.context.GlobalContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.search.QueryObject;
import oracle.help.search.QueryResultInterface;
import oracle.help.util.CancelDialog;
import oracle.help.util.SpecialAboutBox;
import oracle.help.util.TreeNode;
import oracle.help.util.TreeRoot;

public class SearchDialog
extends BufferedFrame
implements ActionListener,
ItemListener,
TextListener,
Runnable {
    private GlobalContext _context;
    private LWTextField _searchField;
    private LWCheckbox _allRadio;
    private LWCheckbox _anyRadio;
    private LWCheckbox _caseCheck;
    LWButton _searchButton;
    private LWButton _limitButton;
    private LWButton _helpButton;
    private LWButton _closeButton;
    private LWDataSourceList _list;
    private LWButton _openButton;
    private ResultsDataSource _resDataSource;
    private Vector _results;
    private int _hitCount;
    private LWLabel _status;
    private String _inProgress;
    private String _foundtopics;
    private String _filenotfound;
    private String _failed;
    private String _searching;
    private String _lastSearchText;
    private boolean _lastSearchAllItems;
    private boolean _lastSearchCaseSensitive;
    private String[] _words;
    private final boolean _debug = false;
    private static String _untitled = "Untitled Document";
    private Thread _searchThread;
    private CancelDialog _cancelDialog;
    private int _dialogWidth;
    private int _dialogHeight;
    private QueryObject _curSearchObject;
    private boolean _quickTour;
    private HTMLBrowser _htmlBrowser;
    private URL _baseURL;
    private URL _indexURL;

    public SearchDialog(GlobalContext globalContext) {
        this._context = globalContext;
        this._quickTour = false;
        this.createSearchDialogUI();
    }

    public SearchDialog(HTMLBrowser hTMLBrowser, URL uRL, String string) {
        this._htmlBrowser = hTMLBrowser;
        this._baseURL = uRL;
        try {
            this._indexURL = new URL(uRL, string);
        }
        catch (Exception exception) {
            System.out.println("invalid index file :  " + string);
            this._indexURL = null;
        }
        this._quickTour = true;
        this._context = null;
        this.createSearchDialogUI();
    }

    public void createSearchDialogUI() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        this.setTitle(resourceBundle.getString("searchwin.title"));
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        EwtContainer ewtContainer = new EwtContainer();
        this.add((Component)ewtContainer, "Center");
        ewtContainer.setLayout(new BorderLayout(5, 10));
        ewtContainer.setBorder(new MarginBorder(10, 10, 10, 10));
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(new BorderLayout());
        ewtContainer.add((Component)lWComponent, "South");
        this._status = new LWLabel("");
        lWComponent.add((Component)this._status, "Center");
        this._openButton = new LWButton(resourceBundle.getString("searchwin.openbutton"));
        this._openButton.addActionListener(this);
        this._openButton.setBackground(Color.lightGray);
        lWComponent.add((Component)this._openButton, "East");
        LWComponent lWComponent2 = new LWComponent();
        lWComponent2.setLayout(new BorderLayout(0, 5));
        ewtContainer.add((Component)lWComponent2, "Center");
        this._resDataSource = new ResultsDataSource();
        this._list = new LWDataSourceList(this._resDataSource, 10, false);
        this._list.setBackground(Color.white);
        this._list.addActionListener(this);
        this._list.addItemListener(this);
        lWComponent2.add((Component)this._list, "Center");
        LWLabel lWLabel = new LWLabel(resourceBundle.getString("searchwin.selectinfo"));
        lWComponent2.add((Component)lWLabel, "North");
        LWComponent lWComponent3 = new LWComponent();
        lWComponent3.setLayout(new BorderLayout(5, 0));
        ewtContainer.add((Component)lWComponent3, "North");
        lWLabel = new LWLabel(resourceBundle.getString("searchwin.fieldlabel"));
        lWComponent3.add((Component)lWLabel, "North");
        LWComponent lWComponent4 = new LWComponent();
        GridBagLayout gridBagLayout = new GridBagLayout();
        lWComponent4.setLayout(gridBagLayout);
        lWComponent3.add((Component)lWComponent4, "Center");
        LWComponent lWComponent5 = new LWComponent();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        lWComponent5.setLayout(gridBagLayout2);
        lWComponent3.add((Component)lWComponent5, "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        this._searchField = new LWTextField();
        gridBagLayout.setConstraints(this._searchField, gridBagConstraints);
        lWComponent4.add(this._searchField);
        this._searchField.addTextListener(this);
        gridBagConstraints.fill = 0;
        this._caseCheck = new LWCheckbox(resourceBundle.getString("searchwin.casesensitive"));
        gridBagLayout.setConstraints(this._caseCheck, gridBagConstraints);
        lWComponent4.add(this._caseCheck);
        lWLabel = new LWLabel(resourceBundle.getString("searchwin.searchfor"));
        gridBagLayout.setConstraints(lWLabel, gridBagConstraints);
        lWComponent4.add(lWLabel);
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.left = 8;
        LWCheckboxGroup lWCheckboxGroup = new LWCheckboxGroup();
        this._allRadio = new LWCheckbox(resourceBundle.getString("searchwin.allwords"), lWCheckboxGroup, true);
        gridBagLayout.setConstraints(this._allRadio, gridBagConstraints);
        lWComponent4.add(this._allRadio);
        gridBagConstraints.insets.top = 0;
        this._anyRadio = new LWCheckbox(resourceBundle.getString("searchwin.anyword"), lWCheckboxGroup, false);
        gridBagLayout.setConstraints(this._anyRadio, gridBagConstraints);
        lWComponent4.add(this._anyRadio);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.fill = 1;
        this._searchButton = new LWButton(resourceBundle.getString("searchwin.search"));
        this._searchButton.addActionListener(this);
        this._searchButton.setBackground(Color.lightGray);
        gridBagLayout2.setConstraints(this._searchButton, gridBagConstraints);
        lWComponent5.add(this._searchButton);
        this._helpButton = new LWButton(resourceBundle.getString("searchwin.help"));
        this._helpButton.setBackground(Color.lightGray);
        gridBagLayout2.setConstraints(this._helpButton, gridBagConstraints);
        lWComponent5.add(this._helpButton);
        this._helpButton.setEnabled(false);
        this._closeButton = new LWButton(resourceBundle.getString("searchwin.close"));
        this._closeButton.setBackground(Color.lightGray);
        gridBagLayout2.setConstraints(this._closeButton, gridBagConstraints);
        this._closeButton.addActionListener(this);
        lWComponent5.add(this._closeButton);
        LWComponent lWComponent6 = new LWComponent();
        LWComponent lWComponent7 = new LWComponent();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(lWComponent6, gridBagConstraints);
        lWComponent4.add(lWComponent6);
        gridBagLayout2.setConstraints(lWComponent7, gridBagConstraints);
        lWComponent5.add(lWComponent7);
        this.validate();
        this.pack();
        this.pack();
        this._results = new Vector();
        this._lastSearchText = new String("");
        this._lastSearchAllItems = true;
        this._lastSearchCaseSensitive = false;
        this._inProgress = resourceBundle.getString("searchwin.inprogress");
        this._failed = resourceBundle.getString("searchwin.searchfailed");
        this._filenotfound = resourceBundle.getString("searchwin.filenotfound");
        this._foundtopics = resourceBundle.getString("searchwin.foundtopics");
        this._searching = resourceBundle.getString("searchwin.searching");
        this._searchField.addKeyListener(new 2());
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("oracle.help.resource.Defaults");
        String string = resourceBundle2.getString("searchwin.cancelDialog.width");
        String string2 = resourceBundle2.getString("searchwin.cancelDialog.height");
        this._dialogWidth = Integer.parseInt(string);
        this._dialogHeight = Integer.parseInt(string2);
        this.enableEvents(64L);
    }

    public static Dimension getInitialSize() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults");
        String string = resourceBundle.getString("searchwin.width");
        String string2 = resourceBundle.getString("searchwin.height");
        return new Dimension(Integer.parseInt(string), Integer.parseInt(string2));
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this._searchField.getText().length() == 0) {
                this._searchButton.setEnabled(false);
            } else {
                this._searchButton.setEnabled(true);
            }
            if (this._list.getItemCount() == 0) {
                this._openButton.setEnabled(false);
            } else {
                this._openButton.setEnabled(true);
            }
            if (this._lastSearchText != null) {
                this._searchField.setText(this._lastSearchText);
                this._caseCheck.setState(this._lastSearchCaseSensitive);
                this._allRadio.setState(this._lastSearchAllItems);
                this._anyRadio.setState(!this._lastSearchAllItems);
            }
            this._searchField.requestFocus();
        }
        super.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._searchButton) {
            this._lastSearchText = this._searchField.getText();
            this._lastSearchCaseSensitive = this._caseCheck.getState();
            this._lastSearchAllItems = this._allRadio.getState();
            if (this._searchField.getText().equalsIgnoreCase("komodo easter egg")) {
                SpecialAboutBox specialAboutBox = SpecialAboutBox.getSpecialAboutBox(this);
                Point point = this.getLocation();
                ((Component)specialAboutBox).setLocation(point.x + 24, point.y + 24);
                specialAboutBox.setVisible(true);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this._searchField.getText());
            int n = stringTokenizer.countTokens();
            if (n == 0) {
                return;
            }
            this._words = new String[n];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this._words[n++] = stringTokenizer.nextToken();
            }
            this._hitCount = 0;
            this._resDataSource.reset();
            this._results.removeAllElements();
            this._openButton.setEnabled(false);
            ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
            this._status.setText(this._inProgress);
            this._status.invalidate();
            this.spawnSearchThread();
            ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
            if (this._results.size() == 0) {
                this._status.setText(this._failed);
                return;
            }
            int n2 = this._foundtopics.indexOf("%d");
            this._status.setText(String.valueOf(this._foundtopics.substring(0, n2)) + this._results.size() + this._foundtopics.substring(n2 + 2));
            return;
        }
        if (actionEvent.getSource() == this._openButton || actionEvent.getSource() == this._list) {
            int n = this._list.getSelectedIndex();
            if (n != -1) {
                try {
                    ResultItem resultItem = (ResultItem)this._results.elementAt(n);
                    if (this._quickTour) {
                        URL uRL = new URL(this._baseURL, resultItem.fileName);
                        this._htmlBrowser.setURL(uRL);
                        return;
                    }
                    URL uRL = new URL(String.valueOf(resultItem.book.getBaseURL()) + resultItem.fileName);
                    this._context.displayURL(resultItem.book, uRL);
                    this._context.refreshNavigator();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        } else if (actionEvent.getSource() == this._closeButton) {
            this.setVisible(false);
        }
    }

    public void run() {
        this.searchAll(this._words, this._allRadio.getState());
        if (this._cancelDialog != null) {
            this._cancelDialog.dispose();
            this._cancelDialog = null;
        }
        this._searchThread = null;
    }

    private void spawnSearchThread() {
        this._curSearchObject = null;
        this._searchThread = new Thread((Runnable)this, "Search Thread");
        this._searchThread.setPriority(1);
        this._searchThread.start();
        this._cancelDialog = new CancelDialog((Frame)this, this._searching, null, true);
        ((Component)this._cancelDialog).setSize(this._dialogWidth, this._dialogHeight);
        Point point = this.getLocation();
        ((Component)this._cancelDialog).setLocation(point.x + 80, point.y + 80);
        if (this._searchThread != null) {
            this._cancelDialog.show();
        }
        this._cancelDialog = null;
        if (this._searchThread != null && this._curSearchObject != null) {
            this._curSearchObject.setStopSearch();
        }
        this.requestFocus();
        this.toFront();
    }

    private void search(HelpBook helpBook, String[] stringArray, boolean bl) {
        try {
            QueryObject queryObject = null;
            TreeRoot treeRoot = null;
            if (this._quickTour) {
                if (this._indexURL != null) {
                    queryObject = QueryObject.getQueryObject(this._indexURL);
                }
            } else {
                queryObject = (QueryObject)helpBook.getQueryObject();
                treeRoot = (TreeRoot)helpBook.getHhcTree();
            }
            this._curSearchObject = queryObject;
            if (queryObject != null) {
                queryObject.setCaseSensitive(this._caseCheck.getState());
                Enumeration enumeration = queryObject.executeQuery(stringArray, bl);
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        TreeNode treeNode;
                        QueryResultInterface queryResultInterface = (QueryResultInterface)enumeration.nextElement();
                        String string = null;
                        if (treeRoot != null && (treeNode = treeRoot.get(queryResultInterface.getFilePath())) != null) {
                            string = treeNode.getLabel();
                        }
                        if (string == null) {
                            string = queryResultInterface.getTitle();
                        }
                        if (string == null || string.length() == 0 || string != null && string.length() > 1 && Character.isWhitespace(string.charAt(0))) {
                            string = _untitled;
                        }
                        this._resDataSource.addItem(string);
                        ResultItem resultItem = new ResultItem(helpBook, queryResultInterface.getFilePath());
                        this._results.addElement(resultItem);
                        ++this._hitCount;
                    }
                    this._resDataSource.end();
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void searchAll(String[] stringArray, boolean bl) {
        if (!this._quickTour) {
            HelpBook[] helpBookArray = this._context.getLibrary().getVisibleBooks();
            int n = 0;
            while (n < helpBookArray.length) {
                this.search(helpBookArray[n], stringArray, bl);
                ++n;
            }
            return;
        }
        this.search(null, stringArray, bl);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this._searchField.getText().length() == 0) {
            if (this._searchButton.isEnabled()) {
                this._searchButton.setEnabled(false);
                return;
            }
        } else if (!this._searchButton.isEnabled()) {
            this._searchButton.setEnabled(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this._openButton.setEnabled(this._list.getSelectedIndex() != -1);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 200) {
            this._searchField.requestFocus();
            return;
        }
        if (windowEvent.getID() == 205) {
            this._searchField.requestFocus();
            return;
        }
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
        }
    }

    private final class 2
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                SearchDialog.this.actionPerformed(new ActionEvent(SearchDialog.this._searchButton, 0, ""));
            }
        }

        /* synthetic */ 2() {
        }
    }

    private class ResultItem {
        public HelpBook book;
        public String fileName;

        public ResultItem(HelpBook helpBook, String string) {
            SearchDialog.this = SearchDialog.this;
            this.book = helpBook;
            this.fileName = string;
        }
    }

    private class ResultsDataSource
    implements OneDDataSource {
        private int _count = 0;
        private String[] _array = new String[20];
        private ListenerManager _manager;
        private final int INCREMENT_SIZE = 20;

        public ResultsDataSource() {
            SearchDialog.this = SearchDialog.this;
        }

        public void addItem(String string) {
            if (this._count == this._array.length) {
                String[] stringArray = new String[this._array.length + 20];
                System.arraycopy(this._array, 0, stringArray, 0, this._array.length);
                this._array = stringArray;
            }
            this._array[this._count] = string;
            ++this._count;
            if (this._count % 20 == 0) {
                this._dispatchEvent(2001, this._count - 20, this._count);
            }
        }

        public void reset() {
            int n = this._count;
            this._count = 0;
            if (n > 0) {
                this._dispatchEvent(2002, 0, n);
            }
            if (n > 200) {
                this._array = new String[20];
            }
        }

        public void end() {
            if (this._count % 20 != 0) {
                if (this._count > 20) {
                    this._dispatchEvent(2001, this._count - 20, this._count);
                    return;
                }
                this._dispatchEvent(2001, 0, this._count);
            }
        }

        public int getItemCount() {
            return this._count;
        }

        public Object getData(int n) {
            if (n > this._count) {
                return null;
            }
            return this._array[n];
        }

        public void setData(int n, Object object) {
        }

        public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
            if (this._manager == null) {
                this._manager = new ListenerManager();
            }
            this._manager.addListener(oneDDataSourceListener);
        }

        public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
            this._manager.removeListener(oneDDataSourceListener);
        }

        private void _dispatchEvent(int n, int n2, int n3) {
            Enumeration enumeration;
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, n, n2, n3);
            if (this._manager != null && (enumeration = this._manager.getListeners()) != null) {
                while (enumeration.hasMoreElements()) {
                    OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
                    if (n == 2001) {
                        oneDDataSourceListener.itemsAdded(oneDDataSourceEvent);
                        continue;
                    }
                    oneDDataSourceListener.itemsRemoved(oneDDataSourceEvent);
                }
            }
        }
    }
}

