/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabBar.TabStyle;

public class ChamferedTabStyle
extends TabStyle {
    private final double _OVERLAP_CONSTANT = 0.5773672055427251;
    private static ChamferedTabStyle _sStyle;

    public static TabStyle getTabStyle() {
        if (_sStyle == null) {
            _sStyle = new ChamferedTabStyle();
        }
        return _sStyle;
    }

    protected ChamferedTabStyle() {
    }

    public int getPreferredOverlap(TabBarItem tabBarItem) {
        return (int)((double)tabBarItem.getSize().height * 0.5773672055427251);
    }

    public Dimension getPreferredSize(TabBarItem tabBarItem) {
        Dimension dimension = super.getPreferredSize(tabBarItem);
        int n = this.getPreferredOverlap(tabBarItem);
        if (n == 0) {
            n = (int)((double)dimension.height * 0.5773672055427251);
        }
        dimension.width += 2 * n;
        return dimension;
    }

    protected void drawBorder(Graphics graphics, TabBarItem tabBarItem) {
        Color color;
        int n;
        int n2;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        TabBar tabBar = tabBarItem.getParent();
        int n3 = tabBar.getOrientation();
        int n4 = this.getPreferredOverlap(tabBarItem);
        Rectangle rectangle = tabBarItem.getBounds();
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = rectangle.x + rectangle.width;
        int n7 = rectangle.x;
        if (n3 == 1) {
            n2 = 1;
            n = rectangle.y;
        } else {
            n2 = -1;
            n = n5;
            n5 = rectangle.y;
        }
        if (tabBarItem.isSelected()) {
            color = tabBar.getSelectedBackground();
            int n8 = this.getAllowedHorizGrowth(tabBar);
            n7 -= n8;
            n6 += n8;
        } else {
            color = tabBar.getItemBackground();
            n5 -= this.getVerticalGrowth() * n2;
        }
        nArray[0] = n7;
        nArray2[0] = n - n2;
        nArray[1] = n7 + n4;
        nArray2[1] = n5;
        nArray[2] = n6 - n4;
        nArray2[2] = n5;
        nArray[3] = n6;
        nArray2[3] = n - n2;
        nArray[4] = n7;
        nArray[4] = n - n2;
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, 4);
        Color color2 = ColorUtils.lighterShadeColor(color);
        Color color3 = ColorUtils.darkerShadeColor(color);
        Color color4 = n3 == 1 ? color3 : color2;
        graphics.setColor(color2);
        graphics.drawLine(n7 + 1, n, n7 + n4 + 1, n5);
        graphics.setColor(color4);
        graphics.drawLine(n7 + n4 + 1, n5 - n2, n6 - n4, n5 - n2);
        graphics.setColor(color3);
        graphics.drawLine(n6 - 2, n, n6 - n4 - 1, n5);
        graphics.setColor(Color.black);
        graphics.drawLine(n7, n, n7 + n4, n5);
        graphics.drawLine(n7 + n4 + 1, n5, n6 - n4, n5);
        graphics.drawLine(n6 - 1, n, n6 - n4, n5);
    }
}

