/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEAlarmFactory;
import com.lucent.ra.nms.backend.LECmdFailedFactory;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.backend.LEDebugFactory;
import com.lucent.ra.nms.backend.LEDeltaFactory;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEPortIOFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEAboutDialog;
import com.lucent.ra.nms.ui.LEActionClient;
import com.lucent.ra.nms.ui.LEActionDialog;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEClipboard;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEConnectDialog;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEHelpBar;
import com.lucent.ra.nms.ui.LELEDs;
import com.lucent.ra.nms.ui.LELoginClient;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LENotesView;
import com.lucent.ra.nms.ui.LEPathEvent;
import com.lucent.ra.nms.ui.LEPathListener;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LESplitterPanel;
import com.lucent.ra.nms.ui.LEStatusBar;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LETreeEvent;
import com.lucent.ra.nms.ui.LETreeItem;
import com.lucent.ra.nms.ui.LETreeListener;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelp;
import com.lucent.ra.nms.util.LEProperties;
import com.lucent.ra.nms.util.LEResource;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewEvent;
import com.lucent.ra.nms.view.LEViewListener;
import com.lucent.ra.nms.view.LEViewPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.help.Book;
import oracle.help.Help;

public class LEConsole
extends Frame
implements LEActionClient,
LELoginClient,
LETreeListener,
LEMLListener,
LEPathListener,
LEViewListener,
ActionListener,
WindowListener,
Runnable {
    public static final String ACTION_ABOUT = "about";
    public static final String ACTION_CONNECT = "connect";
    public static final String ACTION_DISCONNECT = "disconnect";
    public static final String ACTION_EXIT = "exit";
    public static final String ACTION_HELP_CONTENTS = "help_contents";
    public static final String ACTION_HELP_CURRENT = "help_current";
    public static final String ACTION_HELP_SEARCH = "help_search";
    public static final String ACTION_REBOOT = "reboot";
    public static final String ACTION_RECONNECT = "reconnect";
    public static final String ACTION_RELNOTES = "relnotes";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_SUBWINDOW = "SUB";
    public static final String ACTION_UPDATE_START = "update_start";
    public static final String ACTION_UPDATE_END = "update_end";
    public static final String PROPERTIES_FILE = "pmvprops.cfg";
    public static final String RESOURCE_LOC = "resources/PMVision/pmvision";
    static final String PROP_MAIN_X = "main_x";
    static final String PROP_MAIN_Y = "main_y";
    static final String PROP_MAIN_W = "main_w";
    static final String PROP_MAIN_H = "main_h";
    static final String PROP_TREE_W = "tree_w";
    static final String PROP_GRID_H = "grid_h";
    static final String PROP_RN_X = "rn_x";
    static final String PROP_RN_Y = "rn_y";
    static final String PROP_RN_W = "rn_w";
    static final String PROP_RN_H = "rn_h";
    static final String PROP_PM_TREE = "tree_pm";
    static final String PROP_MONITOR_TREE = "tree_pmmonitor";
    static final String PROP_MONITOR_L2TP = "tree_pml2tp";
    static final String PROP_GRAPH_TREE = "tree_pmgraph";
    static final String PROP_DIAGNOSE_TREE = "tree_pmdiagnose";
    static final String PROP_MAINTAIN_TREE = "tree_pmmaintain";
    static final String PROP_CONFIG_TREE = "tree_pmconfigure";
    static final String PROP_ITS_TREE = "tree_its";
    static final String PROP_ITS_MONITOR_TREE = "tree_itsmonitor";
    static final String PROP_ITS_MAINTAIN_TREE = "tree_itsmaintain";
    static final String PROP_ITS_CONFIG_TREE = "tree_itsconfigure";
    static LEConsole s_console;
    static Image s_main32;
    static Image s_main16;
    static String s_path;
    MenuBar m_menubar;
    Menu m_fileMenu;
    Menu m_editMenu;
    Menu m_pmMenu;
    Menu m_windows;
    Menu m_helpMenu;
    MenuItem m_disconn;
    MenuItem m_remove;
    MenuItem m_reboot;
    MenuItem m_recon;
    LEStatusBar m_statusbar;
    LEHelpBar m_helpbar;
    LEBorderPanel m_work;
    LEBorderPanel m_treePanel;
    LEControlTree m_tree;
    LEPMGrid m_grid;
    LEPMView m_view;
    LEViewPanel m_vp;
    LEClipboard m_cb;
    LEHelp m_helprsrc;
    Book m_book;
    Book m_itsbook;
    Help m_help;
    Button m_dummy;
    LEPortMaster[] m_selPMs = new LEPortMaster[0];
    String m_selPlatform = "PortMaster";
    String m_hostname;
    String m_password;
    String m_username;
    LEPortMaster m_pm;
    Rectangle m_bounds;
    Rectangle m_rnBounds;
    int m_treeWidth = 150;
    int m_gridHeight = 150;
    Hashtable m_treeSettings = new Hashtable();
    LEVector m_subwins = new LEVector();
    LEAMManager_RI m_amm;
    LEConnectionManager m_cm;
    LEAMRouter_RI m_router;
    LEDataSpecFactory m_specFactory;
    LEViewFactory m_viewFactory;
    LENotesView m_notes;
    boolean m_shutdown;
    LEStatusDialog m_statDialog;
    static /* synthetic */ Class class$PMVision;

    public static void Display() {
        if (s_console == null) {
            new LEConsole();
        }
    }

    public static LEConsole GetConsole() {
        return s_console;
    }

    public LEConsole() {
        super(LEAppInfo.getAppTitle());
        LEUiUtils.SetBaseFrame(this);
        LEColor.CheckColorFlags();
        LEProperties.SetPropertyFile(LEAppInfo.getUserAppDirPath(PROPERTIES_FILE));
        this.loadProperties();
        this.initializeSingletons();
        s_console = this;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(LEColor.getBackground());
        PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(RESOURCE_LOC);
        this.m_helprsrc = new LEHelp(propertyResourceBundle);
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_statusbar = new LEStatusBar(2, LEStatusManager.GetManager());
        this.m_statusbar.setStatusText(LEAppInfo.getAppTitle());
        panel.add(this.m_statusbar);
        this.m_helpbar = new LEHelpBar(2);
        panel.add(this.m_helpbar);
        this.add("South", panel);
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        this.m_treePanel = new LEBorderPanel(2);
        this.m_treePanel.setLayout(new BorderLayout(0, 0));
        this.m_treePanel.setInsets(1, 1, 1, 1);
        this.m_tree = new LEControlTree(this.m_treeSettings);
        this.m_tree.addListener(this);
        this.m_treePanel.add("Center", this.m_tree);
        lESplitterPanel.addColumn(this.m_treeWidth);
        lESplitterPanel.addComponent((Component)this.m_treePanel, 0);
        this.m_grid = new LEPMGrid();
        this.m_grid.addListener(this);
        lESplitterPanel.addColumn(0);
        new LEBorderPanel(2);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_grid);
        lESplitterPanel.addComponent((Component)lEScrollPanel, this.m_gridHeight);
        this.m_work = new LEBorderPanel(2);
        this.m_work.setInsets(0, 0, 0, 0);
        this.m_work.setLayout(new BorderLayout(0, 0));
        this.m_vp = new LEViewPanel(this.m_tree);
        this.m_work.add("Center", this.m_vp);
        lESplitterPanel.addComponent((Component)this.m_work, 0);
        this.add("Center", lESplitterPanel);
        this.m_cb.watchContainer(this.m_work);
        this.m_dummy = new Button();
        this.m_dummy.addActionListener(this);
        ((Component)this).setVisible(true);
        String string = LEAppInfo.getFlag("-g");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                LEDebug.getLog().setLogLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, "Bad argument for log level: " + string);
            }
        }
        try {
            this.m_help = new Help();
            this.m_book = Help.createBook((Class)(class$PMVision != null ? class$PMVision : (class$PMVision = LEConsole.class$("PMVision"))), (String)".", (String)"Amberhlp", (String)"PMVision Help");
            if (this.m_book != null) {
                this.m_help.addBook(this.m_book);
            }
            this.m_itsbook = Help.createBook((Class)(class$PMVision != null ? class$PMVision : (class$PMVision = LEConsole.class$("PMVision"))), (String)".", (String)"itshlp", (String)"Gateway Help");
            if (this.m_itsbook != null) {
                this.m_help.addBook(this.m_itsbook);
                return;
            }
        }
        catch (Throwable throwable) {
            LEDebug.getLog().logln(20, throwable);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
    }

    public void addNotify() {
        Object object;
        Object object2;
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.m_bounds != null) {
            n = this.m_bounds.x;
            n2 = this.m_bounds.y;
            n3 = this.m_bounds.width;
            n4 = this.m_bounds.height;
        }
        if (n3 == 0 || n4 == 0) {
            object2 = Toolkit.getDefaultToolkit().getScreenSize();
            n3 = ((Dimension)object2).width;
            n4 = ((Dimension)object2).height - 30;
        }
        ((Component)this).setLocation(n, n2);
        ((Component)this).setSize(n3, n4);
        LELEDs.Initialize();
        try {
            s_main32 = LEResource.GetImage("lucent_32.gif");
            s_main16 = LEResource.GetImage("lucent_16.gif");
            if (s_main32 != null) {
                this.setIconImage(s_main32);
            }
            object2 = LEResource.GetImage("tree-col.gif");
            object = LEResource.GetImage("tree-exp.gif");
            if (object2 instanceof Image && object instanceof Image) {
                this.m_tree.setDefaultImages((Image)object2, (Image)object);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        object2 = LEAppInfo.getFlag("-h");
        object = LEAppInfo.getFlag("-u");
        String string = LEAppInfo.getFlag("-p");
        if (object2 != null && string != null) {
            if (object == null) {
                object = "!root";
            }
            this.loginTo((String)object2, (String)object, string);
        } else if (object2 != null) {
            if (object == null) {
                object = "!root";
            }
            this.addSubwindow(LEConnectDialog.Show(this, this, (String)object2, (String)object, string));
        }
        Vector vector = this.m_tree.getRoots();
        if (vector.size() > 0) {
            this.m_tree.select((LETreeItem)vector.elementAt(0), true);
        }
    }

    public void lock() {
        this.m_fileMenu.setEnabled(false);
        this.m_editMenu.setEnabled(false);
        this.m_pmMenu.setEnabled(false);
        this.m_windows.setEnabled(false);
        this.m_helpMenu.setEnabled(false);
        this.m_tree.setEnabled(false);
        this.m_grid.setEnabled(false);
        this.m_vp.lock();
    }

    public void unlock() {
        this.m_fileMenu.setEnabled(true);
        this.m_editMenu.setEnabled(true);
        this.m_pmMenu.setEnabled(true);
        this.m_windows.setEnabled(true);
        this.m_helpMenu.setEnabled(true);
        this.m_tree.setEnabled(true);
        this.m_grid.setEnabled(true);
        this.m_vp.unlock();
    }

    public void setBusy() {
        this.lock();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setIdle() {
        this.unlock();
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this) {
            this.goodbye();
            return;
        }
        this.removeSubwindow(window);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.removeSubwindow(windowEvent.getWindow());
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_ABOUT)) {
            LEAboutDialog.Show(this);
            return;
        }
        if (string.equals(ACTION_CONNECT)) {
            this.addSubwindow(LEConnectDialog.Show(this, this));
            return;
        }
        if (string.equals(ACTION_DISCONNECT)) {
            this.m_grid.deleteSelectedPMs();
            return;
        }
        if (string.equals(ACTION_EXIT)) {
            this.goodbye();
            return;
        }
        if (string.equals(ACTION_HELP_CONTENTS)) {
            if (this.m_help == null) return;
            this.m_help.showContents();
            return;
        }
        if (string.equals(ACTION_HELP_CURRENT)) {
            if (this.m_help == null) return;
            String string2 = this.getHelpTopic();
            try {
                if (string2 == null) {
                    this.m_help.showContents();
                    return;
                }
                LEVector lEVector = this.m_tree.getContext();
                if (lEVector == null || lEVector.size() <= 0) return;
                String string3 = (String)lEVector.elementAt(0);
                if (string3.equals("pm") && this.m_book != null) {
                    this.m_help.showTopic(this.m_book, string2);
                    return;
                }
                if (!string3.equals("its") || this.m_itsbook == null) return;
                this.m_help.showTopic(this.m_itsbook, string2);
                return;
            }
            catch (Exception exception) {
                String string4 = string2 == null ? "Error in help subsystem" : "No help found for topic: " + string2;
                new LEErrorDialog((Frame)this, string4);
                return;
            }
        } else {
            if (string.equals(ACTION_HELP_SEARCH)) {
                if (this.m_help == null) return;
                this.m_help.showSearch();
                return;
            }
            if (string.equals(ACTION_REBOOT)) {
                this.m_grid.rebootSelectedPMs();
                return;
            }
            if (string.equals(ACTION_RECONNECT)) {
                this.m_grid.reconnectSelectedPMs();
                return;
            }
            if (string.equals(ACTION_RELNOTES)) {
                if (this.m_notes == null) {
                    this.m_notes = new LENotesView(this.m_rnBounds);
                    this.m_notes.loadReleaseNotes();
                    return;
                }
                ((Component)this.m_notes).setVisible(true);
                this.m_notes.show();
                return;
            }
            if (string.equals(ACTION_REMOVE)) {
                this.m_grid.removeSelectedPMs();
                return;
            }
            if (string.equals(ACTION_UPDATE_START)) {
                this.actionUpdateStart();
                return;
            }
            if (string.equals(ACTION_UPDATE_END)) {
                this.actionUpdateEnd();
                return;
            }
            if (string.startsWith(ACTION_SUBWINDOW)) {
                try {
                    int n = Integer.parseInt(string.substring(3));
                    Window window = (Window)this.m_subwins.elementAt(n);
                    window.toFront();
                    return;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    return;
                }
            }
            LEDebug.getLog().logln(20, "Unknown LEConsole Action: " + string);
        }
    }

    public void loginTo(String string, String string2, String string3) {
        Object object;
        LEPortMaster lEPortMaster;
        if (this.m_grid != null && (lEPortMaster = this.m_grid.getPortMaster((String)(object = LEResourceID.CreatePM_ID(string, string2)))) != null) {
            if (lEPortMaster.isConnected()) {
                String string4 = String.valueOf(LEAppInfo.getAppName()) + " is already connected to " + string;
                new LEErrorDialog((Frame)this, string4);
                string = null;
            } else {
                LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEPortMaster.getConnectionFacade();
                if (string2.equals(lEPMConnectionFacade.getUsername()) && string3.equals(lEPMConnectionFacade.getPassword())) {
                    new LEReconnectThread(lEPortMaster);
                    string = null;
                } else {
                    this.m_grid.removePM(lEPortMaster);
                }
            }
        }
        if (string != null) {
            this.m_hostname = string;
            this.m_password = string3;
            this.m_username = string2;
            object = new LEActionDialog((Frame)this, "Connecting", this, LEStatusManager.GetManager());
            ((Component)object).setVisible(true);
            new Thread((Runnable)object).start();
        }
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        block5: {
            this.setBusy();
            try {
                LEStatusBar lEStatusBar = lEActionDialog.getStatusBar();
                lEStatusBar.setStatusText("Connecting to " + this.m_hostname + "...");
                this.m_pm = LEPMFactory.GetFromPM(this.m_cm, this.m_hostname, this.m_username, this.m_password);
                if (this.m_hostname == null) {
                    this.m_pm.disconnect();
                    this.m_pm = null;
                    return;
                }
                if (!this.m_pm.isConnected()) {
                    new LEErrorDialog((Frame)this, new String("Failed to connect to " + this.m_hostname));
                    this.m_pm = null;
                    return;
                }
            }
            catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
                this.m_pm = null;
                new LEErrorDialog((Frame)this, new String("Invalid password!"));
                return;
            }
            catch (Exception exception) {
                this.m_pm = null;
                LEDebug.getLog().logln(20, exception);
                if (this.m_hostname == null) break block5;
                new LEErrorDialog((Frame)this, exception.getMessage());
            }
        }
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (this.m_pm != null) {
            this.m_grid.addPortMaster(this.m_pm);
        }
        this.m_statusbar.setStatusText("");
        this.actionCancel(lEActionDialog);
    }

    public synchronized void actionCancel(LEActionDialog lEActionDialog) {
        this.m_pm = null;
        this.m_hostname = null;
        this.m_password = null;
        this.setIdle();
    }

    public void onLETreeEvent(LETreeEvent lETreeEvent) {
        if (lETreeEvent.m_id == 1) {
            LETreeItem lETreeItem = this.m_tree.getSelectedRoot();
            if (!this.m_selPlatform.equals((String)lETreeItem.m_object)) {
                this.m_selPlatform = (String)lETreeItem.m_object;
                this.m_selPMs = this.m_grid.getSelected(this.m_selPlatform);
            }
            this.updateView();
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 3) {
            this.m_selPMs = this.m_grid.getSelected(this.m_selPlatform);
            this.updateSelection();
            if (this.m_selPMs.length > 0) {
                this.m_disconn.setEnabled(true);
                this.m_remove.setEnabled(true);
                this.m_reboot.setEnabled(true);
                this.m_recon.setEnabled(true);
                return;
            }
            this.m_disconn.setEnabled(false);
            this.m_remove.setEnabled(false);
            this.m_reboot.setEnabled(false);
            this.m_recon.setEnabled(false);
        }
    }

    public void onLEPathEvent(LEPathEvent lEPathEvent) {
        LETreeItem lETreeItem = (LETreeItem)lEPathEvent.getItem().getData();
        this.m_tree.select(lETreeItem, true);
    }

    public void onLEViewEvent(LEViewEvent lEViewEvent) {
        if (this.m_shutdown) {
            return;
        }
        int n = lEViewEvent.getId();
        if (n == 1) {
            LEConfig lEConfig = null;
            if (lEViewEvent instanceof LEConfigViewEvent) {
                lEConfig = ((LEConfigViewEvent)lEViewEvent).getConfig();
            }
            String string = (String)lEViewEvent.getData();
            this.m_tree.selectChild(lEConfig, string, string, true);
            return;
        }
        if (n == 2) {
            this.m_tree.selectParent((String)lEViewEvent.getData(), true);
            return;
        }
        if (n == 3) {
            this.m_tree.selectItem((LEVector)lEViewEvent.getData(), true);
            return;
        }
        if (n == 8) {
            this.lock();
            return;
        }
        if (n == 9) {
            this.unlock();
            return;
        }
        if (n == 10) {
            Object object = lEViewEvent.getData();
            if (object instanceof PMVDetailWindowInfo) {
                PMVDetailWindowInfo pMVDetailWindowInfo = (PMVDetailWindowInfo)object;
                this.addSubwindow(pMVDetailWindowInfo.getWindow(), pMVDetailWindowInfo.getPortMaster(), pMVDetailWindowInfo.getBoard());
                return;
            }
            this.addSubwindow((Window)object, null, null);
        }
    }

    public void addSubwindow(Window window, LEPortMaster lEPortMaster, String string) {
        window.addWindowListener(this);
        this.m_subwins.addElement(window);
        this.fillWindowsMenu();
        Frame frame = LEUiUtils.getFrame(this.m_vp.getMain());
        if (window == frame) {
            this.m_view = null;
            this.m_vp.removeView();
            this.m_view = this.m_viewFactory.getView(this.m_tree, this.m_selPMs, lEPortMaster, string);
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_END);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
        }
    }

    public void addSubwindow(Window window) {
        this.addSubwindow(window, null, null);
    }

    public void removeSubwindow(Window window) {
        window.removeWindowListener(this);
        if (this.m_subwins.removeElement(window)) {
            this.fillWindowsMenu();
        }
    }

    public void updateSelection() {
        if (this.m_view != null) {
            this.setBusy();
            try {
                this.m_statusbar.setStatusText("Building display...");
                this.m_view.setSelection(this.m_selPMs);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_statusbar.setStatusText(null);
            this.setIdle();
            return;
        }
        this.updateView();
    }

    public void updateView() {
        try {
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_START);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.actionUpdateStart();
            return;
        }
    }

    public void actionUpdateStart() {
        if (this.m_shutdown) {
            return;
        }
        this.setBusy();
        try {
            Thread.currentThread();
            Thread.yield();
            if (this.m_view != null) {
                this.m_view.deleteListener(this);
            }
            this.m_vp.reset();
            this.m_view = null;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.m_view = null;
        }
        Thread thread = new Thread(this);
        thread.setName("Console Update");
        thread.start();
    }

    public void run() {
        if (this.m_shutdown) {
            try {
                LEStatusManager.SetStatus("Saving properties");
                this.saveProperties();
                this.closeWindows();
                this.m_grid.shutdown();
                ((Component)this.m_statDialog).setVisible(false);
                ((Component)this).setVisible(false);
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            System.exit(0);
            return;
        }
        try {
            this.m_view = this.m_viewFactory.getView(this.m_tree, this.m_selPMs);
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_END);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.actionUpdateEnd();
            return;
        }
    }

    public void actionUpdateEnd() {
        try {
            Thread.currentThread();
            Thread.yield();
            if (this.m_view != null) {
                this.m_view.addListener(this);
                this.m_vp.setView(this.m_view);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_vp.invalidate();
        this.m_vp.validate();
        this.m_statusbar.setStatusText(null);
        this.setIdle();
    }

    String getHelpTopic() {
        String string = null;
        string = this.m_helprsrc.getHelpTag(this.m_tree.getContext());
        return string;
    }

    MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = this.m_fileMenu = new Menu("File");
        MenuItem menuItem = new MenuItem("Exit");
        menuItem.setActionCommand(ACTION_EXIT);
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuBar.add(menu);
        Menu menu2 = this.m_editMenu = new Menu("Edit");
        MenuItem menuItem2 = new MenuItem("Cut");
        MenuItem menuItem3 = new MenuItem("Copy");
        MenuItem menuItem4 = new MenuItem("Paste");
        MenuItem menuItem5 = new MenuItem("Delete");
        menu2.add(menuItem2);
        menu2.add(menuItem3);
        menu2.add(menuItem4);
        menu2.add(menuItem5);
        this.m_cb = LEClipboard.GetClipboard();
        this.m_cb.setMenuItems(menuItem2, menuItem3, menuItem4, menuItem5);
        this.m_cb.reset();
        menuBar.add(menu2);
        menu = this.m_pmMenu = new Menu("Device");
        menuItem = new MenuItem("Connect...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_CONNECT);
        menuItem.addActionListener(this);
        this.m_recon = new MenuItem("Reconnect");
        this.m_recon.setActionCommand(ACTION_RECONNECT);
        this.m_recon.setEnabled(false);
        this.m_recon.addActionListener(this);
        menu.add(this.m_recon);
        this.m_disconn = new MenuItem("Disconnect");
        this.m_disconn.setActionCommand(ACTION_DISCONNECT);
        this.m_disconn.setEnabled(false);
        this.m_disconn.addActionListener(this);
        menu.add(this.m_disconn);
        this.m_remove = new MenuItem("Remove");
        this.m_remove.setActionCommand(ACTION_REMOVE);
        this.m_remove.setEnabled(false);
        this.m_remove.addActionListener(this);
        menu.add(this.m_remove);
        menu.addSeparator();
        this.m_reboot = new MenuItem("Reboot");
        this.m_reboot.setActionCommand(ACTION_REBOOT);
        this.m_reboot.setEnabled(false);
        this.m_reboot.addActionListener(this);
        menu.add(this.m_reboot);
        menuBar.add(menu);
        this.m_windows = new Menu("Windows");
        menuBar.add(this.m_windows);
        menu = this.m_helpMenu = new Menu("Help");
        menuItem = new MenuItem("Help on Current Panel...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CURRENT);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Help Contents...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CONTENTS);
        menuItem.addActionListener(this);
        menu.addSeparator();
        menuItem = new MenuItem("About " + LEAppInfo.getAppName() + "...");
        menuItem.setActionCommand(ACTION_ABOUT);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Release Notes...");
        menuItem.setActionCommand(ACTION_RELNOTES);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    void loadProperties() {
        try {
            this.m_bounds = this.getPropRectangle(PROP_MAIN_X, PROP_MAIN_Y, PROP_MAIN_W, PROP_MAIN_H);
            this.m_rnBounds = this.getPropRectangle(PROP_RN_X, PROP_RN_Y, PROP_RN_W, PROP_RN_H);
            String string = LEProperties.GetProperty(PROP_TREE_W);
            if (string != null) {
                this.m_treeWidth = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_GRID_H)) != null) {
                this.m_gridHeight = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_PM_TREE)) != null) {
                this.m_treeSettings.put("pm", string);
            }
            if ((string = LEProperties.GetProperty(PROP_MONITOR_TREE)) != null) {
                this.m_treeSettings.put("pm" + LEControlTree.MONITOR, string);
            }
            if ((string = LEProperties.GetProperty(PROP_MONITOR_L2TP)) != null) {
                this.m_treeSettings.put("pm" + LEControlTree.L2TP, string);
            }
            if ((string = LEProperties.GetProperty(PROP_GRAPH_TREE)) != null) {
                this.m_treeSettings.put("pm" + LEControlTree.GRAPHS, string);
            }
            if ((string = LEProperties.GetProperty(PROP_DIAGNOSE_TREE)) != null) {
                this.m_treeSettings.put("pm" + LEControlTree.DIAGNOSE, string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAINTAIN_TREE)) != null) {
                this.m_treeSettings.put("pm" + LEControlTree.MAINTAIN, string);
            }
            if ((string = LEProperties.GetProperty(PROP_CONFIG_TREE)) != null) {
                this.m_treeSettings.put("pm" + LEControlTree.CONFIG, string);
            }
            if ((string = LEProperties.GetProperty(PROP_ITS_TREE)) != null) {
                this.m_treeSettings.put("its", string);
            }
            if ((string = LEProperties.GetProperty(PROP_ITS_MONITOR_TREE)) != null) {
                this.m_treeSettings.put("its" + LEControlTree.MONITOR, string);
            }
            if ((string = LEProperties.GetProperty(PROP_ITS_MAINTAIN_TREE)) != null) {
                this.m_treeSettings.put("its" + LEControlTree.MAINTAIN, string);
            }
            if ((string = LEProperties.GetProperty(PROP_ITS_CONFIG_TREE)) != null) {
                this.m_treeSettings.put("its" + LEControlTree.CONFIG, string);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    Rectangle getPropRectangle(String string, String string2, String string3, String string4) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string5 = LEProperties.GetProperty(string);
        if (string5 != null) {
            n = Integer.parseInt(string5);
        }
        if ((string5 = LEProperties.GetProperty(string2)) != null) {
            n2 = Integer.parseInt(string5);
        }
        if ((string5 = LEProperties.GetProperty(string3)) != null) {
            n3 = Integer.parseInt(string5);
        }
        if ((string5 = LEProperties.GetProperty(string4)) != null) {
            n4 = Integer.parseInt(string5);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    void saveProperties() {
        Rectangle rectangle = this.getBounds();
        LEProperties.SetProperty(PROP_MAIN_X, Integer.toString(rectangle.x));
        LEProperties.SetProperty(PROP_MAIN_Y, Integer.toString(rectangle.y));
        LEProperties.SetProperty(PROP_MAIN_W, Integer.toString(rectangle.width));
        LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height));
        if (this.m_notes != null) {
            rectangle = this.m_notes.getSavedBounds();
            LEProperties.SetProperty(PROP_RN_X, Integer.toString(rectangle.x));
            LEProperties.SetProperty(PROP_RN_Y, Integer.toString(rectangle.y));
            LEProperties.SetProperty(PROP_RN_W, Integer.toString(rectangle.width));
            LEProperties.SetProperty(PROP_RN_H, Integer.toString(rectangle.height));
        }
        Dimension dimension = this.m_treePanel.getSize();
        if (dimension.width < 0) {
            LEProperties.SetProperty(PROP_TREE_W, "0");
        } else {
            LEProperties.SetProperty(PROP_TREE_W, Integer.toString(dimension.width));
        }
        dimension = this.m_grid.getSize();
        if (dimension.height < 0) {
            LEProperties.SetProperty(PROP_GRID_H, "0");
        } else {
            LEProperties.SetProperty(PROP_GRID_H, Integer.toString(dimension.height));
        }
        Hashtable hashtable = this.m_tree.getTreeSettings();
        Object v = hashtable.get("pm");
        if (v != null) {
            LEProperties.SetProperty(PROP_PM_TREE, v.toString());
        }
        if ((v = hashtable.get("pm" + LEControlTree.MONITOR)) != null) {
            LEProperties.SetProperty(PROP_MONITOR_TREE, v.toString());
        }
        if ((v = hashtable.get("pm" + LEControlTree.L2TP)) != null) {
            LEProperties.SetProperty(PROP_MONITOR_L2TP, v.toString());
        }
        if ((v = hashtable.get("pm" + LEControlTree.GRAPHS)) != null) {
            LEProperties.SetProperty(PROP_GRAPH_TREE, v.toString());
        }
        if ((v = hashtable.get("pm" + LEControlTree.DIAGNOSE)) != null) {
            LEProperties.SetProperty(PROP_DIAGNOSE_TREE, v.toString());
        }
        if ((v = hashtable.get("pm" + LEControlTree.MAINTAIN)) != null) {
            LEProperties.SetProperty(PROP_MAINTAIN_TREE, v.toString());
        }
        if ((v = hashtable.get("pm" + LEControlTree.CONFIG)) != null) {
            LEProperties.SetProperty(PROP_CONFIG_TREE, v.toString());
        }
        if ((v = hashtable.get("its")) != null) {
            LEProperties.SetProperty(PROP_ITS_TREE, v.toString());
        }
        if ((v = hashtable.get("its" + LEControlTree.MONITOR)) != null) {
            LEProperties.SetProperty(PROP_ITS_MONITOR_TREE, v.toString());
        }
        if ((v = hashtable.get("its" + LEControlTree.MAINTAIN)) != null) {
            LEProperties.SetProperty(PROP_ITS_MAINTAIN_TREE, v.toString());
        }
        if ((v = hashtable.get("its" + LEControlTree.CONFIG)) != null) {
            LEProperties.SetProperty(PROP_ITS_CONFIG_TREE, v.toString());
        }
        LEProperties.SaveProperties();
    }

    void goodbye() {
        this.lock();
        this.m_statDialog = new LEStatusDialog(this);
        this.m_shutdown = true;
        Thread thread = new Thread(this);
        thread.setName("Shutdown");
        thread.start();
    }

    void closeWindows() {
        int n = this.m_subwins.size();
        int n2 = 0;
        while (n2 < n) {
            Window window = (Window)this.m_subwins.elementAt(n2);
            if (window instanceof Frame) {
                window.removeWindowListener(this);
                LEStatusManager.SetStatus("Closing window " + ((Frame)window).getTitle());
                ((Component)window).setVisible(false);
                window.dispose();
            }
            ++n2;
        }
    }

    void fillWindowsMenu() {
        this.m_windows.removeAll();
        int n = this.m_subwins.size();
        int n2 = 0;
        while (n2 < n) {
            Window window = (Window)this.m_subwins.elementAt(n2);
            String string = window instanceof Frame ? ((Frame)window).getTitle() : (window instanceof Dialog ? ((Dialog)window).getTitle() : "");
            MenuItem menuItem = new MenuItem(string);
            menuItem.setActionCommand(ACTION_SUBWINDOW + n2);
            menuItem.addActionListener(this);
            this.m_windows.add(menuItem);
            ++n2;
        }
    }

    void initializeSingletons() {
        this.m_amm = LEAMManager_RI.Initialize();
        LEAlarmFactory.Register();
        LECmdFailedFactory.Register();
        LEDebugFactory.Register();
        LEDeltaFactory.Register();
        LEMonitorFactory.Register();
        LEPortIOFactory.Register();
        LEStatusFactory.Register();
        this.m_cm = LEConnectionManager.Initialize();
        this.m_router = LEAMRouter_RI.GetAMRouter();
        this.m_specFactory = LEDataSpecFactory.GetFactory();
        this.m_viewFactory = new LEViewFactory(this, this.m_specFactory);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

