/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LETitleBar;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEDebugOptions
extends Dialog
implements WindowListener,
ActionListener,
ItemListener {
    private static final String DEBUG = "Debug";
    private static final String LIST = "List";
    LEDataSpec m_rootSpec;
    LEDebugPanel m_panel;
    LEBorderPanel m_border;
    List m_currentList;
    List m_major;
    List m_minor;
    Button m_apply;
    Button m_cancel;
    Button m_clearall;
    Button m_set;
    Button m_clear;
    Hashtable m_specTable = new Hashtable();
    Hashtable m_majorOptions = new Hashtable();
    Hashtable m_majorEntities = new Hashtable();
    Hashtable m_minorEntities = new Hashtable();
    Hashtable m_enabledDebug = new Hashtable();

    public LEDebugOptions(Frame frame, String string, LEDebugPanel lEDebugPanel, String string2) {
        super(frame, "Debug Options for " + string, false);
        ((Component)this).setBackground(LEColor.getBackground());
        this.m_panel = lEDebugPanel;
        this.m_border = new LEBorderPanel(4);
        this.m_border.setLayout(new BorderLayout(5, 10));
        this.m_border.setInsets(10, 20, 5, 20);
        Insets insets = this.getInsets();
        insets.top = 10;
        insets.bottom = 10;
        insets.right = 20;
        insets.left = 20;
        try {
            this.m_rootSpec = LEDataSpecFactory.GetSpec(String.valueOf(string2) + "dbg");
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(10, exception);
        }
        this.m_border.add("North", this.createCurrentPanel());
        this.m_border.add("Center", this.createOptionsPanel());
        this.m_border.add("South", this.createButtonPanel());
        this.add(this.m_border);
        this.addWindowListener(this);
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        ((Component)this).setSize(640, 480);
        LEUiUtils.CenterDialog(this);
    }

    public void setOptions(int[] nArray, int[] nArray2) {
        String[] stringArray = this.m_major.getItems();
        int n = 0;
        while (n < stringArray.length) {
            LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(stringArray[n]);
            int n2 = Integer.parseInt(lEDataSpec.getTag());
            int n3 = 0;
            while (n3 < nArray.length) {
                if (n2 == nArray[n3]) {
                    if (lEDataSpec.getType().equals(DEBUG)) {
                        this.m_enabledDebug.put(lEDataSpec, "on");
                    } else if (lEDataSpec.getType().equals(LIST)) {
                        LEVector lEVector = lEDataSpec.getAllSpecs();
                        int n4 = lEVector.size();
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6;
                            LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n5);
                            if (nArray[n3] == 393216) {
                                n6 = Integer.parseInt((String)lEDataSpec2.getAttribute(LEAttributes.VALUES), 16);
                                if ((n6 & nArray2[n3]) == n6) {
                                    this.m_enabledDebug.put(lEDataSpec2, "on");
                                }
                            } else {
                                n6 = Integer.parseInt((String)lEDataSpec2.getAttribute(LEAttributes.VALUES));
                                if (n6 == nArray2[n3]) {
                                    this.m_enabledDebug.put(lEDataSpec2, "on");
                                }
                            }
                            ++n5;
                        }
                    }
                }
                ++n3;
            }
            ++n;
        }
        this.fillCurrentList();
    }

    void getOptions() {
        int n;
        LEVector lEVector = new LEVector();
        LEVector lEVector2 = new LEVector();
        String[] stringArray = this.m_major.getItems();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string;
            LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(stringArray[n3]);
            int n4 = Integer.parseInt(lEDataSpec.getTag());
            if (lEDataSpec.getType().equals(DEBUG)) {
                string = (String)this.m_enabledDebug.get(lEDataSpec);
                if (string.equals("on")) {
                    lEVector.addElement(Integer.valueOf(lEDataSpec.getTag()));
                    lEVector2.addElement(Integer.valueOf((String)lEDataSpec.getAttribute(LEAttributes.VALUES)));
                }
            } else if (lEDataSpec.getType().equals(LIST)) {
                LEVector lEVector3 = lEDataSpec.getAllSpecs();
                int n5 = lEVector3.size();
                n = 0;
                while (n < n5) {
                    LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector3.elementAt(n);
                    string = (String)this.m_enabledDebug.get(lEDataSpec2);
                    if (string.equals("on")) {
                        if (n4 == 393216) {
                            bl = true;
                            int n6 = Integer.parseInt((String)lEDataSpec2.getAttribute(LEAttributes.VALUES), 16);
                            n2 |= n6;
                        } else {
                            lEVector.addElement(Integer.valueOf(lEDataSpec.getTag()));
                            lEVector2.addElement(Integer.valueOf((String)lEDataSpec2.getAttribute(LEAttributes.VALUES)));
                        }
                    }
                    ++n;
                }
            }
            ++n3;
        }
        if (bl) {
            lEVector.addElement(new Integer(393216));
            lEVector2.addElement(new Integer(n2));
        }
        n = lEVector.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n7 = 0;
        while (n7 < n) {
            nArray[n7] = (Integer)lEVector.elementAt(n7);
            nArray2[n7] = (Integer)lEVector2.elementAt(n7);
            ++n7;
        }
        this.m_panel.setOptions(nArray, nArray2);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        List list = (List)itemEvent.getItemSelectable();
        if (list == this.m_major) {
            String string2 = this.m_major.getSelectedItem();
            LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(string2);
            this.initializeMinorList(string2);
            if (lEDataSpec.getType().equals(LIST)) {
                LEVector lEVector = lEDataSpec.getAllSpecs();
                int n = lEVector.size();
                boolean bl = false;
                int n2 = 0;
                while (n2 < n && !bl) {
                    LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
                    String string3 = (String)this.m_enabledDebug.get(lEDataSpec2);
                    if (string3.equals("on")) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    this.m_set.setEnabled(true);
                    this.m_clear.setEnabled(true);
                    return;
                }
                this.m_set.setEnabled(false);
                this.m_clear.setEnabled(false);
                return;
            }
            this.m_set.setEnabled(true);
            this.m_clear.setEnabled(true);
            return;
        }
        if (list == this.m_minor) {
            String[] stringArray = this.m_minor.getSelectedItems();
            if (stringArray.length > 0) {
                this.m_set.setEnabled(true);
                this.m_clear.setEnabled(true);
                return;
            }
            this.m_set.setEnabled(false);
            this.m_clear.setEnabled(false);
            return;
        }
        if (list == this.m_currentList && (string = this.m_currentList.getSelectedItem()) != null) {
            int n = string.indexOf(" : ");
            String string4 = n > -1 ? string.substring(0, n).trim() : string.trim();
            String[] stringArray = this.m_major.getItems();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals(string4)) {
                    this.m_major.select(n3);
                    break;
                }
                ++n3;
            }
            this.initializeMinorList(string4);
            LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(string4);
            if (lEDataSpec.getType().equals(LIST)) {
                LEVector lEVector = lEDataSpec.getAllSpecs();
                int n4 = lEVector.size();
                boolean bl = false;
                int n5 = 0;
                while (n5 < n4 && !bl) {
                    LEDataSpec lEDataSpec3 = (LEDataSpec)lEVector.elementAt(n5);
                    String string5 = (String)this.m_enabledDebug.get(lEDataSpec3);
                    if (string5.equals("on")) {
                        bl = true;
                    }
                    ++n5;
                }
                if (bl) {
                    this.m_set.setEnabled(true);
                    this.m_clear.setEnabled(true);
                    return;
                }
                this.m_set.setEnabled(false);
                this.m_clear.setEnabled(false);
                return;
            }
            this.m_set.setEnabled(true);
            this.m_clear.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Clear")) {
            this.clearDebugOptions();
            this.fillCurrentList();
            return;
        }
        if (string.equals("Set")) {
            this.setDebugOptions();
            this.fillCurrentList();
            return;
        }
        if (string.equals("Apply")) {
            this.getOptions();
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (string.equals("Cancel")) {
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (string.equals("Clear All")) {
            this.clearAllDebugOptions();
            this.fillCurrentList();
        }
    }

    Panel createCurrentPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Label label = new Label("Enabled Debug:");
        label.setFont(LEFont.getBoldFont());
        panel2.add("North", label);
        panel.add("West", panel2);
        this.m_currentList = new List(5, false);
        this.m_currentList.addItemListener(this);
        panel.add("Center", this.m_currentList);
        return panel;
    }

    Panel createOptionsPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(10, 10));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 30, 10));
        this.m_major = new List(10, false);
        this.m_major.addItemListener(this);
        this.initializeMajorList();
        this.m_minor = new List(10, true);
        this.m_minor.addItemListener(this);
        panel2.add(this.m_major);
        panel2.add(this.m_minor);
        panel.add("Center", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        this.m_set = new Button("Set");
        this.m_set.addActionListener(this);
        this.m_set.setEnabled(false);
        this.m_clear = new Button("Clear");
        this.m_clear.addActionListener(this);
        this.m_clear.setEnabled(false);
        panel3.add(this.m_set);
        panel3.add(this.m_clear);
        panel.add("South", panel3);
        return panel;
    }

    Panel createButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new LETitleBar());
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        this.m_apply = new Button("Apply");
        this.m_apply.addActionListener(this);
        this.m_cancel = new Button("Cancel");
        this.m_cancel.addActionListener(this);
        this.m_clearall = new Button("Clear All");
        this.m_clearall.addActionListener(this);
        panel2.add(this.m_apply);
        panel2.add(this.m_cancel);
        panel2.add(this.m_clearall);
        panel.add("Center", panel2);
        return panel;
    }

    void initializeMajorList() {
        LEVector lEVector = this.m_rootSpec.getAllSpecs();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            LEDataSpec lEDataSpec = (LEDataSpec)lEVector.elementAt(n2);
            String string = lEDataSpec.getDescription();
            this.m_specTable.put(string, lEDataSpec);
            this.m_major.add(string);
            if (lEDataSpec.getType().equals(DEBUG)) {
                this.m_enabledDebug.put(lEDataSpec, "off");
            } else if (lEDataSpec.getType().equals(LIST)) {
                LEVector lEVector2 = lEDataSpec.getAllSpecs();
                int n3 = lEVector2.size();
                int n4 = 0;
                while (n4 < n3) {
                    LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector2.elementAt(n4);
                    this.m_enabledDebug.put(lEDataSpec2, "off");
                    ++n4;
                }
            }
            ++n2;
        }
    }

    void initializeMinorList(String string) {
        this.m_minor.removeAll();
        LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(string);
        if (lEDataSpec.getType().equals(LIST)) {
            LEVector lEVector = lEDataSpec.getAllSpecs();
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
                this.m_minor.add(lEDataSpec2.getDescription());
                String string2 = (String)this.m_enabledDebug.get(lEDataSpec2);
                if (string2.equals("on")) {
                    this.m_minor.select(n2);
                }
                ++n2;
            }
        }
    }

    void setDebugOptions() {
        String string = this.m_major.getSelectedItem();
        LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(string);
        if (lEDataSpec.getType().equals(DEBUG)) {
            this.m_enabledDebug.put(lEDataSpec, "on");
            return;
        }
        if (lEDataSpec.getType().equals(LIST)) {
            int[] nArray = this.m_minor.getSelectedIndexes();
            LEVector lEVector = lEDataSpec.getAllSpecs();
            int n = 0;
            while (n < nArray.length) {
                LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(nArray[n]);
                this.m_enabledDebug.put(lEDataSpec2, "on");
                ++n;
            }
        }
    }

    void clearDebugOptions() {
        String string = this.m_major.getSelectedItem();
        LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(string);
        if (lEDataSpec.getType().equals(DEBUG)) {
            this.m_enabledDebug.put(lEDataSpec, "off");
            return;
        }
        if (lEDataSpec.getType().equals(LIST)) {
            LEVector lEVector = lEDataSpec.getAllSpecs();
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.m_enabledDebug.put(lEVector.elementAt(n2), "off");
                this.m_minor.deselect(n2);
                ++n2;
            }
        }
    }

    void clearAllDebugOptions() {
        Enumeration enumeration = this.m_enabledDebug.keys();
        while (enumeration.hasMoreElements()) {
            LEDataSpec lEDataSpec = (LEDataSpec)enumeration.nextElement();
            this.m_enabledDebug.put(lEDataSpec, "off");
        }
    }

    void fillCurrentList() {
        this.m_currentList.removeAll();
        String[] stringArray = this.m_major.getItems();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            LEDataSpec lEDataSpec = (LEDataSpec)this.m_specTable.get(stringArray[n]);
            if (lEDataSpec.getType().equals(DEBUG)) {
                string = (String)this.m_enabledDebug.get(lEDataSpec);
                if (string.equals("on")) {
                    this.m_currentList.add(stringArray[n]);
                }
            } else if (lEDataSpec.getType().equals(LIST)) {
                boolean bl = false;
                LEVector lEVector = lEDataSpec.getAllSpecs();
                int n2 = lEVector.size();
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < n2) {
                    LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n3);
                    string = (String)this.m_enabledDebug.get(lEDataSpec2);
                    if (string.equals("on")) {
                        if (!bl) {
                            stringBuffer.append(lEDataSpec.getDescription());
                            stringBuffer.append(" : ");
                            bl = true;
                        } else {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(lEDataSpec2.getDescription());
                    }
                    ++n3;
                }
                if (stringBuffer.length() > 0) {
                    this.m_currentList.add(stringBuffer.toString());
                }
            }
            ++n;
        }
    }
}

