/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEPMDebug;
import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEDebugOptionsOld
extends Dialog
implements WindowListener,
ActionListener,
ItemListener {
    static final String ACTION_CANCEL = new String("Cancel");
    static final String ACTION_CLEAR = new String("Clear");
    static final String ACTION_SET = new String("Set");
    static final String ACTION_ADDHEX = new String("Add Hex Value");
    static int[] s_entities = null;
    static int[][] s_debugs = null;
    LECompGrid m_grid;
    LETextField m_hex;
    Button m_clear;
    Button m_set;
    Button m_cancel;
    Button m_addhex;
    LEDebugPanel m_panel;
    int[] m_rows;
    static final String HEX_INDICATOR = "0x";
    static final int ITEMS_PER_ROW = 5;

    public LEDebugOptionsOld(Frame frame, String string, LEDebugPanel lEDebugPanel) {
        super(frame, "Debug Options for " + string, false);
        if (s_entities == null) {
            LEDebugOptionsOld.Initialize();
        }
        ((Component)this).setBackground(LEColor.getBackground());
        this.m_panel = lEDebugPanel;
        this.setLayout(new BorderLayout(5, 5));
        Component[][] componentArray = this.getDebugComponents();
        if (componentArray != null) {
            this.m_grid = new LECompGrid(componentArray, 1);
            this.add("North", this.m_grid);
            this.checkState();
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3, 5, 5));
        this.m_set = new Button(ACTION_SET);
        this.m_set.addActionListener(this);
        panel2.add(this.m_set);
        this.m_clear = new Button(ACTION_CLEAR);
        this.m_clear.addActionListener(this);
        panel2.add(this.m_clear);
        this.m_cancel = new Button(ACTION_CANCEL);
        this.m_cancel.addActionListener(this);
        panel2.add(this.m_cancel);
        panel.add(panel2);
        this.add("South", panel);
        this.addWindowListener(this);
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width, dimension.height);
    }

    public void setOptions(int[] nArray, int[] nArray2) {
        this.clear();
        if (nArray.length != nArray2.length) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            this.set(nArray[n], nArray2[n]);
            ++n;
        }
        this.checkState();
    }

    public void set(int n, int n2) {
        if (n == 131072) {
            n = 0x190000;
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < s_entities.length) {
            if (s_entities[n4] == n) {
                n3 = n4;
            }
            ++n4;
        }
        if (n3 == -1) {
            return;
        }
        Component component = null;
        int n5 = 0;
        int n6 = -1;
        while (n6 < n3) {
            if (!((component = this.m_grid.getComponent(n5++, 0)) instanceof Checkbox)) continue;
            ++n6;
        }
        --n5;
        ((Checkbox)component).setState(true);
        if (n != 393216) {
            int n7 = -1;
            int n8 = 0;
            while (n8 < s_debugs[n6].length) {
                if (s_debugs[n6][n8] == n2) {
                    n7 = n8 + 1;
                }
                ++n8;
            }
            if (n7 == -1) {
                return;
            }
            if (n7 > 5) {
                n7 -= 5;
                ++n5;
            }
            ((Checkbox)this.m_grid.getComponent(n5, n7)).setState(true);
            return;
        }
        ((TextComponent)this.m_hex).setText(Integer.toHexString(n2));
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_CLEAR)) {
            this.clear();
            return;
        }
        if (string.equals(ACTION_SET)) {
            if (this.getOptions()) {
                ((Component)this).setVisible(false);
                this.dispose();
                return;
            }
        } else {
            if (string.equals(ACTION_CANCEL)) {
                ((Component)this).setVisible(false);
                this.dispose();
                return;
            }
            if (string.equals(ACTION_ADDHEX)) {
                Panel panel = new Panel(new FlowLayout(1, 0, 0));
                panel.add(new Label(HEX_INDICATOR));
                LETextField lETextField = new LETextField(4);
                lETextField.setHex(true);
                panel.add(lETextField);
                new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Hex Debug Value", panel);
                String string2 = lETextField.getText();
                if (string2.length() > 0) {
                    int n = Integer.parseInt(string2, 16);
                    int n2 = 0;
                    if (this.m_hex.getText().length() > 0) {
                        n2 = Integer.parseInt(this.m_hex.getText(), 16);
                    }
                    int n3 = n2 | n;
                    ((TextComponent)this.m_hex).setText(Integer.toHexString(n3));
                }
            }
        }
    }

    static void Initialize() {
        s_entities = new int[11];
        LEDebugOptionsOld.s_entities[0] = 0x190000;
        LEDebugOptionsOld.s_entities[1] = 0x100000;
        LEDebugOptionsOld.s_entities[2] = 196608;
        LEDebugOptionsOld.s_entities[3] = 0x2F0000;
        LEDebugOptionsOld.s_entities[4] = 458752;
        LEDebugOptionsOld.s_entities[5] = 0x170000;
        LEDebugOptionsOld.s_entities[6] = 0x3A0000;
        LEDebugOptionsOld.s_entities[7] = 0x350000;
        LEDebugOptionsOld.s_entities[8] = 3670025;
        LEDebugOptionsOld.s_entities[9] = 0x230000;
        LEDebugOptionsOld.s_entities[10] = 393216;
        s_debugs = new int[11][];
        LEDebugOptionsOld.s_debugs[0] = new int[3];
        LEDebugOptionsOld.s_debugs[0][0] = 2;
        LEDebugOptionsOld.s_debugs[0][1] = 3;
        LEDebugOptionsOld.s_debugs[0][2] = 4;
        LEDebugOptionsOld.s_debugs[1] = new int[9];
        LEDebugOptionsOld.s_debugs[1][0] = 8;
        LEDebugOptionsOld.s_debugs[1][1] = 9;
        LEDebugOptionsOld.s_debugs[1][2] = 10;
        LEDebugOptionsOld.s_debugs[1][3] = 11;
        LEDebugOptionsOld.s_debugs[1][4] = 12;
        LEDebugOptionsOld.s_debugs[1][5] = 13;
        LEDebugOptionsOld.s_debugs[1][6] = 14;
        LEDebugOptionsOld.s_debugs[1][7] = 15;
        LEDebugOptionsOld.s_debugs[1][8] = 16;
        LEDebugOptionsOld.s_debugs[2] = new int[4];
        LEDebugOptionsOld.s_debugs[2][0] = 25;
        LEDebugOptionsOld.s_debugs[2][1] = 26;
        LEDebugOptionsOld.s_debugs[2][2] = 27;
        LEDebugOptionsOld.s_debugs[2][3] = 28;
        LEDebugOptionsOld.s_debugs[3] = new int[5];
        LEDebugOptionsOld.s_debugs[3][0] = 49;
        LEDebugOptionsOld.s_debugs[3][1] = 50;
        LEDebugOptionsOld.s_debugs[3][2] = 51;
        LEDebugOptionsOld.s_debugs[3][3] = 52;
        LEDebugOptionsOld.s_debugs[3][4] = 48;
        LEDebugOptionsOld.s_debugs[4] = new int[0];
        LEDebugOptionsOld.s_debugs[5] = new int[0];
        LEDebugOptionsOld.s_debugs[6] = new int[0];
        LEDebugOptionsOld.s_debugs[7] = new int[5];
        LEDebugOptionsOld.s_debugs[7][0] = 1;
        LEDebugOptionsOld.s_debugs[7][1] = 2;
        LEDebugOptionsOld.s_debugs[7][2] = 4;
        LEDebugOptionsOld.s_debugs[7][3] = 8;
        LEDebugOptionsOld.s_debugs[7][4] = 15;
        LEDebugOptionsOld.s_debugs[8] = new int[2];
        LEDebugOptionsOld.s_debugs[8][0] = 76;
        LEDebugOptionsOld.s_debugs[8][1] = 77;
        LEDebugOptionsOld.s_debugs[9] = new int[0];
        LEDebugOptionsOld.s_debugs[10] = new int[0];
    }

    boolean getOptions() {
        if (this.m_panel == null) {
            return false;
        }
        LEVector lEVector = new LEVector();
        LEVector lEVector2 = new LEVector();
        int n = 0;
        int n2 = 0;
        while (n2 < s_entities.length) {
            String string;
            boolean bl = ((Checkbox)this.m_grid.getComponent(n, 0)).getState();
            if (bl && s_entities[n2] == 458752) {
                lEVector.addElement(new Integer(s_entities[n2]));
                lEVector2.addElement(new Integer(18));
            } else if (bl && s_entities[n2] == 0x170000) {
                lEVector.addElement(new Integer(s_entities[n2]));
                lEVector2.addElement(new Integer(37));
            } else if (bl && s_entities[n2] == 0x3A0000) {
                lEVector.addElement(new Integer(s_entities[n2]));
                lEVector2.addElement(new Integer(6));
            } else if (bl && s_entities[n2] == 0x190000) {
                lEVector.addElement(new Integer(131072));
                lEVector2.addElement(new Integer(1));
            } else if (bl && s_entities[n2] == 0x350000) {
                lEVector.addElement(new Integer(s_entities[n2]));
                lEVector2.addElement(new Integer(53));
            } else if (bl && s_entities[n2] == 3670025) {
                lEVector.addElement(new Integer(s_entities[n2]));
                lEVector2.addElement(new Integer(76));
            } else if (bl && s_entities[n2] == 0x230000) {
                lEVector.addElement(new Integer(s_entities[n2]));
                lEVector2.addElement(new Integer(55));
            } else if (bl && s_entities[n2] == 393216 && (string = this.m_hex.getText()).length() > 0) {
                try {
                    int n3 = Integer.parseInt(string, 16);
                    if (n3 > 0 && n3 < 65535) {
                        lEVector.addElement(new Integer(393216));
                        lEVector2.addElement(new Integer(n3));
                    } else if (n3 == 65535) {
                        String string2 = new String("You cannot set debug to 0xfff");
                        new LEErrorDialog(LEUiUtils.GetBaseFrame(), string2);
                        return false;
                    }
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                }
            }
            if (s_debugs[n2].length > 0) {
                int n4 = 1;
                int n5 = 0;
                while (n5 < s_debugs[n2].length) {
                    if (n4 > 5) {
                        n4 = 1;
                        ++n;
                    }
                    Checkbox checkbox = (Checkbox)this.m_grid.getComponent(n, n4++);
                    if (bl && checkbox.getState()) {
                        if (s_entities[n2] == 0x190000) {
                            lEVector.addElement(new Integer(131072));
                        } else {
                            lEVector.addElement(new Integer(s_entities[n2]));
                        }
                        lEVector2.addElement(new Integer(s_debugs[n2][n5]));
                    }
                    ++n5;
                }
            }
            n += 2;
            ++n2;
        }
        int n6 = lEVector.size();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int n7 = 0;
        while (n7 < n6) {
            nArray[n7] = (Integer)lEVector.elementAt(n7);
            nArray2[n7] = (Integer)lEVector2.elementAt(n7);
            ++n7;
        }
        this.m_panel.setOptions(nArray, nArray2);
        return true;
    }

    void checkState() {
        int n = this.m_grid.getRows();
        int n2 = this.m_grid.getColumns();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            Component component = this.m_grid.getComponent(n3, 0);
            if (component instanceof Checkbox) {
                bl = ((Checkbox)component).getState();
            }
            int n4 = 1;
            while (n4 < n2) {
                component = this.m_grid.getComponent(n3, n4);
                if (component instanceof Checkbox) {
                    ((Checkbox)component).setEnabled(bl);
                }
                ++n4;
            }
            ++n3;
        }
        this.m_hex.setEnabled(bl);
        this.m_addhex.setEnabled(bl);
    }

    void clear() {
        int n = this.m_grid.getRows();
        int n2 = this.m_grid.getColumns();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Component component = this.m_grid.getComponent(n3, n4);
                if (component instanceof Checkbox) {
                    ((Checkbox)component).setState(false);
                }
                ++n4;
            }
            ++n3;
        }
        ((TextComponent)this.m_hex).setText("");
        this.checkState();
    }

    Component[][] getDebugComponents() {
        int n = 0;
        int n2 = 0;
        while (n2 < s_entities.length) {
            n += (s_debugs[n2].length - 1) / 5 + 2;
            ++n2;
        }
        Component[][] componentArray = new Component[--n][6];
        int n3 = 0;
        int n4 = 0;
        while (n4 < s_entities.length) {
            Checkbox checkbox;
            if (n4 > 0) {
                componentArray[n3++][0] = new Label("");
            }
            if (s_entities[n4] == 393216) {
                checkbox = new Checkbox("Hex command");
                componentArray[n3][0] = checkbox;
                checkbox.addItemListener(this);
                Panel panel = new Panel();
                panel.setLayout(new FlowLayout(1, 0, 0));
                panel.add(new Label(HEX_INDICATOR));
                this.m_hex = new LETextField(4);
                this.m_hex.setHex(true);
                this.m_addhex = new Button(ACTION_ADDHEX);
                this.m_addhex.addActionListener(this);
                panel.add(this.m_hex);
                componentArray[n3][1] = panel;
                componentArray[n3][2] = this.m_addhex;
            } else if (s_entities[n4] == 0x350000) {
                checkbox = new Checkbox(this.getEntityString(s_entities[n4]));
                componentArray[n3][0] = checkbox;
                checkbox.addItemListener(this);
                componentArray[n3][1] = new Checkbox("Packets");
                componentArray[n3][2] = new Checkbox("Stats");
                componentArray[n3][3] = new Checkbox("RPC");
                componentArray[n3][4] = new Checkbox("Setup");
                componentArray[n3][5] = new Checkbox("Max");
            } else {
                checkbox = new Checkbox(this.getEntityString(s_entities[n4]));
                componentArray[n3][0] = checkbox;
                checkbox.addItemListener(this);
                int n5 = 1;
                int n6 = 0;
                while (n6 < s_debugs[n4].length) {
                    if (n5 > 5) {
                        ++n3;
                        n5 = 1;
                    }
                    componentArray[n3][n5++] = new Checkbox(LEPMDebug.GetDebugString(s_debugs[n4][n6]));
                    ++n6;
                }
            }
            ++n3;
            ++n4;
        }
        return componentArray;
    }

    public String getEntityString(int n) {
        String string = "";
        switch (n) {
            case 0x190000: {
                string = "ISDN";
                break;
            }
            case 0x100000: {
                string = "OSPF";
                break;
            }
            case 0x2F0000: {
                string = "NAT";
                break;
            }
            case 0x170000: {
                string = "ChoiceNet";
                break;
            }
            case 196608: {
                string = "Modems";
                break;
            }
            case 458752: {
                string = "MultiChassis PPP";
                break;
            }
            case 0x350000: {
                string = "L2TP";
                break;
            }
            case 3670025: {
                string = "RIP";
                break;
            }
            case 0x230000: {
                string = "NFAS";
                break;
            }
            case 0x3A0000: {
                string = "Termination";
                break;
            }
        }
        return string;
    }
}

