/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LESessionSummaryMessage;
import com.lucent.ra.nms.graph.LEFilledGraph;
import com.lucent.ra.nms.graph.LEGraphData;
import com.lucent.ra.nms.graph.LEGraphPanel;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class LESessionsGraph
extends Frame
implements WindowListener,
LEAMObserver,
Runnable {
    static SimpleDateFormat s_simple = null;
    static DateFormat s_format = null;
    static final int S_TOTAL = 0;
    static final int S_ISDN = 1;
    static final int S_56K = 2;
    static final int S_V34 = 3;
    static final int S_OTHER = 4;
    LEPortMaster m_pm;
    LEGraphPanel m_panel;
    LEFilledGraph m_graph;
    LEGraphData m_isdnD;
    LEGraphData m_56kD;
    LEGraphData m_v34D;
    LEGraphData m_otherD;
    Hashtable m_data = new Hashtable();
    int m_time;
    String m_log;
    PrintWriter m_prw;
    Thread m_thread;

    public LESessionsGraph(LEPortMaster lEPortMaster, String string, int n) {
        super(String.valueOf(lEPortMaster.getDescription()) + " Session Usage");
        this.m_pm = lEPortMaster;
        this.m_log = string;
        this.addWindowListener(this);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.m_graph = new LEFilledGraph();
        this.m_graph.setYLabel("Sessions");
        this.m_otherD = new LEGraphData("Other", Color.yellow);
        this.m_graph.addGraphData(this.m_otherD);
        this.m_v34D = new LEGraphData("v34", Color.green);
        this.m_graph.addGraphData(this.m_v34D);
        this.m_56kD = new LEGraphData("56k", Color.blue);
        this.m_graph.addGraphData(this.m_56kD);
        this.m_isdnD = new LEGraphData("ISDN", Color.black);
        this.m_graph.addGraphData(this.m_isdnD);
        String[][] stringArray = new String[4][2];
        stringArray[0][0] = "Device";
        stringArray[0][1] = this.m_pm.getDescription();
        stringArray[1][0] = "Update Interval";
        stringArray[1][1] = String.valueOf(Integer.toString(n)) + " minutes";
        stringArray[2][0] = "Log";
        stringArray[2][1] = string;
        stringArray[3][0] = "Log Format";
        stringArray[3][1] = "YYYYMMDDHHMMSS,Total,ISDN,56k,v34,Other";
        this.m_time = n * 60000;
        if (s_simple == null) {
            s_simple = new SimpleDateFormat("yyyyMMddhhmmss", Locale.getDefault());
            s_simple.setTimeZone(TimeZone.getDefault());
            s_format = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
            s_format.setTimeZone(TimeZone.getDefault());
        }
        this.m_panel = new LEGraphPanel(this.m_graph, stringArray, "graph_sessions_");
        this.add("Center", this.m_panel);
        this.pack();
        ((Component)this).setVisible(true);
        String string2 = this.m_pm.getResourceID();
        LEMonitorFactory.GetFactory().addObserver(string2, this);
    }

    public void addNotify() {
        super.addNotify();
        try {
            if (this.m_log != null && this.m_log.length() > 0) {
                FileWriter fileWriter = new FileWriter(this.m_log);
                this.m_prw = new PrintWriter(fileWriter);
                this.m_prw.println("YYYYMMDDHHMMSS,Total,ISDN,56k,v34,Other");
            }
            this.startMonitoring();
            return;
        }
        catch (Exception exception) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), exception.getMessage());
            return;
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LESessionSummaryMessage) {
            this.updateSessions((LESessionSummaryMessage)object);
            if (this.m_thread == null) {
                String string2 = this.m_pm.getDescription();
                this.m_thread = new Thread((Runnable)this, String.valueOf(string2) + " Session Usage Graph");
                this.m_thread.start();
            }
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        while (true) {
            try {
                while (true) {
                    this.updateGraphData();
                    Thread.currentThread();
                    Thread.sleep(this.m_time);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                continue;
            }
            break;
        }
    }

    public void goodbye() {
        String string = this.m_pm.getResourceID();
        LEMonitorFactory.GetFactory().deleteObserver(string, this);
        this.stopMonitoring();
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        this.m_prw = null;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.goodbye();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void updateSessions(LESessionSummaryMessage lESessionSummaryMessage) {
        String string = lESessionSummaryMessage.getBoard();
        double[] dArray = (double[])this.m_data.get(string);
        if (dArray == null) {
            dArray = new double[5];
            this.m_data.put(string, dArray);
        }
        dArray[0] = lESessionSummaryMessage.getTotal();
        dArray[1] = lESessionSummaryMessage.getISDNCount();
        dArray[2] = lESessionSummaryMessage.get56KCount();
        dArray[3] = lESessionSummaryMessage.getV34Count();
        dArray[4] = lESessionSummaryMessage.getOtherCount();
    }

    void updateGraphData() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Enumeration enumeration = this.m_data.elements();
        while (enumeration.hasMoreElements()) {
            double[] dArray = (double[])enumeration.nextElement();
            d += dArray[0];
            d2 += dArray[1];
            d3 += dArray[2];
            d4 += dArray[3];
            d5 += dArray[4];
        }
        this.m_isdnD.addData(d2);
        this.m_56kD.addData(d2 + d3);
        this.m_v34D.addData(d2 + d3 + d4);
        this.m_otherD.addData(d2 + d3 + d4 + d5);
        Date date = new Date();
        this.m_graph.setMaxValue(d);
        this.m_graph.setXLabel(s_format.format(date));
        this.m_graph.redraw();
        if (this.m_prw != null) {
            this.m_prw.print(s_simple.format(date));
            this.m_prw.print(",");
            this.m_prw.print(d);
            this.m_prw.print(",");
            this.m_prw.print(d2);
            this.m_prw.print(",");
            this.m_prw.print(d3);
            this.m_prw.print(",");
            this.m_prw.print(d4);
            this.m_prw.print(",");
            this.m_prw.println(d5);
        }
    }

    void startMonitoring() {
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (lEConnectionFacade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            lEPMConnectionFacade.startMonitor(0x2E0000, -1, LEPMConnectionFacade.NO_GROUP, this.m_time);
        }
    }

    void stopMonitoring() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
        this.m_data.clear();
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (lEConnectionFacade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            lEPMConnectionFacade.stopMonitor(0x2E0000, -1, LEPMConnectionFacade.NO_GROUP, this.m_time);
        }
    }
}

