/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEBGPPolicies;
import com.lucent.ra.nms.model.LEBGPPolicy;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEBGPPoliciesForm
extends LETableForm {
    String m_name;

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        this.m_tags.addElement("entry");
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = "Device";
        titles[1] = "BGP Policy";
        titles[2] = "Rule Count";
        this.setTitles(0, titles);
    }

    void addEntry(String host, LETable table, String key) {
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        Object obj = table.get(key);
        if (obj instanceof LEBGPPolicy) {
            LEBGPPolicy policy = (LEBGPPolicy)obj;
            data[2] = Integer.toString(policy.size());
        }
        this.addRow(data);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("BGP Policy Name:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add BGP Policy", panel);
        if (dlg.okay()) {
            this.m_name = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_name.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A BGP policy name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEBGPPolicies table = (LEBGPPolicies)this.getTable(pm);
        if (table.get(this.m_name) == null) {
            LEVector errors = table.add(this.m_name);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_name);
            entry = new LENewEntry(pm, table, this.m_name);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a bgp policy named " + this.m_name);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEBGPPolicies)) {
            return;
        }
        LEBGPPolicies policies = (LEBGPPolicies)table;
        LEVector errors = policies.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    void pasteEntryTo(LEPortMaster pm, Object obj) {
        String key = this.getPasteKey(pm, obj);
        if (key == null) {
            return;
        }
        this.updateEntry(pm.getDescription(), this.getTable(pm), key);
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        String name;
        if (!(obj instanceof LEBGPPolicy)) {
            return null;
        }
        LEBGPPolicy policy = (LEBGPPolicy)obj;
        LEBGPPolicies policies = (LEBGPPolicies)this.getTable(pm);
        if (policies.get(name = policy.getName()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a bgp policy named " + name);
            name = null;
        } else {
            LEVector errors = policies.add(name);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                name = null;
            }
        }
        return name;
    }
}

