/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEMuxChannel;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEChannelsForm
extends LETableForm {
    public LEChannelsForm() {
        this.m_keyReadonly = true;
    }

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        this.m_cols = 3;
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = "Device";
        titles[1] = "Channel";
        titles[2] = "Board";
        titles[3] = "Line";
        titles[4] = "Channel-Loop";
        this.setTitles(0, titles);
    }

    void addEntry(String host, LETable table, String key) {
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        Object obj = table.get(key);
        if (obj instanceof LEMuxChannel) {
            LEMuxChannel channel = (LEMuxChannel)obj;
            String value = (String)channel.get("channel");
            if (value.length() > 0) {
                data[2] = value.substring(0, 1);
                data[3] = value.substring(2);
            } else {
                data[2] = "";
                data[3] = "";
            }
            data[4] = (String)channel.get("462");
        }
        this.addRow(data);
    }

    void updateEntry(String host, LETable table, String key) {
        Object obj = table.get(key);
        if (obj == null || this.m_cols == 0) {
            return;
        }
        int rows = this.getNumRows();
        int row = -1;
        int i = 0;
        while (row == -1 && i < rows) {
            String cellHost = this.getCellString(i, 0);
            String cellKey = this.getCellString(i, 1);
            if (cellHost.equals(host) && cellKey.equals(key)) {
                row = i;
            }
            ++i;
        }
        if (row > -1) {
            if (obj instanceof LEMuxChannel) {
                LEConfig config = (LEConfig)obj;
                String value = (String)config.get("channel");
                if (value.length() > 0) {
                    this.setCellString(row, 2, value.substring(0, 1));
                    this.setCellString(row, 3, value.substring(2));
                } else {
                    this.setCellString(row, 2, "");
                    this.setCellString(row, 3, "");
                }
                value = (String)config.get("462");
                this.setCellString(row, 4, value);
            }
        } else {
            this.addEntry(host, table, key);
        }
    }
}

