/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LECmdErrorDialog
extends Dialog
implements ActionListener {
    LEVector m_errors;
    Button m_next;
    Button m_done;
    TextField m_cmd;
    TextArea m_error;

    public LECmdErrorDialog(Frame parent, LEConnectionFacade facade, LEVector errors) {
        super(parent, true);
        this.setTitle("Command Error");
        this.m_errors = errors;
        this.setLayout(new BorderLayout());
        Component[][] comps = new Component[3][2];
        comps[0][0] = new Label("Device:", 0);
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[1][0] = new Label("Command:", 0);
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[2][0] = new Label("Error:", 0);
        comps[2][0].setFont(LEFont.getBoldFont());
        comps[0][1] = new Label(facade.getDescription(), 0);
        this.m_cmd = new TextField(40);
        comps[1][1] = this.m_cmd;
        this.m_cmd.setEditable(false);
        this.m_error = new TextArea(4, 40);
        comps[2][1] = this.m_error;
        this.add("Center", new LECompGrid(comps, 5, false));
        Panel btns = new Panel();
        btns.setLayout(new FlowLayout(1));
        Panel sub = new Panel();
        sub.setLayout(new GridLayout(1, 2, 5, 5));
        this.m_next = new Button("Next");
        sub.add(this.m_next);
        this.m_next.addActionListener(this);
        this.m_done = new Button("Done");
        sub.add(this.m_done);
        this.m_done.addActionListener(this);
        btns.add(sub);
        this.add("South", btns);
        this.showNextError();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_next) {
            this.showNextError();
        } else {
            ((Component)this).setVisible(false);
        }
    }

    public void addNotify() {
        super.addNotify();
        Dimension dim = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dim.width, dim.height);
    }

    void showNextError() {
        LEPMCommand cmd = (LEPMCommand)this.m_errors.removeElementAt(0);
        if (this.m_errors.size() == 0) {
            this.m_next.setEnabled(false);
        }
        ((TextComponent)this.m_cmd).setText(cmd.getCommand());
        String res = cmd.getResult();
        if (res == null) {
            this.m_error.setText("");
        } else {
            this.m_error.setText(res);
        }
    }
}

