/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LEIPSecSAsForm;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPIPSA;
import com.lucent.ra.nms.model.LEIPIPSAs;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LESAs;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPIPSAsForm
extends LETableForm {
    String m_addName;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label(String.valueOf(keySpec.getDescription()) + ":");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPIP SA", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An SA name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LESAs sas = (LESAs)pm.get("2424832");
        if (sas.getSA(this.m_addName) == null) {
            LEIPIPSAs table = (LEIPIPSAs)this.getTable(pm);
            LEVector errors = table.add(this.m_addName);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addName);
            entry = new LENewEntry(pm, table, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains an SA named " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEIPIPSAs)) {
            return;
        }
        LEIPIPSAs sa = (LEIPIPSAs)table;
        LEVector errors = sa.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        if (!(obj instanceof LEIPIPSA)) {
            return null;
        }
        LEIPIPSA sa = (LEIPIPSA)obj;
        LEIPIPSAs sas = (LEIPIPSAs)this.getTable(pm);
        String name = sa.getName();
        LESAs allSAs = (LESAs)pm.get("2424832");
        if (allSAs.getSA(name) != null) {
            name = LEIPSecSAsForm.GetUniqueKey(allSAs, name, 8);
        }
        if ((errors = sas.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }
}

