/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPRangesForm
extends LETableForm {
    private static final int MAX_RANGES = 8;
    String m_range;
    String m_size;
    String m_gateway;
    int m_numRanges;

    void addEntry(String host, LETable table, String key) {
        if (table instanceof LEIPRanges) {
            this.m_numRanges = table.size();
        }
        super.addEntry(host, table, key);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        if (this.m_numRanges < 8) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            Component[][] comps = new Component[3][2];
            comps[0][0] = new Label(String.valueOf(keySpec.getDescription()) + ": ");
            comps[0][0].setFont(LEFont.getBoldFont());
            comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
            LEDataSpec spec = entrySpec.getSpecFor("15");
            comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
            comps[1][0].setFont(LEFont.getBoldFont());
            comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
            spec = entrySpec.getSpecFor("522");
            comps[2][0] = new Label(String.valueOf(spec.getDescription()) + ":");
            comps[2][0].setFont(LEFont.getBoldFont());
            comps[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
            panel.add("Center", new LECompGrid(comps, 2, false));
            LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IP Pool Range", panel);
            if (dlg.okay()) {
                this.m_range = ((LEFormLine)((Object)comps[0][1])).getValue();
                this.m_size = ((LEFormLine)((Object)comps[1][1])).getValue();
                this.m_gateway = ((LEFormLine)((Object)comps[2][1])).getValue();
                if (this.m_range.length() == 0) {
                    new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An address must be specified");
                    return false;
                }
                return true;
            }
            return false;
        }
        StringBuffer errbuf = new StringBuffer();
        errbuf.append("You cannont have more than ");
        errbuf.append(8);
        errbuf.append(" ranges in an IP Pool.");
        LEErrorDialog errdialog = new LEErrorDialog(LEUiUtils.GetBaseFrame(), errbuf.toString());
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEIPRanges table = (LEIPRanges)this.getTable(pm);
        LEVector errors = null;
        if (table.get(this.m_range) == null) {
            errors = table.add(this.m_range, this.m_size, this.m_gateway);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            } else {
                this.addEntry(pm.getDescription(), table, this.m_range);
                entry = new LENewEntry(pm, table, this.m_range);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "The IP pool already has a range of " + this.m_range);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEIPRanges)) {
            return;
        }
        LEIPRanges ranges = (LEIPRanges)table;
        try {
            LEVector errors = ranges.delete(key);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
        }
        catch (NumberFormatException e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

