/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPSecProfileForm
extends LETableForm {
    private static final int MAX_RULES = 20;
    int m_numRules;
    String m_pfilter;
    String m_sa;

    void addEntry(String host, LETable table, String key) {
        if (table instanceof LEIPSecProfile) {
            this.m_numRules = table.size();
        }
        super.addEntry(host, table, key);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("Rule Number:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPSec Profile Rule Number", panel);
        if (dlg.okay()) {
            if (!Integer.toString(this.m_numRules + 1).equals(((LEFormLine)((Object)comp)).getValue())) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Rule number must be 1 + current rule count");
                return false;
            }
            if (this.m_numRules >= 20) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Rule no. must be less than " + Integer.toString(20));
                return false;
            }
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEIPSecProfile table = (LEIPSecProfile)this.getTable(pm);
        if (!this.getFilterAndSA(pm, table)) {
            return null;
        }
        LEVector errors = table.add(this.m_pfilter, this.m_sa);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            this.refresh();
        } else {
            String key = Integer.toString(table.size());
            this.addEntry(pm.getDescription(), table, key);
            entry = new LENewEntry(pm, table, key);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEIPSecProfile)) {
            return;
        }
        LEIPSecProfile prof = (LEIPSecProfile)table;
        try {
            int rule = Integer.parseInt(key);
            LEVector errors = prof.delete(rule);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
        }
        catch (NumberFormatException e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    boolean getFilterAndSA(LEPortMaster pm, LEIPSecProfile prof) {
        Object filter = null;
        LEDataSpec entrySpec = prof.getSpecFor("entry");
        LEDataSpec spec = entrySpec.getSpecFor("505");
        Component[][] comps = new Component[2][2];
        comps[0][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(pm, null, null, spec);
        spec = entrySpec.getSpecFor("506");
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(pm, null, null, spec);
        Panel panel = new Panel();
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Select Policy Filter and/or SA for " + pm.getDescription(), panel);
        if (dlg.okay()) {
            this.m_pfilter = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_sa = ((LEFormLine)((Object)comps[1][1])).getValue();
            if (this.m_pfilter.length() > 0 || this.m_sa.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A filter or Static SA must be specified");
        }
        return false;
    }
}

