/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEIPXAddressFormLine
extends Panel
implements LEFormLine,
ActionListener,
KeyListener,
MouseListener {
    public static final String SEP = new String(":");
    public static final String VALID = new String("00000000:000000000000 - FFFFFFFF:FFFFFFFFFFFF");
    LETextField m_network;
    LETextField m_mac;
    LEFormLineListener m_listener;

    public LEIPXAddressFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_network = new LETextField(8);
        this.add(this.m_network);
        this.m_network.setHex(true);
        this.m_network.addKeyListener(this);
        this.m_network.addActionListener(this);
        this.add(new Label(":", 1));
        this.m_mac = new LETextField(12);
        this.add(this.m_mac);
        this.m_mac.setHex(true);
        this.m_mac.addActionListener(this);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
    }

    public void setValue(Object field) {
        String str = field.toString();
        int sep = str.indexOf(SEP, 0);
        if (sep == -1) {
            ((TextComponent)this.m_network).setText(str);
        } else {
            ((TextComponent)this.m_network).setText(str.substring(0, sep));
            ((TextComponent)this.m_mac).setText(str.substring(sep + 1, str.length()));
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public String getValue() {
        int len;
        StringBuffer buf = new StringBuffer();
        String str = this.m_network.getText();
        int i = len = Math.min(str.length(), 8);
        while (i < 8) {
            buf.append('0');
            ++i;
        }
        buf.append(str.substring(0, len));
        buf.append(SEP);
        str = this.m_mac.getText();
        int i2 = len = Math.min(str.length(), 12);
        while (i2 < 12) {
            buf.append('0');
            ++i2;
        }
        buf.append(str.substring(0, len));
        return new String(buf);
    }

    public String getValidValues() {
        return VALID;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String newVal = this.getValue();
            return newVal.equals(oldVal);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyChar() == ':') {
            this.m_mac.requestFocus();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        this.notifyListener();
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent event = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(event);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

