/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEStringFormLine;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;

public class LEIntegerFormLine
extends LEStringFormLine {
    public static final int MAX_WIDTH = 12;
    boolean m_minFlag;
    long m_min;
    boolean m_maxFlag;
    long m_max = 65535L;
    long m_pad;
    String m_valid;

    public LEIntegerFormLine() {
        this.setColumns(12);
        this.setNumeric(true);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        super.initFormLine(pm, spec);
        if (spec != null) {
            String attr;
            if (spec.getAttribute(LEAttributes.HEX) != null) {
                this.setHex(true);
            }
            if ((attr = (String)spec.getAttribute(LEAttributes.MAXIMUM)) != null) {
                try {
                    this.m_max = this.isHex() ? Long.parseLong(attr, 16) : Long.parseLong(attr);
                    this.m_maxFlag = true;
                    this.setColumns(attr.length());
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            if ((attr = (String)spec.getAttribute(LEAttributes.MINIMUM)) != null) {
                try {
                    this.m_min = this.isHex() ? Long.parseLong(attr, 16) : Long.parseLong(attr);
                    this.m_minFlag = true;
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            if ((attr = (String)spec.getAttribute(LEAttributes.PADLENGTH)) != null) {
                try {
                    this.m_pad = Long.parseLong(attr);
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            if (this.m_minFlag || this.m_maxFlag) {
                this.setBounds(this.m_min, this.m_max);
            }
        }
    }

    public String getValue() {
        String str = this.isHex() ? Long.toString(this.getLongValue(), 16) : Long.toString(this.getLongValue());
        int len = str.length();
        len = str.length();
        if (this.m_pad > 0L && (this.m_minFlag || len > 0)) {
            len = (int)Math.min((long)len, this.m_pad);
            StringBuffer buf = new StringBuffer();
            int i = len;
            while ((long)i < this.m_pad) {
                buf.append('0');
                ++i;
            }
            buf.append(str.substring(0, len));
            str = new String(buf);
        }
        return str;
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer("Any integer");
            if (this.m_minFlag && this.m_maxFlag) {
                buf.append(" between ");
                buf.append(this.m_min);
                buf.append(" and ");
                buf.append(this.m_max);
            } else if (this.m_minFlag) {
                buf.append(" greater than ");
                buf.append(this.m_min);
            } else if (this.m_maxFlag) {
                buf.append(" less than ");
                buf.append(this.m_min);
            }
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String curVal = this.getText();
            if (curVal.length() == 0 && oldVal.length() == 0) {
                return true;
            }
            long val = this.getLongValue();
            try {
                long tmp = 0L;
                tmp = this.isHex() ? Long.parseLong(oldVal, 16) : Long.parseLong(oldVal);
                return tmp == val;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return false;
    }

    public boolean isValueValid() {
        long val = this.getLongValue();
        if (this.m_minFlag && val < this.m_min) {
            return false;
        }
        return !this.m_maxFlag || val <= this.m_max;
    }

    long getLongValue() {
        long val;
        block4: {
            String str = this.getText();
            long l = val = this.m_minFlag ? this.m_min : 0L;
            if (str.length() <= 0) break block4;
            try {
                val = this.isHex() ? Long.parseLong(str, 16) : Long.parseLong(str);
                if (this.m_minFlag) {
                    val = Math.max(val, this.m_min);
                }
                if (this.m_maxFlag) {
                    val = Math.min(val, this.m_max);
                }
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return val;
    }
}

