/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LELocationsForm
extends LETableForm {
    String m_addName;

    public LELocationsForm() {
        this.m_renameEntries = true;
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("Location Name:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Location", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A location name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LELocations table = (LELocations)this.getTable(pm);
        if (table.get(this.m_addName) == null) {
            LEVector errors = table.add(this.m_addName);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addName);
            entry = new LENewEntry(pm, table, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a location named " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LELocations)) {
            return;
        }
        LELocations locs = (LELocations)table;
        LEVector errors = locs.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        String name;
        if (!(obj instanceof LELocation)) {
            return null;
        }
        LELocation loc = (LELocation)obj;
        LELocations locs = (LELocations)this.getTable(pm);
        if (locs.get(name = loc.getName()) != null) {
            name = LETableForm.GetUniqueKey(locs, name, 12);
        }
        if ((errors = locs.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }

    String renameEntry(LEPortMaster pm, LETable table, String name) {
        String newKey = null;
        LERenameDialog dlg = new LERenameDialog(LEUiUtils.GetBaseFrame(), table.getKeySpec(), name);
        String newName = dlg.getNewName();
        if (newName != null) {
            Object obj = table.get(newName);
            if (obj == null) {
                LEVector errors = ((LELocations)table).add(newName);
                if (errors == null) {
                    newKey = newName;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a location named " + newName);
            }
        }
        return newKey;
    }
}

