/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LEModemCanvas;
import com.lucent.ra.nms.forms.LEModemGraphicCanvas;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LECompMatrix;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEModemsForm
extends Panel
implements LEForm,
ActionListener,
LEObserver {
    LEVector m_context;
    String m_platform;
    LEPortMaster[] m_pms;
    Panel m_controls;
    Choice m_source;
    Choice m_type;
    TextField m_values;
    LECompMatrix m_matrix;
    int m_rows;
    int m_mpr;

    public LEModemsForm(int modemsPerRow) {
        this.m_mpr = modemsPerRow;
        this.setLayout(new BorderLayout(5, 5));
        this.m_controls = new Panel();
        this.m_controls.setLayout(new BorderLayout(5, 5));
        Panel west = new Panel();
        west.setLayout(new FlowLayout(0, 5, 0));
        west.add(new Label("Set"));
        this.m_source = new Choice();
        west.add(this.m_source);
        this.m_type = new Choice();
        this.m_type.add("All");
        this.m_type.add("Modems{s}");
        west.add(this.m_type);
        this.m_controls.add("West", west);
        this.m_values = new TextField();
        this.m_controls.add("Center", this.m_values);
        Panel east = new Panel();
        east.setLayout(new FlowLayout(0, 5, 0));
        Button btn = new Button("Available");
        btn.addActionListener(this);
        east.add(btn);
        east.add(new LEModemGraphicCanvas(1));
        east.add(new LEModemGraphicCanvas(0));
        btn = new Button("Last Call");
        east.add(btn);
        btn.addActionListener(this);
        east.add(new LEModemGraphicCanvas(3));
        east.add(new LEModemGraphicCanvas(0));
        btn = new Button("Busy");
        east.add(btn);
        btn.addActionListener(this);
        east.add(new LEModemGraphicCanvas(2));
        east.add(new LEModemGraphicCanvas(0));
        this.m_controls.add("East", east);
    }

    public LEModemsForm() {
        this(10);
    }

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        if (this.m_context.size() == 1) {
            this.m_type.add("Slot");
        }
    }

    public void setPortMasters(LEPortMaster[] pms) {
        boolean changed = false;
        if (this.m_pms == null || this.m_pms.length != pms.length) {
            changed = true;
        } else if (this.m_pms != null) {
            int i = 0;
            while (!changed && i < this.m_pms.length) {
                boolean found = false;
                int j = 0;
                while (!found && j < pms.length) {
                    if (this.m_pms[i] == pms[j]) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    changed = true;
                }
                ++i;
            }
        }
        if (changed) {
            this.gone();
            this.m_pms = pms;
            this.removeAll();
            this.m_source.removeAll();
            String[] rowTitles = this.getRowTitles();
            String[] colTitles = this.getColumnTitles();
            Component[][] comps = this.getFormComponents();
            this.m_matrix = new LECompMatrix(rowTitles, colTitles, comps, true);
            LEBorderPanel border = new LEBorderPanel(1);
            border.setLayout(new BorderLayout());
            border.add("Center", new LEScrollPanel(this.m_matrix));
            this.add("Center", border);
            this.add("South", this.m_controls);
            this.invalidate();
            this.validate();
        }
    }

    public void save(Frame parent) {
        if (this.m_pms == null) {
            return;
        }
        LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        boolean refresh = false;
        int i = 0;
        while (i < this.m_pms.length) {
            LEModems modems = this.getModemsFor(this.m_pms[i]);
            if (modems != null) {
                int j = 0;
                while (j < this.m_rows) {
                    LEModemCanvas canvas = (LEModemCanvas)this.m_matrix.getComponent(j, i);
                    int start = j * this.m_mpr;
                    int end = (j + 1) * this.m_mpr;
                    int k = start;
                    while (k < end) {
                        String modem = "M" + k;
                        String cur = (String)modems.get(modem);
                        if (cur != null) {
                            int state = canvas.getModemState(k);
                            switch (state) {
                                case 1: {
                                    if (!cur.equals("ADMIN") && !cur.equals("ACT(LC)")) break;
                                    modems.set(modem, "READY");
                                    break;
                                }
                                case 2: {
                                    if (!cur.equals("ACT(LC)") && !cur.equals("READY")) break;
                                    modems.set(modem, "ADMIN");
                                    break;
                                }
                                case 3: {
                                    if (!cur.equals("READY")) break;
                                    modems.set(modem, "ACT(LC)");
                                    break;
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                LEVector errors = modems.saveChanges();
                if (errors != null) {
                    refresh = true;
                    new LECmdErrorDialog(LEUiUtils.getFrame(this), modems.getConnectionFacade(), errors);
                }
            }
            ++i;
        }
        if (refresh) {
            this.refresh();
        }
        dlg.hideStatus();
    }

    public void refresh() {
        if (this.m_pms == null) {
            return;
        }
        LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int i = 0;
        while (i < this.m_pms.length) {
            LEModems modems = this.getModemsFor(this.m_pms[i]);
            if (modems != null) {
                modems.refresh();
            }
            ++i;
        }
        dlg.hideStatus();
    }

    public void gone() {
        if (this.m_pms != null) {
            int i = 0;
            while (i < this.m_pms.length) {
                LEModems modems = this.getModemsFor(this.m_pms[i]);
                if (modems != null) {
                    modems.deleteObserver(this);
                }
                ++i;
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        block15: {
            String source = this.m_source.getSelectedItem();
            int col = -1;
            int i = 0;
            while (i < 3) {
                if (source.equals(this.m_matrix.getColTitle(i))) {
                    col = i;
                }
                ++i;
            }
            LEModems modems = null;
            if (col > -1) {
                modems = this.getModemsFor(this.m_pms[col]);
            }
            if (modems == null) break block15;
            String action = event.getActionCommand();
            int act = action.equals("Available") ? 1 : (action.equals("Last Call") ? 3 : 2);
            if (this.m_type.getSelectedItem().equals("All")) {
                int i2 = 0;
                while (i2 < this.m_rows) {
                    LEModemCanvas canvas = (LEModemCanvas)this.m_matrix.getComponent(i2, col);
                    if (canvas != null) {
                        int j = 0;
                        while (j < this.m_mpr) {
                            int modem = i2 * this.m_mpr + j;
                            canvas.changeModem(modem, act);
                            ++j;
                        }
                    }
                    ++i2;
                }
            } else if (this.m_type.getSelectedItem().equals("Slot")) {
                LEVector vals = this.parseValues(this.m_values.getText());
                int len = vals.size();
                int i3 = 0;
                while (i3 < len) {
                    LEModemCanvas canvas;
                    int slot = (Integer)vals.elementAt(i3);
                    if (slot > -1 && slot < this.m_rows && (canvas = (LEModemCanvas)this.m_matrix.getComponent(slot, col)) != null) {
                        int j = 0;
                        while (j < this.m_mpr) {
                            int modem = slot * this.m_mpr + j;
                            canvas.changeModem(modem, act);
                            ++j;
                        }
                    }
                    ++i3;
                }
            } else {
                LEVector vals = this.parseValues(this.m_values.getText());
                int len = vals.size();
                int i4 = 0;
                while (i4 < len) {
                    int modem = (Integer)vals.elementAt(i4);
                    int row = modem / this.m_mpr;
                    LEModemCanvas canvas = (LEModemCanvas)this.m_matrix.getComponent(row, col);
                    if (canvas != null) {
                        canvas.changeModem(modem, act);
                    }
                    ++i4;
                }
            }
        }
    }

    public void update(LEObservable obs, Object arg) {
        String host = null;
        String modem = null;
        if (obs instanceof LEConfig) {
            host = ((LEConfig)obs).getConnectionFacade().getDescription();
        }
        if (arg instanceof String) {
            modem = (String)arg;
        }
        if (host != null && modem != null) {
            this.updateModem(host, modem);
        }
    }

    String[] getRowTitles() {
        int max = -1;
        int i = 0;
        while (i < this.m_pms.length) {
            LEModems modems = this.getModemsFor(this.m_pms[i]);
            if (modems != null) {
                LEVector keys = modems.getKeys();
                int len = keys.size();
                int j = 0;
                while (j < len) {
                    String key = (String)keys.elementAt(j);
                    key = key.substring(1);
                    int num = Integer.parseInt(key);
                    max = Math.max(max, num);
                    ++j;
                }
            }
            ++i;
        }
        this.m_rows = (max - 1) / this.m_mpr + 1;
        if (this.m_rows < 0) {
            this.m_rows = 0;
        }
        String[] titles = new String[this.m_rows];
        int i2 = 0;
        while (i2 < this.m_rows) {
            titles[i2] = "M" + i2 * this.m_mpr + " - M" + ((i2 + 1) * this.m_mpr - 1);
            ++i2;
        }
        return titles;
    }

    String[] getColumnTitles() {
        String[] titles = new String[this.m_pms.length];
        int i = 0;
        while (i < this.m_pms.length) {
            titles[i] = this.m_pms[i].getDescription();
            this.m_source.add(this.m_pms[i].getDescription());
            ++i;
        }
        return titles;
    }

    Component[][] getFormComponents() {
        Component[][] comps = new Component[this.m_rows][this.m_pms.length];
        int i = 0;
        while (i < this.m_pms.length) {
            LEModems modems = this.getModemsFor(this.m_pms[i]);
            if (modems != null) {
                modems.addObserver(this);
                int j = 0;
                while (j < this.m_rows) {
                    int start = j * this.m_mpr;
                    int end = start + this.m_mpr;
                    LEModemCanvas canvas = new LEModemCanvas(start, this.m_mpr);
                    comps[j][i] = canvas;
                    int k = start;
                    while (k < end) {
                        String key = "M" + k;
                        String modem = (String)modems.get(key);
                        if (modem == null || modem.equals("DOWN")) {
                            canvas.setModem(k, 0);
                        } else if (modem.equals("ADMIN")) {
                            canvas.setModem(k, 2);
                        } else if (modem.equals("ACT(LC)")) {
                            canvas.setModem(k, 3);
                        } else {
                            canvas.setModem(k, 1);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return comps;
    }

    LEModems getModemsFor(LEConfig config) {
        int len = this.m_context.size();
        int i = 0;
        while (config != null && i < len) {
            Object obj = config.get((String)this.m_context.elementAt(i));
            if (obj instanceof LEConfig) {
                config = (LEConfig)obj;
            }
            ++i;
        }
        if (config instanceof LEModems) {
            return (LEModems)config;
        }
        return null;
    }

    LEVector parseValues(String values) {
        LEVector ret = new LEVector();
        int len = values.length();
        int accum = -1;
        int start = -1;
        boolean range = false;
        int i = 0;
        while (i < len) {
            char c = values.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (accum > -1) {
                        accum = accum * 10 + Character.digit(c, 10);
                        break;
                    }
                    accum = Character.digit(c, 10);
                    break;
                }
                case '-': {
                    range = true;
                    start = accum;
                    accum = -1;
                    break;
                }
                case ',': {
                    this.process(ret, accum, start, range);
                    accum = -1;
                    start = -1;
                    range = false;
                    break;
                }
                default: {
                    accum = -1;
                    start = -1;
                    range = false;
                }
                case 'M': 
                case 'm': 
            }
            ++i;
        }
        this.process(ret, accum, start, range);
        return ret;
    }

    void process(LEVector values, int accum, int start, boolean range) {
        if (range) {
            if (start > -1 && accum > start) {
                int i = start;
                while (i <= accum) {
                    values.addElement(new Integer(i));
                    ++i;
                }
            }
        } else if (accum > -1) {
            values.addElement(new Integer(accum));
        }
    }

    void updateModem(String host, String modem) {
        int col = -1;
        int i = 0;
        while (col == -1 && i < this.m_pms.length) {
            if (host.equals(this.m_matrix.getColTitle(i))) {
                col = i;
            }
            ++i;
        }
        LEConfig modems = null;
        if (col > -1) {
            modems = this.getModemsFor(this.m_pms[col]);
        }
        if (modems != null) {
            String value = (String)modems.get(modem);
            int id = Integer.parseInt(modem.substring(1));
            int state = 0;
            if (value == null) {
                state = 0;
            } else if (value.equals("READY")) {
                state = 1;
            } else if (value.equals("ADMIN")) {
                state = 2;
            } else if (value.equals("ACT(LC)")) {
                state = 3;
            }
            int row = id / this.m_mpr;
            LEModemCanvas canvas = (LEModemCanvas)this.m_matrix.getComponent(row, col);
            if (canvas != null) {
                canvas.setModem(id, state);
            }
        }
    }
}

