/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LERoute;
import com.lucent.ra.nms.model.LERoutes;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LERoutesForm
extends LETableForm {
    String m_addDest;
    String m_addGateway;
    String m_addMetric;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] comps = new Component[3][2];
        comps[0][0] = new Label(String.valueOf(keySpec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        LEDataSpec spec = entrySpec.getSpecFor(LERoute.GATEWAY);
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        spec = entrySpec.getSpecFor(LERoute.METRIC);
        comps[2][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[2][0].setFont(LEFont.getBoldFont());
        comps[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Route", panel);
        if (dlg.okay()) {
            this.m_addDest = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_addGateway = ((LEFormLine)((Object)comps[1][1])).getValue();
            this.m_addMetric = ((LEFormLine)((Object)comps[2][1])).getValue();
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LERoutes table = (LERoutes)this.getTable(pm);
        if (table.get(this.m_addDest) == null) {
            LEVector errors = table.add(this.m_addDest, this.m_addGateway, this.m_addMetric);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addDest);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a route to " + this.m_addDest);
        }
        return null;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LERoutes)) {
            return;
        }
        LERoute route = (LERoute)table.get(key);
        String source = (String)route.get(LERoute.SOURCE);
        String status = (String)route.get(LERoute.STATUS);
        if (!source.equals("local") || !status.equals("static")) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Route " + key + " on " + pm.getDescription() + " cannot be deleted");
            return;
        }
        String obsolete = (String)route.get(LERoute.OBSOLETE);
        if (obsolete != null && !obsolete.equals("0")) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Route " + key + " on " + pm.getDescription() + " has already been deleted");
            return;
        }
        LERoutes rts = (LERoutes)table;
        LEVector errors = rts.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    void pasteEntryTo(LEPortMaster pm, Object obj) {
        String key = this.getPasteKey(pm, obj);
        if (key == null) {
            return;
        }
        this.updateEntry(pm.getDescription(), this.getTable(pm), key);
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        String name;
        if (!(obj instanceof LERoute)) {
            return null;
        }
        LERoute route = (LERoute)obj;
        LERoutes routes = (LERoutes)this.getTable(pm);
        if (routes.get(name = route.getName()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a route to " + name);
            name = null;
        } else {
            String gateway = (String)route.get(LERoute.GATEWAY);
            String metric = (String)route.get(LERoute.METRIC);
            if (gateway == null || metric == null) {
                return null;
            }
            LEVector errors = routes.add(name, gateway, metric);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                name = null;
            }
        }
        return name;
    }
}

